C:::::      ,,,,,MPRMAX.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine MPRMAX(rwork,rmax,l)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      M P R M A X   performs the computation of the local        ***
C**                    maximum norm.                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include 'bytes.h'
      integer            l
C**                                                                 ***
      double precision   rwork(l/ireal),rmax(l/ireal)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C rwork  I  R   I in  I  work array with received maximum norms
C        I      I     I                           array: rwork(l/ireal)
C--------I------I-----I------------------------------------------------
C rmax   I  R   I i/o I  input : local maximum norms
C        I      I     I  output: computed maximum norms from local and
C        I      I     I          received norms    array: rmax(l/ireal)
C--------I------I-----I------------------------------------------------
C l      I  I   I in  I  length of the above mentioned arrays
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer          i
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      do 10 i=1,l/ireal
        rmax(i)=max(rmax(i),rwork(i))
 10   continue
 
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF MPRMAX---------------------------------------------------
      e    n    d
