C:::::      ,,,,,IDEVEM...                                          ***
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDEVEM (LIVEM,IVEM,LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                   LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                   NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**  IDEVEM    reads I-DEAS universal file to vecfem mesh arrays    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,LRDPRM,LIDPRM,LNOD,
     &                  LNODN,LDNOD,LNOPRM,LBIG

      DOUBLE PRECISION  RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),RBIG(LBIG)
      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),DNOD(LDNOD),
     &                  IDPARM(LIDPRM),NODNUM(LNODN),IBIG(RPI*LBIG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters : see user's guide                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,MESH,LOUT,NK,DIM,UNITIN,TIDS,
     &                  ERR,OUTCNT,MYPROC,IOTID,MYTID,TOTNE,
     &                  NPROC,GNDEG,GNDC,NMSG,NDEG,NN,
     &                  MAXTYP,NOP,GINFO,GINFO1,DINFO,DINFO1,
     &                  NINFO,LIBUF,LRBUF,IBUF,RBUF,LENTAB,LCNDEG,
     &                  LCNE,LCNDC,NIVEM,COMP6,NBIG,
     &                  LLNGTH(16),NLNGTH(16),I,MPINFO,SBT
      INTEGER           GNE(0:3,8,32),GROUP(0:3,8,32)
      DOUBLE PRECISION  TIMEA,TIMEE,VEMSCD
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TIMEA = VEMSCD()
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize variables:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      TIDS=204
      IF ((ARCHI.LT.10).OR.(IVEM(200).EQ.1)) THEN
	IVEM(200)=1
	IVEM(201)=1
	IVEM(TIDS-1)=1
	IVEM(TIDS)=1
      ENDIF
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF

      MESH=IVEM(1)
      NK=MAX(IVEM(MESH+2),1)
      DIM=MIN(MAX(IVEM(MESH+3),1),3)
      LOUT=IVEM(120)
      IF (LOUT .LE. 0) LOUT = 6
      OUTCNT=MAX(0,IVEM(121))
      UNITIN=IVEM(122)
      COMP6=IVEM(124)
      IF (COMP6.EQ.0) NK=MIN(NK,6)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      IVEM(203)=IVEM(TIDS)
      IOTID=IVEM(203)
      MYTID=IVEM(TIDS-1+MYPROC)
      MESH=MAX(MESH,204+NPROC)
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=0
      DO  130 I=1,16
130     NLNGTH(I)=0
      ERR=0
      NOP=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print header :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      CALL VEM000('IDEVEM',OUTCNT,LOUT)
      IF (OUTCNT.GT.0) THEN
	WRITE(LOUT,9120) 1,MESH
	WRITE(LOUT,9121) 122,UNITIN
	WRITE(LOUT,9122) 124,COMP6
	IF (COMP6.EQ.0) THEN
	  WRITE(LOUT,9124)
	ELSE
	  WRITE(LOUT,9123)
        ENDIF
	WRITE(LOUT,9130) MESH+2,NK
	WRITE(LOUT,9140) MESH+3,DIM
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** statistic of the input file:                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        CALL IDVE01 (UNITIN,GNDEG,GNE,GROUP,NGROUP,TOTNE,
     &               NK,COMP6,GNDC,LOUT,OUTCNT,ERR)
      ENDIF

      LENTAB=1
      LCNDEG=LENTAB+NPROC*9
      LCNE=LCNDEG+NPROC
      LCNDC=LCNE+NPROC
      IBUF=LCNDC+NPROC
      NBIG=(IBUF-1+RPI-1)/RPI
      NLNGTH(4)=NBIG
      CALL VEM098('IDEVEM',ERR,NK,DIM,LLNGTH,NLNGTH,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),IVEM(19),OUTCNT,
     &            LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffers:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      CALL VEMU30 (DIM,NOP,NK,COMP6,LLNGTH(5),NLNGTH(5),
     &             MAXTYP,NGROUP,GINFO,GINFO1,DINFO,DINFO1,NINFO,
     &             LIBUF,LRBUF,GNDEG,TOTNE,GNE,GNDC,IBIG(LENTAB),
     &             IBIG(LCNDEG),IBIG(LCNE),IBIG(LCNDC),
     &             MYPROC,IOTID,NPROC,IVEM(TIDS),IVEM(NMSG))
      RBUF=(IBUF-1+LIBUF+RPI-1)/RPI+1
      NBIG=MAX((RBUF-1)+LRBUF,NBIG)
      NIVEM=MESH+NINFO+1
      NLNGTH(1)=NIVEM
      NLNGTH(4)=NBIG
      CALL VEM098('IDEVEM',ERR,NK,DIM,LLNGTH,NLNGTH,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),IVEM(19),
     &            OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set IVEM :                                                    ***
C**   --------                                                      ***
C**                                                                 ***
      IF (MYPROC.EQ.1) REWIND(UNITIN)
      IVEM(1)=MESH
      IVEM(MESH+2)=NK
      IVEM(MESH+3)=DIM
      IVEM(MESH+4)=NGROUP
      IVEM(MESH+14)=NOP
      IVEM(MESH+15)=0
      IVEM(MESH+18)=0
      IVEM(MESH+21)=GINFO
      IVEM(MESH+22)=GINFO1
      IVEM(MESH+23)=DINFO
      IVEM(MESH+24)=DINFO1
      GINFO=GINFO+MESH
      DINFO=DINFO+MESH
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read node coordinates :                                       ***
C**   ---------------------                                         ***
C**                                                                 ***
      CALL IDVE02 (UNITIN,DIM,NDEG,NN,LNODN,NODNUM,LNOD,NOD,
     &             GNDEG,IBIG(LCNDEG),LIBUF,IBIG(IBUF),LRBUF,
     &             RBIG(RBUF),MYPROC,IOTID,NPROC,IVEM(TIDS),
     &             IVEM(NMSG))
      IVEM(MESH+1)=NDEG
      IVEM(MESH+5)=NN
      IVEM(MESH+6)=NDEG
      NLNGTH(5)=NDEG
      NLNGTH(6)=NN*DIM
      NLNGTH(7)=NDEG*NOP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read elements :
C**   -------------                                                 ***
C**                                                                 ***
      CALL IDVE03 (UNITIN,NGROUP,GINFO1,IVEM(GINFO),LNEK,NEK,NLNGTH(8),
     &             LIPARM,IPARM,NLNGTH(9),LRPARM,RPARM,NLNGTH(10),
     &             TOTNE,IBIG(LCNE),GNE,GROUP,
     &             LIBUF,IBIG(IBUF),LRBUF,RBIG(RBUF),
     &             MYPROC,IOTID,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read Dirichlet conditions :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      CALL IDVE04 (UNITIN,COMP6,NK,DINFO1,IVEM(DINFO),LDNOD,DNOD,
     &             NLNGTH(11),LIDPRM,IDPARM,NLNGTH(12),LRDPRM,RDPARM,
     &             NLNGTH(13),GNDC,IBIG(LCNDC),
     &             LIBUF,IBIG(IBUF),LRBUF,RBIG(RBUF),
     &             MYPROC,IOTID,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** global error :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      CALL VEM098('IDEVEM',ERR,NK,DIM,LLNGTH,NLNGTH,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),IVEM(19),
     &            OUTCNT,LOUT)
C**                                                                 ***
 9999 TIMEE = VEMSCD()-TIMEA
      CALL VEM097('IDEVEM',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIMEE,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9120  FORMAT ('    start of mesh informations ............... MESH =',
     &        ' IVEM(',I3,') = ',I10)
9121  FORMAT ('    unit of input file ............................ =',
     &        ' IVEM(',I3,') = ',I10)
9122  FORMAT ('    handling of Dirichlet conditions ........ COMP6 =',
     &        ' IVEM(',I3,') = ',I10)
9123  FORMAT ('      => restrain set id specifies the component.')
9124  FORMAT ('      => restrain set id specifies parameter.')
9130  FORMAT ('    number of components ....................... NK =',
     &        ' IVEM(',I3,') = ',I10)
9140  FORMAT ( '    dimension ................................. DIM =',
     &        ' IVEM(',I3,') = ',I10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation:                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of IDEVEM ---------------------------------------------------
      E    N    D
