C:::::      ,,,,,IDVE01...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDVE01 (UNITIN,GNDEG,GNE,GROUP,NGROUP,TOTNE,NK,COMP6,
     &                   GNDC,LOUT,OUTCNT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   IDVE01    computes a statistics of an I-DEAS universal file   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**               >                                                 ***
      INTEGER      UNITIN,GNDEG,NGROUP,TOTNE,GNDC,
     &             NK,COMP6,LOUT,OUTCNT,ERR
      INTEGER      GNE(0:3,8,32),GROUP(0:3,8,32)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of universal file
C--------I------I-----I------------------------------------------------
C GNDEG  I  I   I out I global number of geometrical nodes
C--------I------I-----I------------------------------------------------
C GNE    I  I   I out I GNE(CLASS,FORM,GEOTYP) number of elements
C        I      I     I element type (CLASS,FORM,GEOTYP)
C        I      I     I                            array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I out I GROUP(CLASS,FORM,GEOTYP) is the group id of
C        I      I     I element type (CLASS,FORM,GEOTYP)
C        I      I     I                            array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I out I number of groups (including node forces)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I out I total number of element (including node forces)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C COMP6  I  I   I in  I <>0  the restrain set id defines the component
C        I      I     I      for which the restrain set nodes have to be
C        I      I     I      interpreted as dirichlet conditions
C--------I------I-----I------------------------------------------------
C GNDC   I  I   I out I  number of nodes with dirichlet conditions
C        I      I     I  and different restrain id.
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I >0 a protocol is printed
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code =0 no error
C        I      I     I            =99 read error
C        I      I     I            =96 illegal element or load type
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include           "bytes.h"
      INTEGER           I,DSET,LNUM,LTYPE,RSET,RTYPE,ELID,
     &                  CLASS,FORM,GEOTYP,KC,NCARD,ELNUM,PHYID,
     &                  H1,H2,H3,H4,NFORCE,NDISP,ZW(32)
      CHARACTER*80      RECORD,LINE,LSNAME,RSNAME,TITLE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 10 CLASS=0,3
        DO 10 FORM=1,8
          DO 10 GEOTYP=1,32
	    GROUP(CLASS,FORM,GEOTYP)=0
 10         GNE(CLASS,FORM,GEOTYP)=0
      GNDC=0
      GNDEG=0
      WRITE(LINE,'(I6)') -1
      IF (OUTCNT.GT.0) WRITE(LOUT,9000)
      ERR=0
      NCARD=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** look to the data set type :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
100   READ(UNITIN,'(80A)',ERR=9999,END=8888) RECORD
      NCARD=NCARD+1
      READ(UNITIN,'(I6)',ERR=9999,END=9999) DSET
      NCARD=NCARD+1
      IF (DSET.EQ.151) GOTO 1000
      IF ((DSET.EQ.781).OR.(DSET.EQ.2411)) GOTO 2000
      IF ((DSET.EQ.780).OR.(DSET.EQ.2412)) GOTO 3000
      IF ((DSET.EQ.782).OR.(DSET.EQ.790)) GOTO 4000
      IF ((DSET.EQ.755).OR.(DSET.EQ.791)) GOTO 5000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** data set type is not read : serach next '-1'                  ***
C**   -------------------------                                     ***
C**                                                                 ***
7000  READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+1
      IF (RECORD .EQ. LINE) GOTO 100
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read the title (data set 151):                                ***
C**   -----------------------------                                 ***
C**                                                                 ***
1000  READ (UNITIN,'(80A)',ERR=9999,END=9999) TITLE
      NCARD=NCARD+1
      IF (OUTCNT.GT.0) WRITE(LOUT,9005) TITLE
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** node data (data set 781/2411):                                ***
C**   ----------------------------                                  ***
C**                                                                 ***
2000  READ (UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+1
      IF (RECORD .EQ. LINE) GOTO 100
      READ (UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+1
      GNDEG=GNDEG+1
      GOTO 2000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** element data (data set 780/2412):                             ***
C**   --------------------------------                              ***
C**                                                                 ***
3000  READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+1
      IF (RECORD .EQ. LINE) GOTO 100
      IF (DSET.EQ.780) THEN
        READ(RECORD,'(8I10)',ERR=9999,END=9999)
     &                             ELNUM,ELID,H1,PHYID,H2,H3,H4,GEOTYP
      ELSE
        READ(RECORD,'(6I10)',ERR=9999,END=9999)
     &                                 ELNUM,ELID,PHYID,H1,H2,GEOTYP
      ENDIF
      CALL IDVE10(ELID,CLASS,FORM,GEOTYP,ZW)
      IF (CLASS.LT.0) THEN
	ERR=96
	WRITE(LOUT,9110) NCARD,ELID,NCARD
      ELSE
        GNE(CLASS,FORM,GEOTYP)=GNE(CLASS,FORM,GEOTYP)+1
      ENDIF
      KC=(GEOTYP+7)/8
      IF ((ELID.EQ.21).OR.(ELID.EQ.24)) KC=KC+1
      DO 3010 I=1,KC
        READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
3010    NCARD=NCARD+1
      GOTO 3000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** node forces (data set 782/790):                               ***
C**   ------------------------------                                ***
C**                                                                 ***
4000  READ(UNITIN,'(8I10)',ERR=9999,END=9999) LNUM,LTYPE
      NCARD=NCARD+1
      IF (LTYPE.NE.1) THEN
	ERR=96
	WRITE(LOUT,9120) NCARD,LTYPE,NCARD
      ENDIF
      READ(UNITIN,'(80A)',ERR=9999,END=9999) LSNAME
      NCARD=NCARD+1

      NFORCE=0
4010  READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+1
      IF (RECORD .EQ. LINE) THEN
        IF (OUTCNT.NE.0) THEN
          WRITE(LOUT,9030)
          WRITE(LOUT,9031) LSNAME
          WRITE(LOUT,9032) LNUM
          WRITE(LOUT,9033) LTYPE
          WRITE(LOUT,9034) NFORCE
        ENDIF
        GNE(0,1,1)=GNE(0,1,1)+NFORCE
	GOTO 100
      ENDIF
      NFORCE=NFORCE+1
      IF (DSET.EQ.782) THEN
        KC=1
      ELSE
        KC=3
      ENDIF
      DO 4011 I=1,KC
4011  READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+KC
      GOTO 4010
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***** Dirichlet conditions (data set 755/791):                     ***
C**    ---------------------------------------                      ***
C**                                                                 ***
5000  READ(UNITIN,'(8I10)',ERR=9999,END=9999) RSET,RTYPE
      NCARD=NCARD+1
      IF ((COMP6.NE.0).AND.((RSET.LT.1).OR.(RSET.GT.NK))) GOTO 7000
      IF (RTYPE.NE.1) THEN
	ERR=96
	WRITE(LOUT,9140) NCARD,RTYPE,NCARD
      ENDIF
      READ(UNITIN,'(80A)',ERR=9999,END=9999) RSNAME
      NCARD=NCARD+1

      NDISP=0
5010  READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+1
      IF (RECORD .EQ. LINE) THEN
        IF (OUTCNT.NE.0) THEN
          WRITE(LOUT,9035)
          WRITE(LOUT,9036) RSNAME
          WRITE(LOUT,9037) RSET
          WRITE(LOUT,9038) RTYPE
          WRITE(LOUT,9039) NDISP
        ENDIF
        GNDC=GNDC+NDISP
	GOTO 100
      ENDIF
      NDISP=NDISP+1
      IF (DSET.EQ.755) THEN
        KC=1
      ELSE
        KC=3
      ENDIF
      DO 5011 I=1,KC
5011  READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
      NCARD=NCARD+KC
      GOTO 5010
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the input file is defectiv :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
9999  ERR=99
      WRITE(LOUT,9130) NCARD+1,NCARD+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the number of element groups :                          ***
C**   ----------------------------------                            ***
C**                                                                 ***
8888  CONTINUE
      NGROUP=0
      TOTNE=0
      DO 20 CLASS=0,3
        DO 20 FORM=1,8
          DO 20 GEOTYP=1,32
            TOTNE=TOTNE+GNE(CLASS,FORM,GEOTYP)
            IF (GNE(CLASS,FORM,GEOTYP).GT.0) THEN
	       NGROUP=NGROUP+1
               GROUP(CLASS,FORM,GEOTYP)=NGROUP
            ENDIF
 20   CONTINUE
      IF (OUTCNT.GT.0) THEN
         WRITE(LOUT,9010) GNDEG
         WRITE(LOUT,9020) NGROUP
         WRITE(LOUT,9025) TOTNE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT(' file statistics:')
9005  FORMAT(3X,'model name :'/3X,75A)
9010  FORMAT(3X,'number of geometrical nodes ............ NDEG = ',I9)
9020  FORMAT(3X,'number of groups ..................... NGROUP = ',I9)
9025  FORMAT(3X,'total number of elements .................... = ',I9)
9030  FORMAT(3X,'load set found :')
9031  FORMAT(5X,'load set name ...................... LSNAME = ',A20)
9032  FORMAT(5X,'load set number ...................... LNUM = ',I9)
9033  FORMAT(5X,'load type ........................... LTYPE = ',I9)
9034  FORMAT(5X,'number of nodes ........................... = ',I9)
9035  FORMAT(3X,'restraint set found :')
9036  FORMAT(5X,'restraint set name ................. RSNAME = ',A20)
9037  FORMAT(5X,'restraint set number ................. RNUM = ',I9)
9038  FORMAT(5X,'restraint set type .................. RTYPE = ',I9)
9039  FORMAT(5X,'number of nodes ........................... = ',I9)
9120  FORMAT ('>>VEMCD:01:0005:',I9
     &      /'>>illegal load set type LTYPE = ',I6,'<> 1 in card ',I9)
9110  FORMAT ('>>VEMCD:01:0001:',I9
     &      /'>>illegal element type ELID = ',I6,' in card ',I9)
9130  FORMAT ('>>VEMCD:01:9999:',I9/'>>read error in card ',I9)
9140  FORMAT ('>>VEMCD:01:0006:',I9
     &  /'>>illegal restraint set type RTYPE = ',I6,'<> 1 in card ',I9)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation:                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of IDVE01-----------------------------------------------------
      E    N    D
