C:::::      ,,,,,IDVE03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDVE03 (UNITIN,NGROUP,GINFO1,GINFO,LNEK,NEK,NNEK,
     &                   LIPARM,IPARM,NIPARM,LRPARM,RPARM,NRPARM,
     &                   TOTNE,LCNE,GNE,GROUP,LIBUF,IBUF,LRBUF,RBUF,
     &                   MYPROC,IOTID,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   IDVE03   reads the elements from the i-deas                   ***
C**            universal file and distributes it to the             ***
C**            processes.                                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,NGROUP,GINFO1,LNEK,LIPARM,LIBUF,LRBUF,
     &                  MYPROC,IOTID,NPROC,NMSG,TOTNE,LRPARM,
     &                  NNEK,NIPARM,NRPARM
      DOUBLE PRECISION  RPARM(LRPARM),RBUF(LRBUF)
      INTEGER           NEK(LNEK),IPARM(LIPARM),LCNE(NPROC),
     &                  IBUF(LIBUF),GNE(0:3,8,32),GROUP(0:3,8,32),
     &                  GINFO(GINFO1,NGROUP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of universal file
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups (including node forces)
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I out I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I out I elements                       array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C NNEK   I  I   I out I needed length of NEK
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I out I integer element parameters
C        I      I     I                            array: IPARM(LIPARM)
C--------I------I-----I------------------------------------------------
C NIPARM I  I   I out I needed length of IPARM
C--------I------I-----I------------------------------------------------
C RPARM  I  R   I out I real element parameters
C        I      I     I                            array: RPARM(LRPARM)
C--------I------I-----I------------------------------------------------
C NRPARM I  I   I out I needed length of RPARM
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I out I total number of element (including node forces)
C        I      I     I  (only on io-process)
C--------I------I-----I------------------------------------------------
C GNE    I  I   I in  I  GNE(CLASS,FORM,GEOTYP) number of elements
C        I      I     I  element type (CLASS,FORM,GEOTYP)
C        I      I     I  (only on io-process)      array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I in  I  GROUP(CLASS,FORM,GEOTYP) is the group id of
C        I      I     I  element type (CLASS,FORM,GEOTYP)
C        I      I     I  (only on io-process)      array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C LNE    I  I   I in  I max. LCNE(P) elements are send to processor P
C        I      I     I (only on io-process)          array: LNE(NPROC)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer to distrubute mesh
C        I      I     I                              array: IBUF(LIBUF)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I  -  I real buffer to distrubute mesh
C        I      I     I                              array: RBUF(LRBUF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id of the process
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I physical process id of io-process
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I logical to physical process id map
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***

      include "bytes.h"
      INTEGER           P,MYTID,COUNT,N1,I,MESS(2),MIDS,INFO,MIDR,
     &                  CLASS,FORM,GEOTYP,G,ISTART,RSTART,SENDNE,NE,
     &                  E,ADDNEK,NEK1,ADRVP,RVP1,ADIVP,LNE,DSET(4),
     &                  NRVP,ICOMP(6),N3,FOUND,PYSID,LTYPE,ELID,
     &                  N4,N5,IVP1,ID
      CHARACTER*80      RECORD,LINE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NE=0
      MYTID=TIDS(MYPROC)
      DSET(1)=780
      DSET(2)=782
      DSET(3)=2412
      DSET(4)=790
      WRITE(LINE,'(I6)') -1
      NNEK=0
      NIPARM=0
      NRPARM=0
      IF (NGROUP.EQ.0) RETURN

      IF (MYTID.EQ.IOTID) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** search for the first card with elements :                   ***
C**     ----------------------------------------                    ***
C**                                                                 ***
        CALL IDVE09(UNITIN,4,DSET,FOUND)
	IF ((FOUND.EQ.782).OR.(FOUND.EQ.790)) THEN
           READ(UNITIN,'(8I10)') PYSID,LTYPE
           READ(UNITIN,'(80A)') RECORD
           ID=0
        ENDIF
        DO 1000 CLASS=0,3
          DO 1000 FORM=1,8
            DO 1000 GEOTYP=1,32
              G=GROUP(CLASS,FORM,GEOTYP)
              IF (G.GT.0) THEN
	        IBUF(1+G)=0
	        IBUF(1+G+NGROUP)=GEOTYP
	        IBUF(1+G+2*NGROUP)=FORM
	        IBUF(1+G+3*NGROUP)=CLASS
              ENDIF
1000    CONTINUE

	LNE=0
	DO 1010 P=NPROC,1,-1

	  ISTART=1+4*NGROUP+1
	  RSTART=1
 	  COUNT=0
	  DO 1020 I=1,NGROUP
1020        IBUF(1+I)=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** read elements till the quota of process P is fullfilled:  ***
C**       -------------------------------------------------------   ***
C**                                                                 ***
1030      CONTINUE
          IF ((COUNT.LT.LCNE(P)).AND.(LNE+COUNT.LT.TOTNE)) THEN
            READ (UNITIN,'(80A)') RECORD
            IF (RECORD.EQ.LINE) THEN
	      CALL IDVE09(UNITIN,4,DSET,FOUND)
	      IF ((FOUND.EQ.782).OR.(FOUND.EQ.790)) THEN
                READ(UNITIN,'(8I10)') PYSID,LTYPE
                READ(UNITIN,'(80A)') RECORD
                ID=0
              ENDIF
	      GOTO 1030
	    ENDIF
	    COUNT=COUNT+1
C**                                                                 ***
C********** elements :                                              ***
C**                                                                 ***
	    IF (FOUND.EQ.780) THEN
              READ(RECORD,'(8I10)') ID,ELID,N1,PYSID,N3,N4,N5,GEOTYP
              IF ((ELID.EQ.21).OR.(ELID.EQ.24)) THEN
                READ(UNITIN,'(80A)') RECORD
              ENDIF
	      READ(UNITIN,'(8I10)') (IBUF(ISTART+2+I),I=1,GEOTYP)
              CALL IDVE10(ELID,CLASS,FORM,GEOTYP,IBUF(ISTART+3))
              G=GROUP(CLASS,FORM,GEOTYP)
	    ELSEIF (FOUND.EQ.2412) THEN
              READ(RECORD,'(8I10)') ID,ELID,PYSID,N4,N5,GEOTYP
              IF ((ELID.EQ.21).OR.(ELID.EQ.24)) THEN
                READ(UNITIN,'(80A)') RECORD
              ENDIF
	      READ(UNITIN,'(8I10)') (IBUF(ISTART+2+I),I=1,GEOTYP)
              CALL IDVE10(ELID,CLASS,FORM,GEOTYP,IBUF(ISTART+3))
              G=GROUP(CLASS,FORM,GEOTYP)
C**                                                                 ***
C********** node forces :                                           ***
C**                                                                 ***
	    ELSEIF (FOUND.EQ.782) THEN
              READ(RECORD,'(8I10)') IBUF(ISTART+3),N1,(ICOMP(I),I=1,6)
              G=GROUP(0,1,1)
	      GEOTYP=1
	      READ(UNITIN,'(6E13.5)') (RBUF(RSTART-1+I),I=1,6)
	      RSTART=RSTART+6
	    ELSE
              READ(RECORD,'(8I10)') IBUF(ISTART+3),N1,(ICOMP(I),I=1,6)
              G=GROUP(0,1,1)
	      GEOTYP=1
	      READ(UNITIN,'(3D25.16)') (RBUF(RSTART-1+I),I=1,3)
	      READ(UNITIN,'(3D25.16)') (RBUF(RSTART-1+I),I=4,6)
              READ(UNITIN,'(80A)') RECORD
	      RSTART=RSTART+6
	    ENDIF
C**                                                                 ***
	    IBUF(ISTART)=G
	    IBUF(ISTART+1)=ID
	    IBUF(ISTART+2)=PYSID
            IBUF(1+G)=IBUF(1+G)+1
	    NE=NE-1
	    ISTART=ISTART+(GEOTYP+3)
	    GOTO 1030
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** send read elements to process p:                          ***
C**       -------------------------------                           ***
C**                                                                 ***
	  IBUF(1)=COUNT
 	  IF (IOTID.NE.TIDS(P)) THEN
	    MESS(1)=ISTART-1
	    MESS(2)=RSTART-1
	    CALL MPSNDA(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                        RBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                        RBUF,MIDS,INFO)
          ENDIF
	  LNE=LNE+COUNT

1010    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** receive the elements :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
C**   if IOTID is the first process the data are already on         ***
C**   IBUF and RBUF                                                 ***
C**                                                                 ***
      IF (IOTID.NE.MYTID) THEN
        CALL MPRCVA(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                         RBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                         RBUF,MIDR,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy data from buffers into mesh arrays:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      DO 2000 G=1,NGROUP
	GINFO(1,G)=0
	GINFO(3,G)=IBUF(1+G+2*NGROUP)
	GINFO(4,G)=IBUF(1+G+3*NGROUP)
	GINFO(9,G)=0
	GINFO(10,G)=NRPARM+1
	GINFO(11,G)=IBUF(1+G)
	IF (IBUF(1+G+NGROUP).EQ.1) THEN
	   GINFO(12,G)=6
        ELSE
	   GINFO(12,G)=0
        ENDIF
	GINFO(14,G)=0
	GINFO(15,G)=NIPARM+1
	GINFO(16,G)=IBUF(1+G)
	GINFO(17,G)=2
	GINFO(21,G)=NNEK+1
	GINFO(22,G)=IBUF(1+G)
	GINFO(24,G)=IBUF(1+G+NGROUP)
	NNEK=NNEK+IBUF(1+G)*IBUF(1+G+NGROUP)
	NIPARM=NIPARM+GINFO(16,G)*GINFO(17,G)
	NRPARM=NRPARM+IBUF(1+G)*GINFO(12,G)
2000  CONTINUE
      NNEK=NNEK*2
	
      IF ((NNEK.LE.LNEK).AND.(NIPARM.LE.LIPARM).AND.
     &                                        (NRPARM.LE.LRPARM)) THEN

	SENDNE=IBUF(1)
	ISTART=1+4*NGROUP+1
	RSTART=1
	
        DO 2020 E=1,SENDNE

	  G=IBUF(ISTART)
	  GEOTYP=GINFO(24,G)
	  NE=GINFO(1,G)
	  ADDNEK=GINFO(21,G)
	  NEK1=GINFO(22,G)
	  ADRVP=GINFO(10,G)
	  RVP1=GINFO(11,G)
	  NRVP=GINFO(12,G)
	  ADIVP=GINFO(15,G)
	  IVP1=GINFO(16,G)

	  IPARM(ADIVP+NE)=IBUF(ISTART+1)
	  IPARM(ADIVP+NE+IVP1)=IBUF(ISTART+2)
	  DO 2030 I=1,GEOTYP
2030        NEK(ADDNEK+NE+NEK1*(I-1))=IBUF(ISTART+2+I)
	  DO 2040 I=1,NRVP
2040        RPARM(ADRVP+NE+RVP1*(I-1))=RBUF(RSTART-1+I)

	  GINFO(1,G)=NE+1
	  ISTART=ISTART+(GEOTYP+3)
	  RSTART=RSTART+NRVP
2020    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of IDVE03----------------------------------------------------
      E    N    D
