C:::::      ,,,,,IDVE04...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDVE04 (UNITIN,COMP6,NK,DINFO1,DINFO,LDNOD,DNOD,NDNOD,
     &                   LIDPRM,IDPARM,NIDPRM,LRDPRM,RDPARM,NRDPRM,
     &                   GNDC,LCNDC,LIBUF,IBUF,LRBUF,RBUF,
     &                   MYPROC,IOTID,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    IDVE04   reads the Dirichlet conditons from the i-deas       ***
C**             universal file and distributes it to the            ***
C**             processes.                                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,NK,DINFO1,LDNOD,LIDPRM,LIBUF,LRBUF,
     &                  MYPROC,IOTID,NPROC,NMSG,GNDC,NRDPRM,NIDPRM,
     &                  LRDPRM,COMP6,NDNOD 
      DOUBLE PRECISION  RDPARM(LRDPRM),RBUF(LRBUF)
      INTEGER           DNOD(LDNOD),IDPARM(LIDPRM),LCNDC(NPROC),
     &                  IBUF(LIBUF),DINFO(DINFO1,NK),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of a universal file
C--------I------I-----I------------------------------------------------
C COMP6  I  I   I in  I =0 x,y,z,.. - constrain defines Dirichlet
C        I      I     I    conditions for component 1,2,3,...
C        I      I     I =1 x-constrain defines Dirichlet condition
C        I      I     I    IV defines the component
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I out I Dirichlet informations  array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I out I Dirichlet nodes              array: DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C NDNOD  I  I   I out I needed length of DNOD
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I out I integer Dirichlet parameters
C        I      I     I                           array: IDPARM(LIDPRM)
C--------I------I-----I------------------------------------------------
C NIDPRM I  I   I out I needed length of IDPARM
C--------I------I-----I------------------------------------------------
C RDPARM I  R   I out I real Dirichlet parameters
C        I      I     I                           array: RDPARM(LRDPRM)
C--------I------I-----I------------------------------------------------
C NRDPRM I  I   I out I needed length of RDPARM
C--------I------I-----I------------------------------------------------
C GNDC   I  I   I in  I total number of Dirichlet conditions
C        I      I     I (only on io-process)
C--------I------I-----I------------------------------------------------
C LCNDC  I  I   I in  I max. LCNDC(P) conditions are send to processor P
C        I      I     I (only on io-process)         array: LCNDC(NPROC)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer to distrubute mesh
C        I      I     I                              array: IBUF(LIBUF)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I  -  I real buffer to distrubute mesh
C        I      I     I                              array: RBUF(LRBUF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id of the process
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I physical process id of io-process
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I logical to physical process id map
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***

      include "bytes.h"
      INTEGER           P,MYTID,COUNT,I,MESS(2),MIDS,INFO,MIDR,
     &                  ISTART,RSTART,SENDNC,NDC,ADRVDP,ADIVDP,
     &                  E,ADDC,LNDC,D,ICOMP(6),N3,N4,
     &                  DSET(2),RSET,FOUND,RTYPE,ID,N1,N2
      DOUBLE PRECISION  DDATA(6)
      CHARACTER*80      RECORD,LINE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DSET(1)=755
      DSET(2)=791
      NDNOD=0
      NIDPRM=0
      NRDPRM=0
      WRITE(LINE,'(I6)') -1
      MYTID=TIDS(MYPROC)
      IF (NK.EQ.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN

	LNDC=0
        CALL IDVE09(UNITIN,2,DSET,FOUND)
	IF ((FOUND.EQ.755).OR.(FOUND.EQ.791)) THEN
          READ(UNITIN,'(8I10)') RSET,RTYPE
          READ(UNITIN,'(80A)') RECORD
        ENDIF

	DO 1010 P=NPROC,1,-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** read data till the quota of process P is fullfilled:        ***
C**     ---------------------------------------------------         ***
C**                                                                 ***
	  ISTART=1+NK+1
	  RSTART=1
 	  COUNT=0
	  DO 1020 I=1,NK+1
1020        IBUF(I)=0

1030      CONTINUE
          IF ((COUNT.LT.LCNDC(P)).AND.(LNDC+COUNT.LT.GNDC)) THEN
            READ (UNITIN,'(80A)') RECORD
            IF (RECORD.EQ.LINE) THEN
   	      CALL IDVE09(UNITIN,2,DSET,FOUND)
	      IF ((FOUND.EQ.755).OR.(FOUND.EQ.791)) THEN
                READ(UNITIN,'(8I10)') RSET,RTYPE
                READ(UNITIN,'(80A)') RECORD
	        GOTO 1030
              ENDIF
	    ENDIF
	    COUNT=COUNT+1

            IF (FOUND.EQ.755) THEN
              READ(RECORD,'(2I10,7I2)') ID,N1,(ICOMP(I),I=1,6),N2
	      IF (N2.EQ.0) THEN
	        READ(UNITIN,'(6E13.5)') (DDATA(I),I=1,6)
              ELSE
	        READ(UNITIN,'(6E13.5)') DDATA(1)
	        DO 1050 I=2,6
1050              DDATA(I)=0
              ENDIF
            ELSE
              READ(RECORD,'(2I10,9I2)') ID,N1,(ICOMP(I),I=1,6),N2,N3,N4
	      READ(UNITIN,'(3D25.16)') (DDATA(I),I=1,3)
	      READ(UNITIN,'(3D25.16)') (DDATA(3+I),I=1,3)
              READ(UNITIN,'(80A)') RECORD
            ENDIF

	    IF (COMP6.EQ.0) THEN
	      DO 1060 D=1,NK
	        IF (ICOMP(D).NE.0) THEN
                  IBUF(1+D)=IBUF(1+D)+1
	          IBUF(1)=IBUF(1)+1
	          IBUF(ISTART)=D
		  IBUF(ISTART+1)=ID
		  IBUF(ISTART+2)=RSET
		  RBUF(RSTART)=DDATA(D)
	          ISTART=ISTART+3
	          RSTART=RSTART+1
                ENDIF
1060          CONTINUE
	    ELSE
	      D=RSET
	      IF ((1.LE.D).AND.(D.LE.NK).AND.(ICOMP(1).NE.0)) THEN
                IBUF(1+D)=IBUF(1+D)+1
	        IBUF(1)=IBUF(1)+1
	        IBUF(ISTART)=D
		IBUF(ISTART+1)=ID
		RBUF(RSTART)=DDATA(1)
	        ISTART=ISTART+2
	        RSTART=RSTART+1
              ENDIF
	    ENDIF
	    GOTO 1030
          ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** send read dat to prcocess P:                                ***
C**     ---------------------------                                 ***
C**                                                                 ***
 	  IF (IOTID.NE.TIDS(P)) THEN
	    MESS(1)=ISTART-1
	    MESS(2)=RSTART-1
	    CALL MPSNDA(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,2*IINT,MESS,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+NPROC+P,IINT*MESS(1),
     &                                        IBUF,MIDS,INFO)
	    CALL MPSNDA(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                        RBUF,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+2*NPROC+P,IREAL*MESS(2),
     &                                        RBUF,MIDS,INFO)
          ENDIF
	  LNDC=LNDC+COUNT

1010    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** receive the data:                                             ***
C**   ----------------                                              ***
C**                                                                 ***
C**   if IOTID is the first process the data are already on IBUF    ***
C**   and RBUF:                                                     ***
C**                                                                 ***
      IF (IOTID.NE.MYTID) THEN
        CALL MPRCVA(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,2*IINT,MESS,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+NPROC+MYPROC,IINT*MESS(1),
     &                                         IBUF,MIDR,INFO)
        CALL MPRCVA(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                         RBUF,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+2*NPROC+MYPROC,IREAL*MESS(2),
     &                                         RBUF,MIDR,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy data from buffers into mesh arrays:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      DO 2000 D=1,NK
	DINFO(1,D)=0
	DINFO(3,D)=NDNOD+1
	NDNOD=NDNOD+IBUF(1+D)

	DINFO(5,D)=0
	DINFO(6,D)=NRDPRM+1
	DINFO(7,D)=IBUF(1+D)
	DINFO(8,D)=1
	NRDPRM=NRDPRM+IBUF(1+D)

	DINFO(10,D)=0
	DINFO(11,D)=NIDPRM+1
	DINFO(12,D)=IBUF(1+D)
	IF (COMP6.EQ.0) THEN
	  DINFO(13,D)=1
	ELSE
	  DINFO(13,D)=0
	ENDIF
	NIDPRM=NIDPRM+DINFO(13,D)*DINFO(12,D)
2000  CONTINUE
      NDNOD=NDNOD*2
	
      IF ((NDNOD.LE.LDNOD).AND.(NIDPRM.LE.LIDPRM).AND.
     &                                (NRDPRM.LE.LRDPRM)) THEN

	SENDNC=IBUF(1)
	ISTART=1+NK+1
	RSTART=1
	
        DO 2020 E=1,SENDNC

	  D=IBUF(ISTART)
	  NDC=DINFO(1,D)
	  ADDC=DINFO(3,D)
	  ADRVDP=DINFO(6,D)
	  ADIVDP=DINFO(11,D)

	  DNOD(ADDC+NDC)=IBUF(ISTART+1)
	  IF (COMP6.EQ.0)  THEN
	    IDPARM(ADIVDP+NDC)=IBUF(ISTART+2)
	    RDPARM(ADRVDP+NDC)=RBUF(RSTART)
	    ISTART=ISTART+3
	    RSTART=RSTART+1
          ELSE
	    RDPARM(ADRVDP+NDC)=RBUF(RSTART)
	    ISTART=ISTART+2
	    RSTART=RSTART+1
          ENDIF

	  DINFO(1,D)=NDC+1
2020    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of IDVE04----------------------------------------------------
      E    N    D
