C:::::      ,,,,,IDVE09...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDVE09(UNITIN,NSET,DSET,FOUND)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   IDVE09    searchs for a specified data set in a universal     ***
C**             file. at the beginning the next record has to be    ***
C**             '-1' and then the DSET-record. at the end           ***
C**             the next record will be the first record            ***
C**             with data set informations.                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,NSET,FOUND
      INTEGER           DSET(NSET)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of universal file
C--------I------I-----I------------------------------------------------
C DSET   I  I   I in  I list of the requested data set ids
C        I      I     I array : DSET(NSET)
C--------I------I-----I------------------------------------------------
C FOUND  I  I   I out I data set id of the actual found data set
C        I      I     I  =-1 => data sets not found
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I
      LOGICAL           TEST,FIRST
      CHARACTER*80      RECORD,LINE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      WRITE(LINE,'(I6)') -1
      FIRST=.TRUE.
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read current data set :                                       ***
C**   ---------------------                                         ***
C**                                                                 ***
100   READ(UNITIN,'(80A)',END=8888,ERR=8888) RECORD
      READ(UNITIN,'(I6)',END=8888,ERR=8888) FOUND
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** found data set in the selection list ?                        ***
C**   ------------------------------------                          ***
C**                                                                 ***
      TEST=.FALSE.
      DO 10 I=1,NSET
10      IF (DSET(I).EQ.FOUND) TEST=.TRUE.
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** search for next '-1' line :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      IF (.NOT.TEST) THEN
1000     READ (UNITIN,'(80A)',END=8888,ERR=8888) RECORD
         IF (RECORD .EQ. LINE) GOTO 100
         GOTO 1000
      ELSE
	 GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** if the requested data set is not found the file is rewinded:  ***
C**   -----------------------------------------------------------   ***
C**                                                                 ***
8888  CONTINUE
      IF (FIRST) THEN
        REWIND(UNITIN)
	FIRST=.FALSE.
        GOTO 100
      ELSE
	FOUND=-1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  R E T U R N
C-----End of IDVE09-----------------------------------------------------
      E    N    D
