C:::::      ,,,,,IDVE10...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDVE10 (ELID,CLASS,FORM,GEOTYP,ZW)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   IDVE10    resort the ideas sorting of the local nodes         ***
C**             to the vecfem sorting.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ELID,GEOTYP,ZW(GEOTYP),CLASS,FORM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I out I dimension of the element
C        I      I     I CLASS<0 => no VECFEM element is requested
C--------I------I-----I------------------------------------------------
C FORM   I  I   I out I number of vertices
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C ELID   I  I   I in  I I-DEAS element id
C--------I------I-----I------------------------------------------------
C ZW     I  I   I i/o I array of nodes of the element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           ZW2(32),I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      CLASS=-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** I-DEAS element id ->  CLASS,FORM                              ***
C**   --------------------------------                              ***
C**                                                                 ***
      IF ((GEOTYP.EQ.2).AND.(ELID.EQ.21)) THEN
	 FORM=2
	 CLASS=1
      ENDIF
      IF ((GEOTYP.EQ.3).AND.(ELID.EQ.24)) THEN
	 FORM=2
	 CLASS=1
      ENDIF
      IF ((GEOTYP.EQ.3).AND.(ELID.EQ.91)) THEN
         FORM=3
	 CLASS=2
      ENDIF
      IF ((GEOTYP.EQ.6).AND.(ELID.EQ.92)) THEN
	 FORM=3
	 CLASS=2
      ENDIF
      IF ((GEOTYP.EQ.9).AND.(ELID.EQ.93)) THEN
	 FORM=3
	 CLASS=2
      ENDIF
      IF ((GEOTYP.EQ.4).AND.(ELID.EQ.94)) THEN
	 FORM=4
	 CLASS=2
      ENDIF
      IF ((GEOTYP.EQ.8).AND.(ELID.EQ.95)) THEN
	 FORM=4
	 CLASS=2
      ENDIF
      IF ((GEOTYP.EQ.12).AND.(ELID.EQ.96)) THEN
	 FORM=4
	 CLASS=2
      ENDIF
      IF ((GEOTYP.EQ.4).AND.(ELID.EQ.111)) THEN
	 FORM=4
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.10).AND.(ELID.EQ.118)) THEN
	 FORM=4
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.6).AND.(ELID.EQ.112)) THEN
	 FORM=6
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.15).AND.(ELID.EQ.113)) THEN
	 FORM=6
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.24).AND.(ELID.EQ.114)) THEN
	 FORM=6
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.8).AND.(ELID.EQ.115)) THEN
	 FORM=8
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.20).AND.(ELID.EQ.116)) THEN
	 FORM=8
	 CLASS=3
      ENDIF
      IF ((GEOTYP.EQ.32).AND.(ELID.EQ.117)) THEN
	 FORM=8
	 CLASS=3
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** resorting :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
      DO 10 I=1,32
  10   ZW2(I)=ZW(I)
C**                                                                 ***
C**** parabolic beam:                                               ***
C**                                                                 ***
      IF (ELID.EQ.24) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(3)
       ZW(3)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** linear triangle:                                              ***
C**                                                                 ***
      IF (ELID.EQ.91) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(3)
       ZW(3)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** parabolic triangle:                                           ***
C**                                                                 ***
      IF (ELID.EQ.92) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(5)
       ZW(3)=ZW2(3)
       ZW(4)=ZW2(6)
       ZW(5)=ZW2(4)
       ZW(6)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** cubic triangle:                                               ***
C**                                                                 ***
      IF (ELID.EQ.93) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(7)
       ZW(3)=ZW2(4)
       ZW(4)=ZW2(9)
       ZW(5)=ZW2(8)
       ZW(6)=ZW2(6)
       ZW(7)=ZW2(5)
       ZW(8)=ZW2(3)
       ZW(9)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** linear quadrilateral:                                         ***
C**                                                                 ***
      IF (ELID.EQ.94) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(4)
       ZW(3)=ZW2(3)
       ZW(4)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** parabolic quadrilateral:                                      ***
C**                                                                 ***
      IF (ELID.EQ.95) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(7)
       ZW(3)=ZW2(5)
       ZW(4)=ZW2(3)
       ZW(5)=ZW2(8)
       ZW(6)=ZW2(6)
       ZW(7)=ZW2(4)
       ZW(8)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** cubic quadrilateral:                                          ***
C**                                                                 ***
      IF (ELID.EQ.96) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(10)
       ZW(3)=ZW2(7)
       ZW(4)=ZW2(4)
       ZW(5)=ZW2(12)
       ZW(6)=ZW2(11)
       ZW(7)=ZW2(9)
       ZW(8)=ZW2(8)
       ZW(9)=ZW2(6)
       ZW(10)=ZW2(5)
       ZW(11)=ZW2(3)
       ZW(12)=ZW2(2)
      ENDIF
C**                                                                 ***
C**** parabolic wedge:                                              ***
C**                                                                 ***
      IF (ELID.EQ.113) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(3)
       ZW(3)=ZW2(5)
       ZW(4)=ZW2(10)
       ZW(5)=ZW2(12)
       ZW(6)=ZW2(14)
       ZW(7)=ZW2(2)
       ZW(8)=ZW2(4)
       ZW(9)=ZW2(6)
       ZW(10)=ZW2(7)
       ZW(11)=ZW2(8)
       ZW(12)=ZW2(9)
       ZW(13)=ZW2(11)
       ZW(14)=ZW2(13)
       ZW(15)=ZW2(15)
      ENDIF
C**                                                                 ***
C**** cubic wedge:                                                  ***
C**                                                                 ***
      IF (ELID.EQ.114) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(4)
       ZW(3)=ZW2(7)
       ZW(4)=ZW2(16)
       ZW(5)=ZW2(19)
       ZW(6)=ZW2(22)
       ZW(7)=ZW2(2)
       ZW(8)=ZW2(3)
       ZW(9)=ZW2(5)
       ZW(10)=ZW2(6)
       ZW(11)=ZW2(8)
       ZW(12)=ZW2(9)
       ZW(13)=ZW2(10)
       ZW(14)=ZW2(11)
       ZW(15)=ZW2(12)
       ZW(16)=ZW2(13)
       ZW(17)=ZW2(14)
       ZW(18)=ZW2(15)
       ZW(19)=ZW2(17)
       ZW(20)=ZW2(18)
       ZW(21)=ZW2(20)
       ZW(22)=ZW2(21)
       ZW(23)=ZW2(23)
       ZW(24)=ZW2(24)
      ENDIF
C**                                                                 ***
C**** parabolic brick:                                              ***
C**                                                                 ***
      IF (ELID.EQ.116) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(3)
       ZW(3)=ZW2(5)
       ZW(4)=ZW2(7)
       ZW(5)=ZW2(13)
       ZW(6)=ZW2(15)
       ZW(7)=ZW2(17)
       ZW(8)=ZW2(19)
       ZW(9)=ZW2(2)
       ZW(10)=ZW2(4)
       ZW(11)=ZW2(6)
       ZW(12)=ZW2(8)
       ZW(13)=ZW2(9)
       ZW(14)=ZW2(10)
       ZW(15)=ZW2(11)
       ZW(16)=ZW2(12)
       ZW(17)=ZW2(14)
       ZW(18)=ZW2(16)
       ZW(19)=ZW2(18)
       ZW(20)=ZW2(20)
      ENDIF
C**                                                                 ***
C**** cubic brick:                                                  ***
C**                                                                 ***
      IF (ELID.EQ.117) THEN
       ZW(1)=ZW2(1)
       ZW(2)=ZW2(4)
       ZW(3)=ZW2(7)
       ZW(4)=ZW2(10)
       ZW(5)=ZW2(21)
       ZW(6)=ZW2(24)
       ZW(7)=ZW2(27)
       ZW(8)=ZW2(30)
       ZW(9)=ZW2(2)
       ZW(10)=ZW2(3)
       ZW(11)=ZW2(5)
       ZW(12)=ZW2(6)
       ZW(13)=ZW2(8)
       ZW(14)=ZW2(9)
       ZW(15)=ZW2(11)
       ZW(16)=ZW2(12)
       ZW(17)=ZW2(13)
       ZW(18)=ZW2(14)
       ZW(19)=ZW2(15)
       ZW(20)=ZW2(16)
       ZW(21)=ZW2(17)
       ZW(22)=ZW2(18)
       ZW(23)=ZW2(19)
       ZW(24)=ZW2(20)
       ZW(25)=ZW2(22)
       ZW(26)=ZW2(23)
       ZW(27)=ZW2(25)
       ZW(28)=ZW2(26)
       ZW(29)=ZW2(28)
       ZW(30)=ZW2(29)
       ZW(31)=ZW2(31)
       ZW(32)=ZW2(32)
      ENDIF
C**                                                                 ***
C**** parabolic tetrahedron:                                        ***
C**                                                                 ***
      IF (ELID.EQ.118) THEN
       ZW(1)=ZW2(10)
       ZW(2)=ZW2(3)
       ZW(3)=ZW2(1)
       ZW(4)=ZW2(5)
       ZW(5)=ZW2(8)
       ZW(6)=ZW2(2)
       ZW(7)=ZW2(7)
       ZW(8)=ZW2(9)
       ZW(9)=ZW2(4)
       ZW(10)=ZW2(6)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of IDVE10----------------------------------------------------
      E    N    D
