C:::::      ,,,,,IDVE97...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE IDVE97(T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      IDVE97   read  I-DEAS nodal result file                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights Lutz Grosz Canberra 1999                      ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,ZERO,T2,RH(1),T0
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,Z,TOTID,FRTID,
     &                  DATIN,OUTCNT,TID,CASE0,STEP0,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,NDV,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,NBIG,
     &                  LL9MAP,P,MIDR,MIDS,INFO,J,NH,CASE,TIDS,NMSG,
     &                  TOKEN(1),STEP,LLNGTH(16),NLNGTH(16),MPINFO,SBT,
     &                  SWPBUF,RCVBFI,SNDBFI,RCVBFR,SNDBFR,LBFR,LBFI,
     &                  MTYPE2,DCHAR2,DTYPE2,FOUND,INBFI,LINBF,MIDS2,
     &                  INBFR,NINBF,PTRI,PTRR,IREG,MIDR2,
     &                  I0,I1,I2,I3,CASE2,STEP2,DSET(1),IH(3)
      CHARACTER*80      TEXT,ENDTXT
      LOGICAL           YES,EMPTY,FIRST
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      ZERO=0
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATIN = IVEM(127)
      U1=MAX(IVEM(128),0)
      CASE  = IVEM(137)
      STEP  = IVEM(138)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      N=MAX(IVEM(129),0)
      NU=N*U1
      IF (LOUT.LT.0) LOUT=6
      IF (DATIN.LE.0) RETURN
      WRITE(ENDTXT,'(I6)') -1

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('IDVE97',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,DATIN
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
	WRITE (LOUT,9310) 137,CASE
        IF (CASE.LT.0)  WRITE (LOUT,9410)
	WRITE (LOUT,9311) 138,STEP
        IF (STEP.LT.0) WRITE (LOUT,9411)
        WRITE (LOUT,9312) T
        IF (T.LT.ZERO) WRITE (LOUT,9412)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input data :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NLNGTH(16)=NU
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF
      CALL VEM098('IDVE97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find the data set:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
         DSET(1)=55
         FIRST=.TRUE.
 5100    CALL IDVE09(DATIN,1,DSET,FOUND)
         IF (FOUND.LT.0) THEN
           ERR=77
           WRITE(LOUT,9102) MYPROC,MYTID
           GOTO 5000
         ENDIF 
         DO 5110 I=1,5
 5110      READ(DATIN,'(80A)') TEXT
         READ(DATIN,'(6I10)') MTYPE2,I0,DCHAR2,DTYPE2,I1,NDV
         READ(DATIN,'(4I10)') I2,I3,CASE2,STEP2
         READ(DATIN,'(E13.5)') T2

         IF (FIRST) THEN
           CASE0=CASE2
           STEP0=STEP2
           T0=T2
           FIRST=.FALSE.
         ELSE
           IF ((CASE0.EQ.CASE2).AND.(STEP0.EQ.STEP2)
     &                                       .AND.(T0.EQ.T2)) THEN
             ERR=77
             WRITE(LOUT,9102) MYPROC,MYTID
             GOTO 5000
           ENDIF
         ENDIF 
 
         YES=.TRUE.
         IF ((T.GE.ZERO).AND.(T2.LT.T)) YES=.FALSE.
         IF ((STEP.GE.0).AND.(STEP2.LT.STEP)) YES=.FALSE.
         IF ((CASE.GE.0).AND.(CASE2.NE.CASE)) YES=.FALSE.
         IF (.NOT.YES) GOTO 5100
         NDV=MIN(N,NDV)
      ENDIF
5000  CALL VEM098('IDVE97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** spread the charcteristics of the found set :                  ***
C**   ------------------------------------------                    ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN 
        RH(1)=T2
        IH(1)=STEP2
        IH(2)=CASE2
        IH(3)=NDV
        DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT*3,IH,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT*3,IH,MIDS,INFO)
	    CALL MPSNDA(TID,IVEM(NMSG)+NPROC+P,IREAL,RH,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+NPROC+P,IREAL,RH,MIDS,INFO)
          ENDIF
 400    CONTINUE
      ENDIF

      IF (MYTID.NE.IOTID) THEN
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT*3,IH,MIDR,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT*3,IH,MIDR,INFO)
        CALL MPRCVA(IOTID,IVEM(NMSG)+NPROC+MYPROC,IREAL,RH,MIDR,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+NPROC+MYPROC,IREAL,RH,MIDR,INFO)
      ENDIF
      T=RH(1)
      STEP=IH(1)
      CASE=IH(2)
      NDV=IH(3)
      IVEM(137)=CASE
      IVEM(138)=STEP
      IF (OUTCNT.NE.0) WRITE (LOUT,9400) CASE,STEP,T,NDV
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize buffer :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,TOKEN,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,TOKEN,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)

      LBFR=NUBUF*NDV
      LBFI=2+NUBUF

      RCVBFR=0
      SNDBFR=RCVBFR+LBFR
      RCVBFI=(SNDBFR+LBFR)*RPI
      SNDBFI=RCVBFI+LBFI
      INBFI=SNDBFI+LBFI
      LINBF=MIN(NUBUF,
     &            (LBIG*RPI-INBFI+RPI-1)/MAX(NDV*RPI+1,1)-1)
      INBFR=(INBFI+LINBF+RPI-1)/RPI

      NBIG=(INBFI+LINBF+RPI-1)/RPI+LINBF*NDV
      NLNGTH(4)=NBIG
      CALL VEM098('IDVE97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize the buffer for the array U:                        ***
C**   --------------------------------------                        ***
C**                                                                 ***
      IBIG(1+SNDBFI)=NDEGL
      IBIG(2+SNDBFI)=NDEG0L
      DO 101 Z=1,NUBUF
        IBIG(SNDBFI+2+Z)=0
101   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read the data into the buffer til the buffer is full:         ***
C**   ----------------------------------------------------          ***
C**                                                                 ***
      EMPTY=.FALSE.
2200  NINBF=0
2000  IF (NINBF.LT.LINBF) THEN
        READ(DATIN,'(80A)') TEXT
        IF (TEXT.NE.ENDTXT) THEN
          NINBF=NINBF+1
          READ(TEXT,'(I10)') IBIG(INBFI+NINBF)
          READ(DATIN,'(6E13.5)') (RBIG(INBFR+LINBF*(J-1)+NINBF),J=1,NDV)
          GOTO 2000
        ELSE
          EMPTY=.TRUE.
          GOTO 2300
        ENDIF
      ENDIF
2300  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** enter the read results into the buffer for vector U:          ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        DO 500 P=1,NPROC

          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+NPROC,IREAL*LBFR,
     &                  RBIG(RCVBFR+1),MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+NPROC,IREAL*LBFR,
     &                  RBIG(RCVBFR+1),MIDR,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+2*NPROC,IINT*LBFI,
     &                  IBIG(RCVBFI+1),MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+2*NPROC,IINT*LBFI,
     &                  IBIG(RCVBFI+1),MIDR,INFO)
            PTRI=RCVBFI
            PTRR=RCVBFR
          ELSE
            PTRI=SNDBFI
            PTRR=SNDBFR
          ENDIF

          NDEGL=IBIG(1+PTRI)
          NDEG0L=IBIG(2+PTRI)
          DO 300 I=1,NDV
            DO 300 Z=1,NINBF
             IREG=IBIG(INBFI+Z)-NDEG0L
             IF ((IREG.GT.0).OR.(IREG.LE.NDEGL)) THEN
               IBIG(PTRI+2+IREG)=1 
               RBIG(PTRR+IREG+NUBUF*(I-1))=RBIG(INBFR+LINBF*(I-1)+Z)
             ENDIF
 300      CONTINUE

	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P+3*NPROC,IREAL*LBFR,
     &                  RBIG(RCVBFR+1),MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P+3*NPROC,IREAL*LBFR,
     &                  RBIG(RCVBFR+1),MIDS,INFO)
	    CALL MPSNDA(TID,IVEM(NMSG)+P+4*NPROC,IINT*LBFI,
     &                  IBIG(RCVBFI+1),MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P+4*NPROC,IINT*LBFI,
     &                  IBIG(RCVBFI+1),MIDS,INFO)
          ENDIF

500     CONTINUE
      ELSE
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
	CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
	CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBFR,
     &              RBIG(SNDBFR+1),MIDS,INFO)
	CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBFR,
     &              RBIG(SNDBFR+1),MIDS,INFO)
	CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+2*NPROC,IINT*LBFI,
     &              IBIG(SNDBFI+1),MIDS,INFO)
	CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+2*NPROC,IINT*LBFI,
     &              IBIG(SNDBFI+1),MIDS,INFO)
	CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC+3*NPROC,IREAL*LBFR,
     &              RBIG(SNDBFR+1),MIDR,INFO)
	CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC+3*NPROC,IREAL*LBFR,
     &              RBIG(SNDBFR+1),MIDR,INFO)
	CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC+4*NPROC,IINT*LBFI,
     &              IBIG(SNDBFI+1),MIDR,INFO)
	CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC+4*NPROC,IINT*LBFI,
     &              IBIG(SNDBFI+1),MIDR,INFO)
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+5*NPROC
      IF (.NOT.EMPTY) GOTO 2200
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Now the buffer for U is send arround:                         ***
C**   ------------------------------------                          ***
C**                                                                 ***
      TOTID=IVEM(TIDS-1+LL9MAP(MYPROC+1,NPROC))
      FRTID=IVEM(TIDS-1+LL9MAP(MYPROC-1,NPROC))
      DO 100 P=1,NPROC

	IF (P.LT.NPROC) THEN
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P,IREAL*LBFR,
     &                RBIG(RCVBFR+1),MIDR,INFO)
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P+NPROC,IINT*LBFI,
     &                IBIG(RCVBFI+1),MIDR2,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P,IREAL*LBFR,
     &                RBIG(SNDBFR+1),MIDS,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P+NPROC,IINT*LBFI,
     &                IBIG(SNDBFI+1),MIDS2,INFO)
        ENDIF
        NDEGL=IBIG(1+SNDBFI)
        NDEG0L=IBIG(2+SNDBFI)
	DO 130 J=1,NDV
	  DO 130 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
              IF (IBIG(SNDBFI+2+NH).NE.0) 
     &                U(Z+U1*(J-1))=RBIG(SNDBFR+NH+NUBUF*(J-1))
            ENDIF
130     CONTINUE
	IF (P.LT.NPROC) THEN
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P,IREAL*LBFR,
     &                RBIG(RCVBFR+1),MIDR,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P+NPROC,IINT*LBFI,
     &                IBIG(RCVBFI+1),MIDR2,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P,IREAL*LBFR,
     &                RBIG(SNDBFR+1),MIDS,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P+NPROC,IINT*LBFI,
     &                IBIG(SNDBFI+1),MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBFR
        RCVBFR=SNDBFR
        SNDBFR=SWPBUF

        SWPBUF=RCVBFI
        RCVBFI=SNDBFI
        SNDBFI=SWPBUF
100    CONTINUE
       IVEM(NMSG)=IVEM(NMSG)+NPROC*2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('IDVE97',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9101  FORMAT('>>VEMCD:02:9998'
     &      /'>>IDVE97 error on process ',I10,' (TID=',I10,')'
     &      /'>>U1 = ',I10,' is defective!')
9102  FORMAT('>>VEMCD:01:0007'
     &      /'>>IDVE97 error on process ',I10,' (TID=',I10,')'
     &      /'>>No data set found!')
9300  FORMAT('    unit of I-DEAS nodal result file .............. =',
     &                                          ' IVEM(',I4,') = ',I10)
9312  FORMAT('    time mark .......................................',
     &                                          '......... T = ',G10.3)
9412  FORMAT('    => Any time mark is accepted.')
9310  FORMAT('    load case number ......................... CASE =',
     &                                          ' IVEM(',I4,') = ',I10)
9410  FORMAT('    => Any load case number is accepted.')
9311  FORMAT('    time step number ......................... STEP =',
     &                                          ' IVEM(',I4,') = ',I10)
9411  FORMAT('    => Any time step number is accepted.')
9320  FORMAT('    number of components ........................ N =',
     &                                          ' IVEM(',I4,') = ',I10)
9330  FORMAT('    leading dimension of result array .......... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9380  FORMAT('    read nodal results ..............................',
     &                                          '........... = ',I10)
9400  FORMAT('    Data set has been found:'
     &      /'      load case number     = ',I10
     &      /'      time step number     = ',I10
     &      /'      time mark            = ',G10.3
     &      /'      number of components = ',I10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of IDVE97----------------------------------------------------
      E    N    D
