C:::::      ,,,,,LL1BCO.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL1BCO(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #                  mat,prec,x,b,
     #                  iprec,index,ia1,info,dw,iw,
     #                  ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #                  ms,eps,epslin,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 1 B C O      BICO-method                               ***
C**                                                                 ***
C**                       a n d                                     ***
C**                                                                 ***
C**                       QMR-Simulator   for the solution of the   ***
C**                                       of the linear system      ***
C**                                       MAT * x = b.              ***
C**                                                                 ***
C**                      (ldw must be 18*l)                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER : H. Haefner                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           ldw,liw,lmat,lprec,liprec,lindex,l,ia1,nproc,
     #                  index(lindex),info(ia1,ia2),lmatbk(nproc),
     #                  ptrmbk(nproc+1),jump(nproc),tid(nproc),
     #                  ptrinf(ntyp+1,nproc),iprec(liprec),iw(liw),
     #                  ilin(nilin),iconv,ierr,ms
      double precision  mat(lmat),prec(lprec),x(l),b(l),
     #                  dw(ldw),eps,epslin
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :    (SEE LINSOL)                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF LOCAL PARAMETERS :                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      double precision  delta,beta,rrp1,spc(2),help(2)
      external LL6AX,LL6ATX
      logical  ladd,break,lsym2
      integer  i,imvm,nmsg,lout,myproc,lmyblk,z,ione,branch,count
      character*10  method
      integer ibr,ibrst,ibrs,ibAp,ibAtpt,ibx,ibxs,ibp,ibpst,ibcom,
     #        ibPRp,ibh1,ibh2,ibh3,ibNb,niter,niter2,nrstrt,irstrt
      double precision zero,one,r0iter,rseucn,rshelp,sleep,stopit,
     #                 expo,pstnrm,rpoly

      common /norms/ rseucn,rpoly(3),lsym2
C**                                                                 ***
C**        CONSTANTS :                                              ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.0, one = 1.0, sleep = 0.01, stopit = 0.1,
     #           expo = 75.0, ione = 1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      if (ms .eq. 2) THEN
         method = '     BICO '
         call POLY1('BICO','VECFEM',ptrmbk(nproc+1),0,0.)
      endif
      if (ms .eq. 6) then
         method = ' QMR-SIM. '
         call POLY1('QMR Simulator','VECFEM',ptrmbk(nproc+1),0,0.)
      endif

      ladd = .false.
      break = .false.
C**                                                                 ***
      imvm  = ilin(10)
C**                                                                 ***
      nmsg   = ilin(3)
      lout   = ilin(12)
      myproc = ilin(17)
      lmyblk = lmatbk(myproc)

      niter  = max(500,l*nproc/100)
c     niter2 = max(500,l*nproc/100)
      nrstrt = ilin(2)

      irstrt = 0
      pstnrm = one
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** SET POINTERS :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      ibr=0*l+1
      ibrst=1*l+1
      ibrs=2*l+1
      ibAp=3*l+1
      ibAtpt=4*l+1
      ibx=5*l+1
      ibxs=6*l+1
      ibp=7*l+1
      ibpst=8*l+1
      ibPRp=9*l+1
      ibh1=10*l+1
      ibh2=11*l+1
      ibh3=12*l+1
      ibcom=13*l+1

      ibNb=4*l+1

      if (mod(ilin(8),3) .eq. 2 .or. ilin(8) .eq. 0) then
        ibh1 = ibpst
        ibh2 = ibAp
      endif
      if (mod(ilin(8),3) .eq. 1 .or. ilin(8) .eq. 0) then
        ibPRp = ibp
        ibh3  = ibAtpt
      endif
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   INITIAL VALUES                                                ***
C**                                                                 ***
      include "norec.h"
      do 110 i = 1,l
        x(i)  = zero
        dw(i+ibr-1) = - b(i)
  110 continue

      iconv = 0

      include "norec.h"
      do 122 i=0,l-1
        dw(ibrs+i) = dw(ibr+i)
        dw(ibp+i) = dw(ibr+i)
        dw(ibx+i) = x(i+1)
        dw(ibxs+i) = x(i+1)
  122 continue

C**
C***  IF PR <> I ==>  PR_TRANS * N * b is computed
C**
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then
C
       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,lsym,
     #             ia1,info,mat,prec,dw(ibrst),prec(ibNb),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3ATX(LL6ATX,prec(iprec(8)+1),prec(ibNb),dw(ibrst),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(4),lprec,liprec,iprec(5),l,ldw,liw,nproc,
     #              lsym,iprec(6),iprec(iprec(13)+1),prec(iprec(8)+1),
     #              prec,dw(ibrst),prec(ibNb),dw,iprec,
     #              iprec(iprec(12)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(14)+1),jump,tid,myproc,iconv,ierr)
       endif
      include "norec.h"
       do 123 i=0,l-1
        dw(ibpst+i) = dw(ibrst+i)
  123  continue
      else
      include "norec.h"
       do 124 i=0,l-1
        dw(ibrst+i) = - prec(ibNb+i)
        dw(ibpst+i) = - prec(ibNb+i)
  124  continue
      endif

      count = 0
C**                                                                 ***
C***  COMPUTE ||r0||2                                               ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),b,prec,
     &            dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.true.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (410,420,430) branch

      r0iter = rseucn
C**                                                                 ***
C***  INITIAL VALUES                                                ***
C**                                                                 ***
      delta = zero
      beta  = zero
      rrp1  = zero
      do 130 i = 1,2
	spc(i) = zero
  130 continue

      goto 111

C**                                                                 ***
C***  RESTART : SET BACK VECTORS P,PST,R,RST TO RS  AND  X TO XS    ***
C**                                                                ***
  101 continue
      include "norec.h"
      do 132 i=0,l-1
        dw(ibp+i) = dw(ibrs+i)
        dw(ibpst+i) = dw(ibrs+i)
        dw(ibr+i) = dw(ibrs+i)
	if (break) then
          dw(ibrst+i) = dw(ibAtpt+i)-prec(ibNb+i)
        else
          dw(ibrst+i) = dw(ibrs+i)
	endif
        dw(ibx+i) = dw(ibxs+i)
  132 continue
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***  START OF THE ITERATION-LOOP                                   ***
C**                                                                 ***

  111 continue
      if (.not. break) count = count+1

C**                                                                 ***
C**  COMPUTATION OF PL_TRANS*P_K_STAR                               ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibpst),dw(ibh1),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3ATX(LL6ATX,prec(iprec(7)+1),dw(ibpst),dw(ibh1),
     #              dw(ibcom),ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,
     #              tid,myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #              iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(1),lprec,liprec,iprec(2),l,ldw,liw,nproc,
     #              lsym,iprec(3),iprec(iprec(10)+1),prec(iprec(7)+1),
     #              prec,dw(ibh1),dw(ibpst),dw,iprec,
     #              iprec(iprec(9)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(11)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif

C**                                                                 ***
C**  COMPUTATION OF PR*P_K                                          ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibp),dw(ibPRp),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(8)+1),dw(ibp),dw(ibPRp),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(4),lprec,liprec,iprec(5),l,ldw,liw,nproc,
     #              lsym,iprec(6),iprec(iprec(13)+1),prec(iprec(8)+1),
     #              prec,dw(ibPRp),dw(ibp),dw,iprec,
     #              iprec(iprec(12)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(14)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif
C**                                                                 ***
C***  COMPUTATION OF A*P_K and A_TRANS*P_K_STAR simultaneously      ***
C**                                                                 ***
      call LL3A2X(mat,dw(ibPRp),dw(ibh1),dw(ibh2),dw(ibh3),dw(ibcom),
     #            ptrmbk,lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #            ladd,lmat,lindex,ia1,info,index,nmsg)
      imvm=imvm+2

C**                                                                 ***
C**  COMPUTATION OF PR_TRANS*A_TRANS*PL_TRANS*P_K                   ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibh3),dw(ibAtpt),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3ATX(LL6ATX,prec(iprec(8)+1),dw(ibh3),dw(ibAtpt),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(4),lprec,liprec,iprec(5),l,ldw,liw,nproc,
     #              lsym,iprec(6),iprec(iprec(13)+1),prec(iprec(8)+1),
     #              prec,dw(ibAtpt),dw(ibh3),dw,iprec,
     #              iprec(iprec(12)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(14)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif

C**                                                                 ***
C**  COMPUTATION OF PL*A*PR*P_K                                     ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibh2),dw(ibAp),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(7)+1),dw(ibh2),dw(ibAp),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #             iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(1),lprec,liprec,iprec(2),l,ldw,liw,nproc,
     #              lsym,iprec(3),iprec(iprec(10)+1),prec(iprec(7)+1),
     #              prec,dw(ibAp),dw(ibh2),dw,iprec,
     #              iprec(iprec(9)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(11)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif
C**                                                                 ***
C***  COMPUTATION OF R_K_TRANS * R_K_STAR   AND                     ***
C***                 P_K_TRANS * A_TRANS*P_K_STAR                   ***
C**                                                                 ***
      if (count .eq. 1 .or. break) then
        call LL4SCP(lmyblk,1,l,1,dw,ibr,dw,ibrst,spc(1),help,.false.,
     #              myproc,nproc,tid,nmsg)
      endif
      call LL4SCP(lmyblk,1,l,1,dw,ibp,dw,ibAtpt,spc(2),help,.false.,
     #            myproc,nproc,tid,nmsg)

C     if (spc(1) .eq. zero .or. spc(2) .eq. zero) then
      if (spc(2) .eq. zero) then
	if (ilin(13) .le. -2) write(lout,1350) count
	if (ilin(13) .ge. 2) then 
	  if (myproc .eq. 1) write(lout,1350) count
        endif
	if (break) then
	  if (ilin(1) .eq. 10) then
	    iconv = 5
	    goto 500
          else
	    if (ms .eq. 2) ierr = 1221
	    if (ms .eq. 6) ierr = 1261
	    goto 440
          endif
        else
	  break = .true.
          goto 101
	endif
      endif

      delta = -spc(1)/spc(2)

      include "norec.h"
      do 140 z=0,lmyblk-1
        dw(ibx+z) = dw(ibx+z)+delta*dw(ibPRp+z)
        dw(ibr+z) = dw(ibr+z)+delta*dw(ibAp+z)
  140 continue

C**                                                                 ***
C***  SMOOTHING OF THE SOLUTION X AND THE RESIDUUM R                ***
C**                                                                 ***
      if (ms .eq. 2) then
        call LL8SMO(dw,ibrs,ibr,ibxs,ibx,ibcom,ldw,l,lmyblk,
     #              myproc,nproc,tid,nmsg)
      endif
      if (ms .eq. 6) then
        call LL8SMQ(dw,ibrs,ibr,ibxs,ibx,ibcom,ldw,l,lmyblk,
     #              break,count,myproc,nproc,tid,nmsg)
      endif
      break = .false.
C**                                                                 ***
C***  CHECK STOPPING CRITERION                                      ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &           b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &           ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &           lindex,info,ia1,lsym,ladd,
     &           method,.false.,myproc,nproc,tid,nmsg,ilin,ierr,
     &           count,imvm,branch)
      goto (410,420,430) branch
 
      if (mod(count,niter) .eq. 0 .and. ilin(1) .eq. 10) then
        if (rseucn/r0iter .ge. stopit) then
	  iconv = 5
	  goto 500
        endif
	r0iter = rseucn
      endif

c     if (mod(count,niter2) .eq. 0 .and. ilin(1) .eq. 100) then
c       rshelp = rseucn/r0iter
c       if (rshelp .ge. stopit .and. rshelp .gt. rpoly(1)) then
c         iconv = 6
c         rpoly(2) = rshelp
c         goto 500
c       endif
c       if (rshelp .ge. stopit .and. rshelp .gt. rpoly(3)) then
c         if (rpoly(3) .eq. zero) then
c           rpoly(2) = rshelp
c         else
c           rpoly(2) = one
c         endif
c         iconv = 5
c         goto 500
c       endif
c       r0iter = rseucn
c     endif
 
      if (mod(count,nrstrt) .eq. 1) then
	rshelp = rseucn
      endif
      if (mod(count,nrstrt) .eq. nrstrt) then
        if (abs(rshelp-rseucn) .lt. rshelp*sleep) then
	  if (irstrt .eq. 1) then
	    nrstrt =nrstrt*2
	    irstrt = 0
          else
	    irstrt = 1
	    if (ilin(13) .le. -2) write(lout,1380) count
	    if (ilin(13) .ge. 2) then 
	      if (myproc .eq. 1) write(lout,1380) count
            endif
	    goto 101
          endif
        else
	  irstrt = 0
        endif
      endif

      include "norec.h"
      do 150 z=0,lmyblk-1
        dw(ibrst+z) = dw(ibrst+z)+delta*dw(ibAtpt+z)
  150 continue

      call LL4SCP(lmyblk,1,l,1,dw,ibr,dw,ibrst,rrp1,help,.false.,
     #            myproc,nproc,tid,nmsg)

      if (rrp1 .eq. 0) then
      include "norec.h"
        do 160 i=0,l-1
          dw(ibpst+i) = dw(ibp+i)
          dw(ibrst+i) = dw(ibr+i)
  160   continue
	if (ilin(13) .le. -2) write(lout,1360) count
	if (ilin(13) .ge. 2) then 
	  if (myproc .eq. 1) write(lout,1360) count
        endif
        call LL4SCP(lmyblk,1,l,1,dw,ibr,dw,ibrst,rrp1,help,.false.,
     #              myproc,nproc,tid,nmsg)
      endif

      if (log(abs(rrp1))-log(abs(spc(1)))+log(abs(pstnrm)) .gt. expo)
     #  then
	if (ilin(13) .le. -2) write(lout,1370) count
	if (ilin(13) .ge. 2) then 
	  if (myproc .eq. 1) write(lout,1370) count
        endif
	goto 101
      endif
      
      beta = rrp1/spc(1)

      include "norec.h"
      do 170 z=0,lmyblk-1
        dw(ibp+z) = dw(ibr+z)+beta*dw(ibp+z)
        dw(ibpst+z) = dw(ibrst+z)+beta*dw(ibpst+z)
  170 continue
      
      call LL4RNM(lmyblk,1,l,dw(ibpst),pstnrm,help,
     #            myproc,nproc,tid,nmsg)
      if (pstnrm .ne. zero) then
	pstnrm = one/pstnrm
      include "norec.h"
        do 180 z=0,lmyblk-1
          dw(ibpst+z) = dw(ibpst+z)*pstnrm
          dw(ibrst+z) = dw(ibrst+z)*pstnrm
  180   continue
      else
	pstnrm = one
      endif

      spc(1) = rrp1*pstnrm

      goto 111
C
C***  END OF THE ITERATION-LOOP
C
  410 iconv = 1
      if (ilin(13) .le. -2) write(lout,1410) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1410) imvm
      endif
      goto 500
  420 iconv = 2
      if (ilin(13) .le. -2) write(lout,1420) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1420) imvm
      endif
      goto 500
  430 iconv = 3
      if (ilin(13) .lt. 0) write(lout,1430) imvm
      if (ilin(13) .gt. 0) then
	 if (myproc .eq. 1) write(lout,1430) imvm
      endif
      goto 500
  440 iconv = 4
      if (ilin(13) .lt. 0) then
	write(lout,1020)
	write(lout,1250)
	write(lout,1030)
      endif
      if (ilin(13) .gt. 0) then
	 if (myproc .eq. 1) then 
	   write(lout,1020)
	   write(lout,1250)
	   write(lout,1030)
	 endif
      endif
  500 ilin(10) = imvm
      ilin(3)  = nmsg
      CALL POLYF(iconv)

      if (ilin(18) .ne. 0) then
      include "norec.h"
        do 600 i = 1,lmyblk
	  x(i) = dw(ibxs+i-1)
  600   continue
      else
      include "norec.h"
        do 610 i = 1,lmyblk
	  x(i) = dw(ibx+i-1)
  610   continue
      endif
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
 1020 format(' ****************************************'/
     &       ' ***  Error occured in LINSOL:        ***')
 1250 format(' ***  BICO/QMR-Sim.  method fails     ***')
 1030 format(' ****************************************')
 1350 format('    Step:',i7,'  Breakdown: standard corrective action')
 1360 format('    Step:',i7,'  Breakdown: reduced corrective action')
 1370 format('    Step:',i7,'  Restart: exponents get too high')
 1380 format('    Step:',i7,'  Restart: BICO/QMR-Sim. falls asleep')
 1410 format('    Convergence after',i8,
     &       ' matrix-vector multiplications')
 1420 format('    Iteration reached maximum number of',
     &       ' matrix-vector multiplications:',i7)
 1430 format('    Divergence after',i9,
     &       ' matrix-vector multiplications')
C**                                                                 ***
C**---END OF LL1BCO-------------------------------------------------***
C**                                                                 ***
      e    n    d
