C:::::      ,,,,,LL1CGS.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL1CGS(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #                  mat,prec,x,b,
     #                  iprec,index,ia1,info,dw,iw,
     #                  ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #                  eps,epslin,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 1 C G S      CGS-method for the solution of the        ***
C**      linear system    MAT * x = b.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER : H. Haefner                                    ***
C**                                                                 ***
C**      (ldw must be 19*l)                                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           ldw,liw,lmat,lprec,liprec,lindex,l,ia1,nproc,
     #                  index(lindex),info(ia1,ia2),lmatbk(nproc),
     #                  ptrmbk(nproc+1),jump(nproc),tid(nproc),
     #                  ptrinf(ntyp+1,nproc),iprec(liprec),iw(liw),
     #                  ilin(nilin),iconv,ierr
      double precision  mat(lmat),prec(lprec),x(l),b(l),
     #                  dw(ldw),eps,epslin
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :    (SEE LINSOL)                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      double precision  rho,rhom1,alfa,beta
      logical  break
      integer  swap
      external LL6AX
      logical  ladd
      integer  i,imvm,count,nmsg,lout,myproc,lmyblk,z,ione,branch
      character*10  method
      integer ibr0,ibr,ibrp1,ibrs,ibu,ibq,ibx,ibxp1,ibxs,ibp,ibv,ibcom
      integer ibh1,ibPRu,ibPRp
      double precision zero,one,help(1)
C**                                                                 ***
C**        CONSTANTS :                                              ***
C**        ---------                                                ***
C**                                                                 ***
      parameter  (zero = 0.0, one = 1.0, ione = 1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      method = '      CGS '
      call POLY1('smoothed CGS','VECFEM',ptrmbk(nproc+1),0,0.)

      ladd = .false.
C**                                                                 ***
      imvm  = ilin(10)
      iconv = 0
C**                                                                 ***
      nmsg   = ilin(3)
      lout   = ilin(12)
      myproc = ilin(17)
      lmyblk = lmatbk(myproc)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** SET POINTERS :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      ibr0=0*l+1
      ibr=1*l+1
      ibrp1=2*l+1
      ibrs=3*l+1
      ibPRu=4*l+1
      ibu=5*l+1
      ibq=6*l+1
      ibx=7*l+1
      ibxp1=8*l+1
      ibxs=9*l+1
      ibPRp=10*l+1
      ibp=11*l+1
      ibv=12*l+1
      ibh1=13*l+1
      ibcom=14*l+1

      if (mod(ilin(8),3) .eq. 2 .or. ilin(8) .eq. 0) then
        ibv = ibh1
      endif

      if (mod(ilin(8),3) .eq. 1 .or. ilin(8) .eq. 0) then
        ibPRp = ibp
        ibPRu = ibu
      endif
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      include "norec.h"
      do 110 i = 1,l
        x(i)  = zero
        dw(i+ibr-1) = - b(i)
  110 continue

      include "norec.h"
      do 122 i=0,l-1
        dw(ibrs+i) = dw(ibr+i)
        dw(ibx+i) = x(i+1)
        dw(ibxs+i) = x(i+1)
  122 continue

      count = 0
C**                                                                 ***
C***  COMPUTE ||r0||2                                               ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &            b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.true.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (910,920,930) branch
C**                                                                 ***
C***  INITIAL VALUES                                                ***
C**                                                                 ***
      rhom1 = one
      break = .false.

      include "norec.h"
      do 2001 z=0,lmyblk-1
        dw(ibq+z) = zero
        dw(ibp+z) = zero
        dw(ibr0+z) = dw(ibr+z)
 2001 continue

      goto 111

  101 continue

      include "norec.h"
      do 2002 z=0,lmyblk-1
        dw(ibq+z) = zero
        dw(ibp+z) = zero
        dw(ibr0+z) = dw(ibrs+z)
        dw(ibr+z) = dw(ibrs+z)
        dw(ibx+z) = dw(ibxs+z)
 2002 continue
      rhom1 = one
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***  START OF THE ITERATION-LOOP                                   ***
C**                                                                 ***

  111 continue
      count = count+1
C**                                                                 ***
C***  COMPUTATION OF RHO(K+1)                                       ***
C**                                                                 ***
      call LL4SCP(lmyblk,1,l,1,dw,ibr0,dw,ibr,rho,help,.false.,
     #            myproc,nproc,tid,nmsg)

      if (rhom1 .eq. zero) then
        if (ilin(13) .lt. 0) write(lout,1350) count
        if (ilin(13) .ge. 0) then
          if (myproc .eq. 1) write(lout,1350) count
        endif
        break = .true.
        goto 101
      endif

      beta = rho/rhom1

      include "norec.h"
      do 2003 z=0,lmyblk-1
        dw(ibu+z) = dw(ibr+z)+beta*dw(ibq+z)
        dw(ibp+z) = dw(ibu+z)+beta*(dw(ibq+z)+beta*dw(ibp+z))
 2003 continue

C**                                                                 ***
C**  COMPUTATION OF PR*P                                            ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibp),dw(ibPRp),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(8)+1),dw(ibp),dw(ibPRp),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(4),lprec,liprec,iprec(5),l,ldw,liw,nproc,
     #              lsym,iprec(6),iprec(iprec(13)+1),prec(iprec(8)+1),
     #              prec,dw(ibPRp),dw(ibp),dw,iprec,
     #              iprec(iprec(12)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(14)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif

C**                                                                 ***
C***  COMPUTATION OF A*PR*P                                         ***
C**                                                                 ***
      call LL3AX(LL6AX,mat,dw(ibPRp),dw(ibh1),dw(ibcom),ptrmbk,lmatbk,
     #           ptrinf,l,nproc,tid,myproc,jump,
     #           ladd,lmat,lindex,ia1,info,index,nmsg)
      imvm=imvm+1

C**                                                                 ***
C**  COMPUTATION OF PL*A*PR*P                                       ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibh1),dw(ibv),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(7)+1),dw(ibh1),dw(ibv),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #             iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(1),lprec,liprec,iprec(2),l,ldw,liw,nproc,
     #              lsym,iprec(3),iprec(iprec(10)+1),prec(iprec(7)+1),
     #              prec,dw(ibv),dw(ibh1),dw,iprec,
     #              iprec(iprec(9)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(11)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif

      call LL4SCP(lmyblk,1,l,1,dw,ibr0,dw,ibv,alfa,help,.false.,mypro
     #c,nproc,tid,nmsg)

      if (alfa .eq. zero) then
        ierr = 1251
	if (break) then
	 if (ilin(13) .lt. 0) then 
	   write(lout,1020)
	   write(lout,1250)
	   write(lout,1030)
         endif
	 if (ilin(13) .ge. 0) then
	   if (myproc .eq. 1) then
	     write(lout,1020)
	     write(lout,1250)
	     write(lout,1030)
	   endif
         endif
	 goto 940
        else
	 if (ilin(13) .lt. 0) write(lout,1350) count
	 if (ilin(13) .ge. 0) then
	   if (myproc .eq. 1) write(lout,1350) count
         endif
	 break = .true.
	 goto 101
        endif
      endif
      break = .false.

      alfa = rho/alfa

      include "norec.h"
      do 2004 z=0,lmyblk-1
        dw(ibq+z) = dw(ibu+z)-alfa*dw(ibv+z)
        dw(ibu+z) = dw(ibu+z)+dw(ibq+z)
 2004 continue

C**                                                                 ***
C**  COMPUTATION OF PR*(U+Q)                                        ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibu),dw(ibPRu),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(8)+1),dw(ibu),dw(ibPRu),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(4),lprec,liprec,iprec(5),l,ldw,liw,nproc,
     #              lsym,iprec(6),iprec(iprec(13)+1),prec(iprec(8)+1),
     #              prec,dw(ibPRu),dw(ibu),dw,iprec,
     #              iprec(iprec(12)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(14)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif

C**                                                                 ***
C***  COMPUTATION OF A*PR*(U+Q)                                     ***
C**                                                                 ***
      call LL3AX(LL6AX,mat,dw(ibPRu),dw(ibh1),dw(ibcom),ptrmbk,lmatbk,
     #           ptrinf,l,nproc,tid,myproc,jump,
     #           ladd,lmat,lindex,ia1,info,index,nmsg)
      imvm=imvm+1

C**                                                                 ***
C**  COMPUTATION OF PL*A*PR*(U+Q)                                   ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then

       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibh1),dw(ibv),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(7)+1),dw(ibh1),dw(ibv),
     #             dw(ibcom),ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,
     #             tid,myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #             iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(iprec(1),lprec,liprec,iprec(2),l,ldw,liw,nproc,
     #              lsym,iprec(3),iprec(iprec(10)+1),prec(iprec(7)+1),
     #              prec,dw(ibv),dw(ibh1),dw,iprec,
     #              iprec(iprec(9)+1),iw,ilin,lmatbk,ptrmbk,
     #              iprec(iprec(11)+1),jump,tid,myproc,iconv,ierr)
       endif
      endif


      include "norec.h"
      do 2005 z=0,lmyblk-1
        dw(ibxp1+z) = dw(ibx+z)-alfa*dw(ibPRu+z)
        dw(ibrp1+z) = dw(ibr+z)-alfa*dw(ibv+z)
 2005 continue
C**
      rhom1 = rho
      swap = ibr
      ibr = ibrp1
      ibrp1 = swap
      swap = ibx
      ibx = ibxp1
      ibxp1 = swap
C**
C**                                                                 ***
C***  SMOOTHING OF THE SOLUTION X AND THE RESIDUUM R                ***
C**                                                                 ***
      call LL8SMO(dw,ibrs,ibr,ibxs,ibx,ibcom,ldw,l,lmyblk,
     #            myproc,nproc,tid,nmsg)
C**                                                                 ***
C***  CHECK STOPPING CRITERION                                      ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &            b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.false.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (910,920,930) branch
C
      goto 111
C
C***  END OF THE ITERATION-LOOP
C
  910 iconv = 1
      if (ilin(13) .le. -2) write(lout,1410) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1410) imvm
      endif
      goto 900
  920 iconv = 2
      if (ilin(13) .le. -2) write(lout,1420) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1420) imvm
      endif
      goto 900
  930 iconv = 3
      if (ilin(13) .lt. 0) write(lout,1430) imvm
      if (ilin(13) .gt. 0) then
	 if (myproc .eq. 1) write(lout,1430) imvm
      endif
      goto 900
  940 iconv = 4
  900 ilin(10) = imvm
      ilin(3)  = nmsg
      CALL POLYF(iconv)

      if (ilin(18) .ne. 0) then
      include "norec.h"
        do 901 i = 1,lmyblk
	  x(i) = dw(ibxs+i-1)
  901   continue
      else
      include "norec.h"
        do 902 i = 1,lmyblk
	  x(i) = dw(ibx+i-1)
  902   continue
      endif
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
 1020 format(' *****************************************'/
     &       ' ***  Error occured in LINSOL:         ***')
 1250 format(' ***  Scalar prod. is continously zero ***'/
     &       ' ***  CGS     method not applicable    ***')
 1030 format(' *****************************************')
 1350 format('    Step:',i7,'  Restart: scalar product is zero')
 1410 format('    Convergence after',i8,
     &       ' matrix-vector multiplications')
 1420 format('    Iteration reached maximum number of',
     &       ' matrix-vector multiplications:',i7)
 1430 format('    Divergence after',i9,
     &       ' matrix-vector multiplications')
C**                                                                 ***
C**---END OF LL1CGS-------------------------------------------------***
C**                                                                 ***
      e    n    d
