C:::::      ,,,,,LL1CGT....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL1CGT(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #                  mat,prec,x,b,
     #                  iprec,index,ia1,info,dw,iw,
     #                  ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #                  eps,epslin,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 1 C G T   CG-method for the solution of the            ***
C**      linear system  MAT * MAT_TRANSP * x = b.                   ***
C**                                                                 ***
C**      (ldw must be 17*l)                                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER : H. Haefner                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           ldw,liw,lmat,lprec,liprec,lindex,l,ia1,nproc,
     #                  index(lindex),info(ia1,ia2),lmatbk(nproc),
     #                  iprec(liprec),
     #                  ptrmbk(nproc+1),jump(nproc),tid(nproc),
     #                  ptrinf(ntyp+1,nproc),iw(liw),
     #                  ilin(nilin),iconv,ierr
      double precision  mat(lmat),prec(lprec),x(l),b(l),
     #                  dw(ldw),eps,epslin
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :    (SEE LINSOL)                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer         i,count,lout,imvm,ibx,ibxs,ibxm1,ibxp1,
     &                ibr,ibrs,ibrm1,ibrp1,ibA2r,ibAr,ibPRr,ibh1,ibcom,
     &                ptrdw2(2),lmyblk,ione,nmsg,swap,myproc,branch
      double precision  one,zero,help(2),ak(2),sum,an(2)
      logical           ladd
      character*10      method
      external          LL6AX,LL6ATX
C**                                                                 ***
C**        CONSTANTS :                                              ***
C**        ---------                                                ***
C**                                                                 ***
      parameter  (zero = 0.0, one = 1.0, ione = 1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      method = '    CG-AT '
      call POLY1('PCG-AT','VECFEM',ptrmbk(nproc+1),0,0.)

      ladd = .false.
C**                                                                 ***
      imvm  = ilin(10)
      iconv = 0
C**                                                                 ***
      nmsg   = ilin(3)
      lout   = ilin(12)
      myproc = ilin(17)
      lmyblk = lmatbk(myproc)
      
C**   
C**   POINTER ON PART OF BUFFER FOR R_K
      ibr    = 1
C**   POINTER ON PART OF BUFFER FOR R_K-1
      ibrm1  = 1     + l
C**   POINTER ON PART OF BUFFER FOR R_K+1
      ibrp1  = 1     + l*2
C**   POINTER ON PART OF BUFFER FOR R_SMOOTHED
      ibrs   = 1     + l*3
C**   POINTER ON PART OF BUFFER FOR PR*R_K
      ibPRr  = 1     + l*4
C**   POINTER ON PART OF BUFFER FOR A*R_K
      ibA2r  = 1     + l*5
C**   POINTER ON PART OF BUFFER FOR A*R_K
      ibAr   = 1     + l*6
C**   POINTER ON PART OF BUFFER FOR X_K
      ibx    = 1     + l*7
C**   POINTER ON PART OF BUFFER FOR X_K-1
      ibxm1  = 1     + l*8
C**   POINTER ON PART OF BUFFER FOR X_K+1
      ibxp1  = 1     + l*9
C**   POINTER ON PART OF BUFFER FOR X_SMOOTHED
      ibxs   = 1     + l*10
C**   POINTER ON PART OF BUFFER FOR DATA BUFFERING
      ibh1   = 1     + l*11
C**   POINTER ON PART OF BUFFER FOR COMMUNICATION
      ibcom  = 1     + l*12

      if (mod(ilin(8),3) .eq. 2 .or. ilin(8) .eq. 0) then
        ibAr = ibh1
      endif

C**                                                                 ***
C**   INITIAL VALUES                                                ***
C**                                                                 ***
      include "norec.h"
      do 110 i = 1,l
        x(i)  = zero
        dw(i+ibr-1) = - b(i)
  110 continue

      include "norec.h"
      do 122 i=0,l-1
        dw(ibrs+i)  = dw(ibr+i)
        dw(ibx+i)   = x(i+1)
        dw(ibxs+i)  = x(i+1)
  122 continue

      count = 0
C**                                                                 ***
C***  COMPUTE ||r0||2                                               ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &            b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.true.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (400,420,430) branch
C**                                                                 ***
C***  INITIAL VALUES                                                ***
C**                                                                 ***
      do 130 i = 1,2
         an(i) = zero
         ak(i) = zero
  130 continue
 
C**                                                                 ***
C***  START OF THE ITERATION-LOOP                                   ***
C**                                                                 ***

  200 continue
      count = count+1

      if (mod(ilin(8),3) .eq. 1 .or. ilin(8) .eq. 0) then
        ibPRr = ibr
      endif

C**                                                                 ***
C**  COMPUTATION OF PR * R_K                                        ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then
C
       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibr),dw(ibPRr),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(8)+1),dw(ibr),dw(ibPRr),dw(ibcom),
     #             ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,tid,
     #             myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #              lsym,ia1,info,mat,prec,dw(ibr),dw(ibPRr),dw,iprec,
     #              index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #              iconv,ierr)
       endif
      endif

C**                                                                 ***
C***  COMPUTATION OF A*R_K                                          ***
C**                                                                 ***
      call LL3ATX(LL6ATX,mat,dw(ibPRr),dw(ibA2r),dw(ibcom),ptrmbk,
     #            lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #            ladd,lmat,lindex,ia1,info,index,nmsg)
      imvm = imvm + 1
      call LL3AX(LL6AX,mat,dw(ibA2r),dw(ibh1),dw(ibcom),ptrmbk,
     #           lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #           ladd,lmat,lindex,ia1,info,index,nmsg)
      imvm = imvm + 1

C**                                                                 ***
C***  COMPUTATION OF PL * A * A_TRANS * PR * R_K                    ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then
C
       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibh1),dw(ibAr),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3ASX(prec(iprec(7)+1),dw(ibh1),dw(ibAr),dw(ibcom),
     #             ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,tid,
     #             myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #             iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3FEL(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #              lsym,ia1,info,mat,prec,dw(ibh1),dw(ibAr),dw,
     #              iprec,index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              myproc,iconv,ierr)
       endif
      endif

C**                                                                 ***
C***  COMPUTATION OF R_K_TRANS * R_K   AND                          ***
C***                 R_K_TRANS * A*R_K                              ***
C**                                                                 ***
      ptrdw2(1) = ibr
      ptrdw2(2) = ibAr
      call LL4SCP(lmyblk,ione,l,2,dw,ibr,dw,ptrdw2,
     #            ak,help,.false.,myproc,nproc,tid,nmsg) 
      an(1) = 1.d0/ak(1)
      ak(1) = - ak(2)*an(1)
      ak(2) = 0.d0
      if (count .gt. 1) then
        call LL4SCP(lmyblk,ione,l,1,dw,ibrm1,dw,ibAr,
     #              ak(2),help,.false.,myproc,nproc,tid,nmsg) 
        ak(2) = - ak(2)*an(2)
      endif
C**                                                                 ***
      sum = 0.
      do 210 i = 1,2
         sum = sum + ak(i)
  210 continue
C**                                                                 ***
      if (sum .eq. zero) then
         ierr = 1291
	 if (ilin(13) .lt. 0) then 
	   write(lout,1020)
	   write(lout,1250)
	   write(lout,1030)
         endif
	 if (ilin(13) .ge. 0) then
	   if (myproc .eq. 1) then
	     write(lout,1020)
	     write(lout,1250)
	     write(lout,1030)
	   endif
         endif
         goto 440
      else
         sum = one/sum
      endif
C**                                                                 ***
C***  COMPUTATION OF X_K+1                                          ***
C**                                                                 ***
      if (count .eq. 1) then
      include "norec.h"
        do 220 i=0,lmyblk-1
          dw(ibxp1+i) = (dw(ibPRr+i)+ak(1)*dw(ibx+i))*sum
 220    continue
      else
      include "norec.h"
        do 230 i=0,lmyblk-1
          dw(ibxp1+i) = (dw(ibPRr+i)+ak(1)*dw(ibx+i)
     &                              +ak(2)*dw(ibxm1+i))*sum
 230    continue
      endif
C**                                                                 ***
C***  COMPUTATION OF R_K+1                                          ***
C**                                                                 ***
      if (count .eq. 1) then
      include "norec.h"
        do 240 i=0,lmyblk-1
           dw(ibrp1+i) = (dw(ibAr+i)+ak(1)*dw(ibr+i))*sum
 240    continue
      else
      include "norec.h"
        do 250 i=0,lmyblk-1
           dw(ibrp1+i) = (dw(ibAr+i)+ak(1)*dw(ibr+i)
     &                               +ak(2)*dw(ibrm1+i))*sum
 250    continue
      endif

C**                                                                 ***
C***  SWAP POINTERS TO BUFFERS FOR SOLUTION X AND RESIDUUM R        ***
C**                                                                 ***
      an(2) = an(1)
 
      swap  = ibrm1
      ibrm1 = ibr
      ibr   = ibrp1
      ibrp1 = swap
 
      swap  = ibxm1
      ibxm1 = ibx
      ibx   = ibxp1
      ibxp1 = swap

C**                                                                 ***
C***  SMOOTHING OF THE SOLUTION X AND THE RESIDUUM R                ***
C**                                                                 ***
  400 call LL8SMO(dw,ibrs,ibr,ibxs,ibx,ibcom,ldw,l,lmyblk,
     #            myproc,nproc,tid,nmsg)
 
C**                                                                 ***
C***  CHECK STOPPING CRITERION                                      ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &            b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.false.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (410,420,430) branch
C
      goto 200
C
C***  END OF THE ITERATION-LOOP
C
  410 iconv = 1
      if (ilin(13) .le. -2) write(lout,1410) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1410) imvm
      endif
      goto 500
  420 iconv = 2
      if (ilin(13) .le. -2) write(lout,1420) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1420) imvm
      endif
      goto 500
  430 iconv = 3
      if (ilin(13) .lt. 0) write(lout,1430) imvm
      if (ilin(13) .gt. 0) then
	 if (myproc .eq. 1) write(lout,1430) imvm
      endif
      goto 500
  440 iconv = 4
  500 ilin(10) = imvm
      ilin(3)  = nmsg
      CALL POLYF(iconv)

      if (ilin(18) .ne. 0) then
      include "norec.h"
        do 600 i = 1,lmyblk
	  x(i) = dw(ibxs+i-1)
  600   continue
      else
      include "norec.h"
        do 610 i = 1,lmyblk
	  x(i) = dw(ibx+i-1)
  610   continue
      endif
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
 1020 format(' ****************************************'/
     &       ' ***  Error occured in LINSOL:        ***')
 1250 format(' ***  Sum of coefficients is zero!    ***'/
     &       ' ***  CG-AT method not applicable.    ***')
 1030 format(' ****************************************')
 1410 format('    Convergence after',i8,
     &       ' matrix-vector multiplications')
 1420 format('    Iteration reached maximum number of',
     &       ' matrix-vector multiplications:',i7)
 1430 format('    Divergence after',i9,
     &       ' matrix-vector multiplications')
C**                                                                 ***
C**---END OF LL1CGT-------------------------------------------------***
C**                                                                 ***
      e    n    d
