C:::::      ,,,,,LL1GME.....
C
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL1GME(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #                  mat,prec,x,b,
     #                  iprec,index,ia1,info,dw,iw,
     #                  ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #                  eps,epslin,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 1 G M E      GMERR-GS-method for the solution of the   ***
C**      linear system    MAT * x = b.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER : H. Haefner                                    ***
C**                                                                 ***
C**      [ldw must be (14+2*nterms)*l]                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           ldw,liw,lmat,lprec,liprec,lindex,l,ia1,nproc,
     #                  index(lindex),info(ia1,ia2),lmatbk(nproc),
     #                  ptrmbk(nproc+1),jump(nproc),tid(nproc),
     #                  ptrinf(ntyp+1,nproc),iprec(liprec),iw(liw),
     #                  ilin(nilin),iconv,ierr
      double precision  mat(lmat),prec(lprec),x(l),b(l),
     #                  dw(ldw),eps,epslin
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :    (SEE LINSOL)                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**                    
      integer    nterms
      parameter (nterms = 20)
      double precision gamma,rho,alfa(nterms),phi,delta
      logical break
      integer swap,iterms
      external LL6AX,LL6ATX
      logical  ladd
      integer  i,imvm,count,nmsg,lout,myproc,lmyblk,z,ione,branch
      character*10  method
      integer ibr,ibrs,ibx,ibxs,ibxt,ibb,ibf,ibcom,ibq,iby,ibNb
      integer ibqm(nterms),ibym(nterms),ptrl(nterms),ptrr(4),idoku
      double precision zero,one,sprod(nterms),help(nterms)

C**                                                                 ***
C**        CONSTANTS :                                              ***
C**        ---------                                                ***
C**                                                                 ***
      parameter  (zero = 0.0, one = 1.0, delta = 1.e-10, ione = 1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      method = '    GMERR '
      call POLY1('smoothed GMERR(5)','VECFEM',ptrmbk(nproc+1),0,0.)

      ladd = .false.
C**                                                                 ***
      imvm  = ilin(10)
      iconv = 0
C**                                                                 ***
      nmsg   = ilin(3)
      lout   = ilin(12)
      idoku  = ilin(13)
      myproc = ilin(17)
      lmyblk = lmatbk(myproc)

      ibNb   = 4*l+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** SET POINTERS :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      ibr   = 1
      ibrs  = 1*l+1
      ibx   = 2*l+1
      ibxs  = 3*l+1
      ibxt  = 4*l+1
      ibb   = 5*l+1
      ibf   = 6*l+1
      ibcom = 7*l+1
      ibq   =12*l+1
      do 108 i=1,nterms
	ibqm(i) = (12+i)*l+1
  108 continue
      iby   =(13+nterms)*l+1
      do 109 i=1,nterms
	ibym(i) = (13+nterms+i)*l+1
  109 continue
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      include "norec.h"
      do 110 i = 1,l
        x(i)  = zero
        dw(i+ibr-1) = - b(i)
  110 continue

      include "norec.h"
      do 122 i=0,l-1
        dw(ibrs+i) = dw(ibr+i)
        dw(ibx+i) = x(i+1)
        dw(ibxs+i) = x(i+1)
  122 continue

      count = 0
C**                                                                 ***
C***  COMPUTE ||r0||2                                               ***
C**                                                                 ***
      ilin(13) = 2
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),b,prec,dw(ibcom),
     &            l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.true.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      ilin(13) = idoku
      goto (910,920,930) branch
      if (ilin(13) .lt. 0) then
        write(lout,1400) nterms
        if (abs(nterms-idoku) .ne. 0) write(lout,1405)
      endif
      if (ilin(13) .ge. 0) then
        if (myproc .eq. 1) then
          write(lout,1400) nterms
          if (abs(nterms-idoku) .ne. 0) write(lout,1405)
        endif
      endif
C**                                                                 ***
C***  INITIAL VALUES                                                ***
C**                                                                 ***
      iterms = 0

      include "norec.h"
      do 2001 z=0,lmyblk-1
        dw(ibb+z) = b(z+1)
 2001 continue

      call LL3ATX(LL6ATX,mat,dw(ibr),dw(ibqm(1)),dw(ibcom),ptrmbk,
     #            lmatbk,ptrinf,l,nproc,tid,myproc,jump,ladd,lmat,
     #            lindex,ia1,info,index,nmsg)
      imvm=imvm+1

      call LL4SCP(lmyblk,1,l,1,dw,ibqm(1),dw,ibqm(1),rho,help,.false.,
     #            myproc,nproc,tid,nmsg)
      rho=one/sqrt(rho)

      include "norec.h"
      do 2002 z=0,lmyblk-1
        dw(ibym(1)+z)=dw(ibr+z)*rho
        dw(ibqm(1)+z)=dw(ibqm(1)+z)*rho
 2002 continue
      goto 111


C**
C***  RESTART
C**

 101  continue

        if ((ilin(1) .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
          do 150 i = 1,lmyblk
            dw(ibxt+i-1) = prec(i)*x(i)
 150      continue
        else
          do 152 i = 1,lmyblk
            dw(ibxt+i-1) = x(i)
 152      continue
        endif

        call LL3AX(LL6AX,mat,dw(ibxt),dw(ibr),dw(ibcom),ptrmbk,
     #             lmatbk,ptrinf,l,nproc,tid,myproc,jump,ladd,
     #             lmat,lindex,ia1,info,index,nmsg)
        imvm=imvm+1

C****   r(1..l)  =  (N*A*x - N*b)
        include "norec.h"
        do 154 i=0,lmyblk-1
          dw(ibr+i) = dw(ibr+i) - prec(ibNb+i)
 154    continue
C**** ORIGINAL SYSTEM IS CONSIDERED
C****   r(1..l)  =  N[-1]*(N*A*x - N*b)
        if (ilin(9) .eq. 1) then
          include "norec.h"
          do 156 i=1,lmyblk
            dw(ibr+i-1) = dw(ibr+i-1)/prec(i)
 156      continue
	endif
C**                                                                 ***
C***  SMOOTHING OF THE SOLUTION X AND THE RESIDUUM R                ***
C**                                                                 ***
        call LL8SMO(dw,ibrs,ibr,ibxs,ibxt,ibcom,ldw,l,lmyblk,
     #              myproc,nproc,tid,nmsg)
C**                                                                 ***
C***  CHECK STOPPING CRITERION                                      ***
C**                                                                 ***
        ilin(13) = 2
        call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibxt),b,prec,
     &              dw(ibcom),l,lprec,lmyblk,epslin,
     &              ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &              lindex,info,ia1,lsym,ladd,
     &              method,.false.,myproc,nproc,tid,nmsg,ilin,ierr,
     &              count,imvm,branch)
        ilin(13) = idoku
        goto (910,920) branch

        call LL3ATX(LL6ATX,mat,dw(ibr),dw(ibqm(1)),dw(ibcom),ptrmbk,
     #              lmatbk,ptrinf,l,nproc,tid,myproc,jump,ladd,lmat,
     #              lindex,ia1,info,index,nmsg)
        imvm=imvm+1

        call LL4SCP(lmyblk,1,l,1,dw,ibqm(1),dw,ibqm(1),rho,help,
     #              .false.,myproc,nproc,tid,nmsg)
        rho = one/sqrt(rho)
        include "norec.h"
        do 2004 z=0,lmyblk-1
          dw(ibym(1)+z) = dw(ibr+z)*rho
          dw(ibqm(1)+z) = dw(ibqm(1)+z)*rho
 2004   continue
        iterms = 0
C**
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***  START OF THE ITERATION-LOOP                                   ***
C**                                                                 ***

  111 continue

      count = count+1
      iterms = iterms+1

      ptrl(1)=ibb
      ptrr(1)=ibym(1)
      ptrl(2)=ibx
      ptrr(2)=ibqm(1)
      call LL4SCP(lmyblk,2,l,2,dw,ptrl,dw,ptrr,sprod,help,.true.,
     #            myproc,nproc,tid,nmsg)
      gamma = sprod(1)-sprod(2)

      include "norec.h"
      do 2005 z=0,lmyblk-1
        dw(ibx+z) = dw(ibx+z) + gamma*dw(ibqm(1)+z)
 2005 continue

      if (iterms .gt. nterms) goto 101

      if (mod(iterms,idoku).eq.0 .and. abs(iterms-nterms).gt.2) then

        if ((ilin(1) .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
          do 160 i = 1,lmyblk
            dw(ibxt+i-1) = prec(i)*x(i)
 160      continue
        else
          do 162 i = 1,lmyblk
            dw(ibxt+i-1) = x(i)
 162      continue
        endif

        call LL3AX(LL6AX,mat,dw(ibxt),dw(ibr),dw(ibcom),ptrmbk,
     #             lmatbk,ptrinf,l,nproc,tid,myproc,jump,ladd,
     #             lmat,lindex,ia1,info,index,nmsg)
        imvm=imvm+1

C****   r(1..l)  =  (N*A*x - N*b)
        include "norec.h"
        do 164 i=0,lmyblk-1
          dw(ibr+i) = dw(ibr+i) - prec(ibNb+i)
 164    continue
C**** ORIGINAL SYSTEM IS CONSIDERED
C****   r(1..l)  =  N[-1]*(N*A*x - N*b)
        if (ilin(9) .eq. 1) then
          include "norec.h"
          do 166 i=1,lmyblk
            dw(ibr+i-1) = dw(ibr+i-1)/prec(i)
 166      continue
	endif
C**                                                                 ***
C***  SMOOTHING OF THE SOLUTION X AND THE RESIDUUM R                ***
C**                                                                 ***
        call LL8SMO(dw,ibrs,ibr,ibxs,ibxt,ibcom,ldw,l,lmyblk,
     #              myproc,nproc,tid,nmsg)
C**                                                                 ***
C***  CHECK STOPPING CRITERION                                      ***
C**                                                                 ***
        ilin(13) = 2
        call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibxt),b,prec,
     &              dw(ibcom),l,lprec,lmyblk,epslin,
     &              ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &              lindex,info,ia1,lsym,ladd,
     &              method,.false.,myproc,nproc,tid,nmsg,ilin,ierr,
     &              count,imvm,branch)
        ilin(13) = idoku
        goto (910,920) branch
      endif
C**                                                                 ***
C***  COMPUTE VECTOR <F>                                            ***
C**                                                                 ***
      call LL3ATX(LL6ATX,mat,dw(ibqm(1)),dw(ibf),dw(ibcom),ptrmbk,
     #            lmatbk,ptrinf,l,nproc,tid,myproc,jump,ladd,
     #            lmat,lindex,ia1,info,index,nmsg)
      imvm=imvm+1

      include "norec.h"
      do 2007 z=0,lmyblk-1
        dw(ibq+z) = dw(ibf+z)
        dw(iby+z) = dw(ibqm(1)+z)
 2007 continue

      do 130 i=1,iterms
        ptrl(i) = ibqm(i)
  130 continue
      call LL4SCP(lmyblk,iterms,l,1,dw,ptrl,dw,ibf,alfa(1),
     #            help,.false.,myproc,nproc,tid,nmsg)

      do 135 i=1,iterms
        include "norec.h"
        do 2008 z=0,lmyblk-1
          dw(ibq+z) = dw(ibq+z) - alfa(i)*dw(ibqm(i)+z)
          dw(iby+z) = dw(iby+z) - alfa(i)*dw(ibym(i)+z)
 2008   continue
  135 continue

      call LL4SCP(lmyblk,1,l,1,dw,ibq,dw,ibq,phi,help,.false.,
     #            myproc,nproc,tid,nmsg)
      phi=sqrt(phi)
      if (phi .lt. delta) then
        ierr = 1271
        if (break) then
          if (ilin(13) .lt. 0) then
            write(lout,1020)
            write(lout,1250)
            write(lout,1030)
          endif
          if (ilin(13) .ge. 0) then
            if (myproc .eq. 1) then
              write(lout,1020)
              write(lout,1250)
              write(lout,1030)
            endif
          endif
          goto 940
        else
          if (ilin(13) .lt. 0) write(lout,1350) count,delta
          if (ilin(13) .ge. 0) then
            if (myproc .eq. 1) write(lout,1350) count,delta
          endif
          break = .true.
          goto 101
        endif
      endif
      break = .false.

      phi = 1/phi

      include "norec.h"
      do 2028 z=0,lmyblk-1
        dw(ibq+z) = phi* dw(ibq+z)
        dw(iby+z) = phi* dw(iby+z)
 2028 continue
C**
      swap = ibym(nterms)
      do 140 i=nterms,2,-1
	ibym(i) = ibym(i-1)
  140 continue
      ibym(1)   = iby
      iby       = swap

      swap = ibqm(nterms)
      do 145 i=nterms,2,-1
	ibqm(i) = ibqm(i-1)
  145 continue
      ibqm(1)   = ibq
      ibq       = swap
C
      goto 111
C
C***  END OF THE ITERATION-LOOP
C
  910 iconv = 1
      if (ilin(13) .le. -2) write(lout,1410) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1410) imvm
      endif
      goto 900
  920 iconv = 2
      if (ilin(13) .le. -2) write(lout,1420) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1420) imvm
      endif
      goto 900
  930 iconv = 3
      if (ilin(13) .lt. 0) write(lout,1430) imvm
      if (ilin(13) .gt. 0) then
	 if (myproc .eq. 1) write(lout,1430) imvm
      endif
      goto 900
  940 iconv = 4
  900 ilin(10) = imvm
      ilin(3)  = nmsg
      CALL POLYF(iconv)

      if (ilin(18) .ne. 0) then
      include "norec.h"
        do 901 i = 1,lmyblk
	  x(i) = dw(ibxs+i-1)
  901   continue
      else
      include "norec.h"
        do 902 i = 1,lmyblk
	  x(i) = dw(ibx+i-1)
  902   continue
      endif
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
 1020 format(' ****************************************'/
     &       ' ***  Error occured in LSOLPP:        ***')
 1250 format(' ***  Restart takes place in direct   ***'/
     &       ' ***  succession  -->  GMERR stops    ***')
 1030 format(' ****************************************')
 1350 format('    Step:',i7,'  Restart: phi =< ',g7.1)
 1400 format('    Restart value is ',i3)
 1405 format('    WARNING: idoku {ilin(13)} should be set to the '/
     &       '    restart value, else additional MVMs are performed')
 1410 format('    Convergence after',i8,
     &       ' matrix-vector multiplications')
 1420 format('    Iteration reached maximum number of',
     &       ' matrix-vector multiplications:',i7)
 1430 format('    Divergence after',i9,
     &       ' matrix-vector multiplications')
C**                                                                 ***
C**---END OF LL1GME-------------------------------------------------***
C**                                                                 ***
      e    n    d
