C:::::      ,,,,,LL1NRM.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL1NRM(lmat,lprec,lindex,l,ldw,liw,nproc,
     &                  lsym,ia1,info,mat,prec,x,b,dw,
     &                  index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,
     &                  tid,myproc,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 1 N R M   computes the NoRMalization                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996        ***
C**     PROGRAMMER: H. Haefner                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
C**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lprec,lindex,l,ldw,liw,ia1,iconv,
     #                  ierr,nproc,ierproc
      double precision  mat(lmat),prec(lprec),x(l),b(l),dw(ldw)
      integer           index(lindex),info(ia1,ia2),
     #                  iw(liw),ilin(nilin),lmatbk(nproc),
     #                  ptrmbk(nproc+1),jump(nproc),tid(nproc),
     #                  ptrinf(ntyp+1,nproc),myproc
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   (see Manual-Pages <linsol>)                                   ***
C**                                                                 ***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
      integer            adda,i,ione,lout,ibcom,inrow,main,nmsg,
     &                   lmyblk,ptsmyb,iermax,ihelp,typ,lmain
      double precision   one,zero,xexact
      logical            lerr
      external           LL5RST,LL5SST,LL5AP

      common /solex/ xexact(1)
C**                                                                 ***
C**      CONSTANTS :                                                ***
C**      -----------                                                ***
C**                                                                 ***
      parameter (zero = 0.0, one = 1.0, ione = 1)
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ierr = 0
      iermax=0
C
      inrow  = 0
      nmsg   = ilin(3)
      lout   = ilin(12)
      lmyblk = lmatbk(myproc)
      ptsmyb = ptrmbk(myproc)
      main   = 1  
      ibcom  = l+1  
      if (ptrinf(2,myproc) .gt. ptrinf(1,myproc)) then
        if ((ilin(6) .eq. 0) .and. (ilin(15) .ne. 0)) then
          adda   = info(ptrinf(1,myproc)+1,2)
	  do 11 i=1,l
	    dw(i+main-1) = mat(i+adda)
  11      continue
        endif
      else
        if ((ilin(6) .eq. 0 .and. ilin(15) .ne. 0) .or. lsym) then
          call LL5DIA(lmat,lindex,ldw,l,lmain,main,ia1,mat,dw,info,
     #                ilin,index,ptrinf,nproc,myproc,lmyblk,ptsmyb)
	  if (lsym) then
            call LL4INM(ione,ione,ione,lmain,iermax,ihelp,myproc,
     #                  nproc,tid,nmsg)
	    if (iermax .ge. 1) then
	      ierr = 1105
	      goto 888
	    else
	      if (ilin(15).eq.2 .or. ilin(15).eq.12
     #            .or. ilin(15).eq.4 .or. ilin(15).eq.14) then 
	        ierr = 1100
	        goto 888
	      endif
	    endif
	  endif
	endif
      endif
C**                                                                 ***
C**                                                                 ***
C**   COMPUTE NRMCONDITIONING MATRIX IF WANTED :                    ***
C**   (IF ILIN(6)>0 THEN THE MATRIX IS ALREADY NORMALIZED           ***
C**    AND ONLY THE RIGHT HAND SIDE HAS TO BE NORMALIZED)           ***
C**   ---------------------------------------------------------     ***
C**    NRMC*MAT*NRMC*NRMC^-1*x = NRMC*b <==>                        ***
C**         MAT~    *   x~     =   b~    ==>                        ***
C**                     x~     = NRMC^-1*x                          ***
C**                                                                 ***

  111 continue
C**                                                                 ***
      if (ilin(6) .eq. 0) then
C**                                                                 ***
C**   Normalization by row sum                                      ***
C**                                                                 ***
         if ((ilin(15) .eq. 1) .or. (ilin(15) .eq. 11)) then
	    if (ilin(13) .lt. 0) write(lout,1351)
	    if (ilin(13) .gt. 0) then
	       if (myproc .eq. 1) write(lout,1351)
            endif
            call LL5RSA(lmat,l,lindex,ptsmyb,prec,
     #                  ia1,info,mat,index,ptrinf,nproc) 
            if (lsym) then
              call LL3ATX(LL5RST,mat,prec,prec,dw(ibcom),
     #                    ptrmbk,lmatbk,ptrinf,l,nproc,tid,
     #                    myproc,jump,.true.,lmat,lindex,ia1,info,
     #                    index,nmsg)
            endif
	    lerr = .false.
	    do 30 i = 1,lmyblk
	      if (prec(i) .gt. zero) then
	        prec(i) = sign(one,dw(i+main-1))/prec(i)
              else
	        lerr    = .true.
	        ierproc = myproc
	        inrow   = i+ptsmyb
              endif
   30       continue
	    if (lerr) then
	      ierr = 1102
            endif
         endif

C**                                                                 ***
C**   Normalization by diagonal element                             ***
C**                                                                 ***
         if ((ilin(15) .eq. 2) .or. (ilin(15) .eq. 12)) then
	    if (ilin(13) .lt. 0) write(lout,1352)
	    if (ilin(13) .gt. 0) then
	       if (myproc .eq. 1) write(lout,1352)
            endif
	    lerr = .false.
	    do 40 i = 1,lmyblk
	      if (dw(i+main-1) .ne. zero) then
	        prec(i) = 1./dw(i+main-1)
              else
	        lerr    = .true.
	        ierproc = myproc
	        inrow   = i+ptsmyb
              endif
   40       continue
	    if (lerr) then
	      ierr = 1101
            endif
         endif

C**                                                                 ***
C**   Normalization by square sum                                   ***
C**                                                                 ***
         if ((ilin(15) .eq. 3) .or. (ilin(15) .eq. 13)) then
	    if (ilin(13) .lt. 0) write(lout,1353)
	    if (ilin(13) .gt. 0) then
	       if (myproc .eq. 1) write(lout,1353)
            endif
            call LL5SSA(lmat,l,lindex,ptsmyb,prec,
     #                  ia1,info,mat,index,ptrinf,nproc) 
            if (lsym) then
              call LL3ATX(LL5SST,mat,prec,prec,dw(ibcom),
     #                    ptrmbk,lmatbk,ptrinf,l,nproc,tid,
     #                    myproc,jump,.true.,lmat,lindex,ia1,info,
     #                    index,nmsg)
            endif
	    lerr = .false.
	    do 50 i = 1,lmyblk
	      if (prec(i) .gt. zero) then
	        prec(i) = 1./sqrt(prec(i))
              else
	        lerr    = .true.
	        ierproc = myproc
	        inrow   = i+ptsmyb
              endif
   50       continue
	    if (lerr) then
	      ierr = 1103
            endif
         endif

C**                                                                 ***
C**   Froboenius Normalization                                      ***
C**                                                                 ***
         if ((ilin(15) .eq. 4) .or. (ilin(15) .eq. 14)) then
	    if (ilin(13) .lt. 0) write(lout,1354)
	    if (ilin(13) .gt. 0) then
	       if (myproc .eq. 1) write(lout,1354)
            endif
            call LL5SSA(lmat,l,lindex,ptsmyb,prec,
     #                  ia1,info,mat,index,ptrinf,nproc) 
            if (lsym) then
              call LL3ATX(LL5SST,mat,prec,prec,dw(ibcom),
     #                    ptrmbk,lmatbk,ptrinf,l,nproc,tid,
     #                    myproc,jump,.true.,lmat,lindex,ia1,info,
     #                    index,nmsg)
            endif
	    lerr = .false.
	    do 60 i = 1,lmyblk
	      if (prec(i) .gt. zero) then
	        prec(i) = dw(i+main-1)/prec(i)
              else
	        lerr    = .true.
	        ierproc = myproc
	        inrow   = i+ptsmyb
              endif
   60       continue
	    if (lerr) then
	      ierr = 1104
            endif
         endif

         if (ilin(15) .eq. 0) then
	    if (ilin(13) .lt. 0) write(lout,1350)
	    if (ilin(13) .gt. 0) then
	       if (myproc .eq. 1) write(lout,1350)
            endif
            do 70 i = 1,lmyblk
               prec(i) = one
   70       continue
         else
           if (((ilin(15) .gt. 10) .or. lsym) .and. (ierr .eq. 0)) then
             do 80 i = 1,lmyblk
               prec(i) = sqrt(abs(prec(i)))
   80        continue
           endif
         endif
      else 
C**                                                                 ***
C**   Matrix is already normalized                                  ***
C**                                                                 ***
         do 10 i=1,lmyblk
            b(i) = b(i) * prec(i)
   10    continue
         if (ilin(16) .eq. 4711) then
           if ((ilin(1).eq.9) .or. (ilin(15) .gt. 10) .or. lsym) then
             do 20 i=1,lmyblk
               x(i) = x(i) / prec(i)
   20        continue
           endif
         endif
      endif
C**                                                                 ***
  888 call LL4INM(ione,ione,ione,ierr,iermax,ihelp,myproc,
     &            nproc,tid,nmsg)
C**                                                                 ***
      if (iermax .gt. 1100 .and. iermax .le. 1101) then
	if (ierproc .eq. myproc) then 
	  write(lout,1021)
	  if (iermax .eq. 1100) write(lout,1416)
	  if (iermax .eq. 1101) write(lout,1417) inrow,ierproc
	  write(lout,1030)
        endif
	if (lsym) then
	  ilin(15) = 11
	else
	  ilin(15) = 1
	endif
	ierr     = 0
	inrow    = 0
	goto 111
      endif
      if (iermax .gt. 1101) then
	if (ierproc .eq. myproc) then 
	  write(lout,1020)
	  if (iermax .le. 1104) write(lout,1414) ierproc,inrow
	  if (iermax .eq. 1105) write(lout,1415) ierproc
	  write(lout,1030)
        endif
	ierr = iermax
	iconv = 4
	goto 999
      endif
C**                                                                 ***
C**   IF (LSYM) THEN COMPUTE MATRIX NRMC*MAT*NRMC                   ***
C**   IF (NOT LSYM) THEN COMPUTE MATRIX  NRMC*MAT                   ***
C**   COMPUTE VECTOR B =  NRMC*B                                    ***
C**                                                                 ***
      if ((ilin(6) .eq. 0) .and. (ilin(15) .ne. 0)) then
        if ((lsym) .or. (ilin(15) .ge. 11)) then
	  if (ilin(13) .lt. 0) write(lout,1355)
	  if (ilin(13) .gt. 0) then
	    if (myproc .eq. 1) write(lout,1355)
          endif
          call LL3AX(LL5AP,mat,prec,prec,dw(ibcom),ptrmbk,
     #               lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #               .true.,lmat,lindex,ia1,info,index,nmsg)
        endif
        call LL5PA(lmat,lindex,lprec,ptsmyb,prec,
     #             ia1,info,mat,index,ptrinf,nproc)
	do 88 i=1,lmyblk
	  b(i) = b(i)*prec(i)
   88   continue
        ilin(6)=1
        if ((ilin(1) .eq. 9) .or. (ilin(15) .ge. 11) .or. lsym) then 
	  lerr=.false.
	  do 90 i=2,lmyblk
	    if (sign(one,dw(main+i-1)) .ne. sign(one,dw(main))) then
	      lerr=.true.
            endif
   90     continue
	  if (lerr) then
	    if (ilin(13) .lt. 0) then 
	      write(lout,1021)
	      write(lout,1418)
	      write(lout,1030)
            endif
	    if (ilin(13) .gt. 0) then
	      if (myproc .eq. 1) then
	        write(lout,1021)
	        write(lout,1418)
	        write(lout,1030)
              endif
            endif
          endif
          if (ilin(16) .eq.  4711) then
            do  92  i=1,lmyblk
              x(i) = x(i) / prec(i)
   92       continue
          endif
          if (ilin(20) .ge.  1000) then
            do 94 i = 1,lmyblk
              xexact(i) = xexact(i) / prec(i)
   94       continue
          endif
        endif
      endif

  999 continue
C
C
C**** END OF CALCULATION
C     ------------------
C
 1020 format(' ***************************************************'/
     &       ' ***  Error occured in LSOLPP (Normalization):   ***')
 1021 format(' ***************************************************'/
     &       ' ***  Warning  (Normalization):                  ***')
 1414 format(' ***   Normalization failed on processor ',i6,'; ***'/
     &       ' ***   Row  ',i6,' contains no nonzero element;  ***'/
     &       ' ***   Matrix is nonregular!                     ***')
 1415 format(' ***   Normalization failed on processor ',i6,'; ***'/
     &       ' ***   Matrix is symmetric and no explicit main  ***'/
     &       ' ***   diagonal is specified by the user  -->    ***'/
     &       ' ***   hidden (in storage patterns 2-11)         ***'/
     &       ' ***   diagonal elements are not allowed!        ***')
 1416 format(' ***   No explicit main diagonal is specified    ***'/
     &       ' ***   by the user  -->  LSOLPP switchs to       ***'/
     &       ' ***   row sum normalization!                    ***')
 1417 format(' ***   The main diagonal element of line ',i6,'  ***'/
     &       ' ***   on processor ',i6,' contains a zero       ***'/
     &       ' ***   element  -->  LSOLPP switchs to row sum   ***'/
     &       ' ***   normalization!                            ***')
 1418 format(' ***   The main diagonal elements have           ***'/
     &       ' ***   different signs!                          ***')
 1030 format(' ***************************************************')
 1350 format('    No normalization')
 1351 format('    Normalized by sign A_ii/sum abs(A_ij),j=1,l')
 1352 format('    Normalized by 1/A_ii')
 1353 format('    Normalized by 1/sqrt(sum A_ij**2,j=1,l)')
 1354 format('    Normalized by A_ii/sum A_ij**2,j=1,l')
 1355 format('    Symmetric normalization')
      r e t u r n
C-----END OF LL1NRM----------------------------------------------------
      e    n    d
