C:::::      ,,,,,LL1P20.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL1P20(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #                  mat,prec,x,b,
     #                  iprec,index,ia1,info,dw,iw,
     #                  ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #                  eps,epslin,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 1 P 2 0      PRES20-method for the solution of the     ***
C**      linear system    MAT * x = b.                              ***
C**                                                                 ***
C**      (ldw must be 22*l)                                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER : H. Haefner                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           ldw,liw,lmat,lprec,liprec,lindex,l,ia1,nproc,
     #                  index(lindex),info(ia1,ia2),lmatbk(nproc),
     #                  iprec(liprec),iw(liw),
     #                  ptrmbk(nproc+1),ptrinf(ntyp+1,nproc),
     #                  jump(nproc),tid(nproc),ilin(nilin),iconv,ierr
      double precision  mat(lmat),prec(lprec),x(l),b(l),
     #                  dw(ldw),eps,epslin
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :    (SEE LINSOL)                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer     restart,nores
      parameter  (restart = 20, nores = 5)

      double precision  spc(nores+1),alfa(nores),alf,phi,rrm(nores-1)
      double precision  rbrk(0:nores),r0iter,rseucn,stopit,stopit2,
     *                  rpoly
      integer           coun20,niter,niter2
      logical           lcrash

      external LL6AX
      logical  ladd,lsym2
      integer  i,imvm,count,nmsg,lout,myproc,lmyblk,z,ione,branch
      character*10  method
      integer ibr,ibrm(nores-1),ibrs,ibAr,ibx,ibxm(nores-1),
     *        ibxs,ibxp1,ibrp1,ibPRr,ibh1,ibcom,ptrl(nores+1),
     *        ptrr(nores+1),swap,minres
      double precision zero,one,help(nores+1),rshelp

      common /norms/ rseucn,rpoly(3),lsym2
C**                                                                 ***
C**        CONSTANTS :                                              ***
C**        ---------                                                ***
C**                                                                 ***
      parameter  (zero = 0.0, one = 1.0, ione = 1)
      parameter  (stopit = 0.5, stopit2 = 0.65)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      method = '   PRES20 '
      call POLY1('GMRES(5,20)','VECFEM',ptrmbk(nproc+1),0,0.)

      ladd = .false.
C**                                                                 ***
      imvm  = ilin(10)
      iconv = 0
C**                                                                 ***
      nmsg   = ilin(3)
      lout   = ilin(12)
      myproc = ilin(17)
      lmyblk = lmatbk(myproc)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** SET POINTERS :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      ibr=0*l+1
      do 100 i=1,nores-1
	ibrm(i) = i*l+1
  100 continue
      ibrs=5*l+1
      ibrp1=6*l+1
      ibAr=7*l+1
      ibx=8*l+1
      do 105 i=1,nores-1
	ibxm(i) = (nores+3+i)*l+1
  105 continue
      ibxs=13*l+1
      ibxp1=14*l+1
      ibPRr=15*l+1
      ibh1 =16*l+1
      ibcom=17*l+1

      if (mod(ilin(8),3) .eq. 2 .or. ilin(8) .eq. 0) then
        ibAr = ibh1
      endif

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   INITIAL VALUES                                                ***
C**                                                                 ***
      include "norec.h"
      do 110 i = 1,l
        x(i)  = zero
        dw(i+ibr-1) = - b(i)
  110 continue

      include "norec.h"
      do 122 i=0,l-1
        dw(ibrs+i) = dw(ibr+i)
        dw(ibx+i) = x(i+1)
        dw(ibxs+i) = x(i+1)
  122 continue

      count = 0
C**                                                                 ***
C***  COMPUTE ||r0||2                                               ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &            b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.true.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (410,420,430) branch
C**                                                                 ***
C***  INITIAL VALUES                                                ***
C**                                                                 ***
      niter    = max(20,int(l*nproc/50000)*20)
c     niter2   = max(100,int(l*nproc/10000)*20)
      r0iter   = rseucn
      coun20   = 0

      do 131 i = 1,nores+1
	spc(i) = zero
  131 continue
      do 142 i = 1,nores
	rbrk(i) = one
  142 continue

C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***  START OF THE ITERATION-LOOP                                   ***
C**                                                                 ***

  111 continue
      count = count+1
      coun20 = coun20+1

      if (mod(ilin(8),3) .eq. 1 .or. ilin(8) .eq. 0) then
        ibPRr = ibr
      endif
C**                                                                 ***
C**  COMPUTATION OF PR_ * R_K                                       ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 1 .and. ilin(8) .ne. 0) then
C
       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibr),dw(ibPRr),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(8)+1),dw(ibr),dw(ibPRr),dw(ibcom),
     #             ptrmbk,lmatbk,iprec(iprec(14)+1),l,nproc,tid,
     #             myproc,jump,ladd,iprec(4),iprec(5),iprec(6),
     #             iprec(iprec(13)+1),iprec(iprec(12)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3BWS(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #              lsym,ia1,info,mat,prec,dw(ibr),dw(ibPRr),dw,iprec,
     #              index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #              iconv,ierr)
       endif
      endif

C**                                                                 ***
C***  COMPUTATION OF A*r                                            ***
C**                                                                 ***
      call LL3AX(LL6AX,mat,dw(ibPRr),dw(ibh1),dw(ibcom),ptrmbk,lmatbk,
     #           ptrinf,l,nproc,tid,myproc,jump,ladd,
     #           lmat,lindex,ia1,info,index,nmsg)
      imvm=imvm+1
C**                                                                 ***
C***  COMPUTATION OF PL_SYMM(?) * A * PR * R_K                      ***
C**                                                                 ***
      if (mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then
C
       if (ilin(8) .ge. 1 .and. ilin(8) .le. 30) then
        call LL2IT(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #             lsym,ia1,info,mat,prec,dw(ibh1),dw(ibAr),dw,iprec,
     #             index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     #             iconv,ierr)
       endif
       if (ilin(8) .ge. 31 .and. ilin(8) .le. 60) then
        call LL3AX(LL6AX,prec(iprec(7)+1),dw(ibh1),dw(ibAr),dw(ibcom),
     #             ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,tid,
     #             myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #             iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
        imvm=imvm+1
       endif
       if (ilin(8) .ge. 61 .and. ilin(8) .le. 90) then
        call LL3FEL(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     #              lsym,ia1,info,mat,prec,dw(ibh1),dw(ibAr),dw,
     #              iprec,index,iw,ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              myproc,iconv,ierr)
       endif
      endif

C**                                                                 ***
C***  COMPUTATION OF R_K_TRANS * R_K_STAR   AND                     ***
C***                 R_K_TRANS * A*R_K      AND                     ***
C***                 R_K-i_TRANS * A*R_K   (i=1,2,3,4)              ***
C**                                                                 ***

      minres = min(coun20,nores)

      ptrl(1)=ibr
      ptrr(1)=ibr
      ptrl(2)=ibr
      ptrr(2)=ibAr
      do 200 i=2,minres
        ptrl(i+1)=ibrm(i-1)
        ptrr(i+1)=ibAr
  200 continue
      call LL4SCP(lmyblk,minres+1,l,minres+1,dw,ptrl,dw,ptrr,spc,
     #            help,.true.,myproc,nproc,tid,nmsg)
      alfa(1) = -spc(2)/spc(1)
      do 210 i=2,minres
        alfa(i) = -spc(i+1)/rrm(i-1)
  210 continue

      alf = rbrk(1)*alfa(1)
      do 220 i=2,minres
        alf = alf + rbrk(i)*alfa(i)
  220 continue

      if (alf .eq. zero) then
        phi = one
        rbrk(0) = zero
      else
        phi = one/alf
        rbrk(0) = one
      endif

      include "norec.h"
      do 225 z=0,lmyblk-1
        dw(ibxp1+z) = dw(ibPRr+z) + alfa(1)*dw(ibx+z)
        dw(ibrp1+z) = dw(ibAr+z) + alfa(1)*dw(ibr+z)
 225  continue
      do 230 i=2,minres 
      include "norec.h"
        do 2005 z=0,lmyblk-1
          dw(ibxp1+z) = dw(ibxp1+z) + alfa(i)*dw(ibxm(i-1)+z)
          dw(ibrp1+z) = dw(ibrp1+z) + alfa(i)*dw(ibrm(i-1)+z)
 2005   continue
 230  continue
      include "norec.h"
      do 235 z=0,lmyblk-1
        dw(ibxp1+z) = phi*dw(ibxp1+z)
        dw(ibrp1+z) = phi*dw(ibrp1+z)
 235  continue

      do 501 i=1,nores
	rbrk(i) = rbrk(i-1)
  501 continue

      if (rbrk(1) .eq. zero) then
        if (ilin(13) .le. -2) write(lout,1300)
        if (ilin(13) .ge. 2) then
          if (myproc .eq. 1) write(lout,1300)
        endif
      endif

      lcrash = .true.
      do 502 i=1,nores
	if (rbrk(i) .eq. one) lcrash = .false.
  502 continue

      if (lcrash) then
         ierr = 1211
	 if (ilin(13) .lt. 0) then 
	   write(lout,1020)
	   write(lout,1250)
	   write(lout,1030)
         endif
	 if (ilin(13) .ge. 0) then
	   if (myproc .eq. 1) then
	     write(lout,1020)
	     write(lout,1250)
	     write(lout,1030)
	   endif
         endif
         goto 440
      endif

      do 503 i=nores-1,2,-1
        rrm(i) = rrm(i-1)
  503 continue
      rrm(1) = spc(1)

      swap  = ibxm(nores-1)
      do 504 i=nores-1,2,-1
        ibxm(i) = ibxm(i-1)
  504 continue
      ibxm(1) = ibx
      ibx     = ibxp1
      ibxp1   = swap

      swap  = ibrm(nores-1)
      do 505 i=nores-1,2,-1
        ibrm(i) = ibrm(i-1)
  505 continue
      ibrm(1) = ibr
      ibr     = ibrp1
      ibrp1   = swap

      if (rbrk(1) .eq. zero .and. mod(coun20,restart) .ne. 0) goto 111

C**                                                                 ***
C***  SMOOTHING OF THE SOLUTION X AND THE RESIDUUM R                ***
C**                                                                 ***
      call LL8SMO(dw,ibrs,ibr,ibxs,ibx,ibcom,ldw,l,lmyblk,
     #            myproc,nproc,tid,nmsg)
C**                                                                 ***
C***  CHECK STOPPING CRITERION                                      ***
C**                                                                 ***
      call LL3AXB(dw(ibrs),dw(ibr),dw(ibxs),dw(ibx),
     &            b,prec,dw(ibcom),l,lprec,lmyblk,epslin,
     &            ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &            lindex,info,ia1,lsym,ladd,
     &            method,.false.,myproc,nproc,tid,nmsg,ilin,ierr,
     &            count,imvm,branch)
      goto (410,420,430) branch
C
      if (mod(count,niter) .eq. 0 .and. ilin(1) .eq. 10) then
	if (rseucn/r0iter .ge. stopit) then
	  iconv = 5
	  goto 500
        endif
	r0iter = rseucn
      endif

c     if (mod(count,niter2) .eq. 0 .and. ilin(1) .eq. 100) then
c       rshelp = rseucn/r0iter
c       if (rshelp .ge. stopit2 .and. rshelp .gt. rpoly(2)) then
c         iconv = 5
c         rpoly(1) = rshelp
c         goto 500
c       endif
c     r0iter = rseucn
c     endif

      if (mod(coun20,restart) .eq. 0) then
      include "norec.h"
        do 2006 z=0,lmyblk-1
          dw(ibx+z) = dw(ibxs+z)
	  dw(ibr+z) = dw(ibrs+z)
 2006   continue
	coun20 = 0
        do 512 i = 1,nores
	  rbrk(i) = one
  512   continue
      endif

      goto 111
C
C***  END OF THE ITERATION-LOOP
C
  410 iconv = 1
      if (ilin(13) .le. -2) write(lout,1410) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1410) imvm
      endif
      goto 500
  420 iconv = 2
      if (ilin(13) .le. -2) write(lout,1420) imvm
      if (ilin(13) .ge. 2) then
	 if (myproc .eq. 1) write(lout,1420) imvm
      endif
      goto 500
  430 iconv = 3
      if (ilin(13) .lt. 0) write(lout,1430) imvm
      if (ilin(13) .gt. 0) then
	 if (myproc .eq. 1) write(lout,1430) imvm
      endif
      goto 500
  440 iconv = 4
  500 ilin(10) = imvm
      ilin(3)  = nmsg
      CALL POLYF(iconv)

      if (ilin(18) .ne. 0) then
      include "norec.h"
        do 600 i = 1,lmyblk
	  x(i) = dw(ibxs+i-1)
  600   continue
      else
      include "norec.h"
        do 610 i = 1,lmyblk
	  x(i) = dw(ibx+i-1)
  610   continue
      endif
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
 1020 format(' ****************************************'/
     &       ' ***  Error occured in LINSOL:        ***')
 1250 format(' ***  All alfa-coefficients are zero! ***'/
     &       ' ***  PRES20  method not applicable   ***')
 1030 format(' ****************************************')
 1300 format('    Step:',i7,'  Phi=0 !  Corrective action by'/    
     &       '                 setting phi=1 and alfa(1,k)=0')
 1410 format('    Convergence after',i8,
     &       ' matrix-vector multiplications')
 1420 format('    Iteration reached maximum number of',
     &       ' matrix-vector multiplications:',i7)
 1430 format('    Divergence after',i9,
     &       ' matrix-vector multiplications')
C**                                                                 ***
C**---END OF LL1P20-------------------------------------------------***
C**                                                                 ***
      e    n    d
