C:::::      ,,,,,LL3A2X.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL3A2X(mat,x1,x2,b1,b2,buf,ptrmbk,lmatbk,ptrinf,
     #                  l,nproc,tid,myproc,jump,
     #                  ladd,lmat,lindex,ia1,info,index,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 3 A 2 X   computes two matrix-vector-multiplications   ***
C**                    with matrix mat and mat_trans                ***
C**                    on a distributed memory system:              ***
C**                    b1 = b1_0 + mat * x1 ,                       ***
C**                    b2 = b2_0 + mat * x2 ,                       ***
C**                    If ladd = .false.  :  b1_0 = 0, b2_0 = 0 .   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER :     H. Haefner                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lindex,ia1,nproc,l,nmsg,myproc
      integer           info(ia1,ia2),index(lindex)
      integer           tid(nproc),jump(nproc),ptrinf(ntyp+1,nproc)
      integer           ptrmbk(nproc+1),lmatbk(nproc)
      double precision  b1(l),b2(l),x1(l),x2(l),buf(5*l),mat(lmat)
      logical           ladd


C**                                                                 ***
      include 'bytes.h'
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i,ierr,count,pbuf,pbufs,pbufr,sum
      integer           to,from,nrblk,mids,midr,njump
      integer           swap,lnbpid,rnbpid,ptsmyb
      integer           LL9MAP
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
      pbufs = 1
      pbufr = 2*l+1
      pbuf  = 4*l+1
      nrblk = myproc
      ptsmyb = ptrmbk(myproc)
C**                                                                 ***
      if (.not. ladd) then
	do 20 i = 1,l
	  b1(i) = zero
	  b2(i) = zero
   20   continue
      endif
C**                                                                 ***
C**   COPY INPUT- AND OUTPUT-VECTOR IN SEND BUFFER                  ***
C**                                                                 ***
      do 30 i = 1,l
        buf(pbufs+i-1) = x1(i)
        buf(pbufs+l+i-1) = zero
   30 continue
C**                                                                 ***
      sum = 0 
      njump = 0
   50 njump = njump+1
      sum = sum+jump(njump)
      if (sum .lt. nproc) goto 50
C**                                                                 ***
C**   COMPUTE njump MATRIX BLOCKS WITH RECEIVING AND SENDING OF     ***
C**   VECTOR PARTS OF B                                             ***
C**                                                                 ***
      do 100 count=1,njump
	if (nproc .gt. 1) then
          lnbpid = LL9MAP(myproc-jump(count),nproc)
	  from = tid(lnbpid)
	  call MPRCVA(from,nmsg+count,2*l*ireal,buf(pbufr),
     #                midr,ierr)
        endif
C**                                                                 ***
C**   SEND ASYNCHRONOUSLY OUTPUT VECTOR                             ***
C**                                                                 ***
        if (nproc .gt. 1) then
          rnbpid = LL9MAP(myproc+jump(count),nproc)
	  to = tid(rnbpid)
	  call MPSNDA(to,nmsg+count,2*l*ireal,buf(pbufs),mids,ierr)
	endif
C**                                                                 ***
C**   PERFORM SYMMETRIC MULTIPLICATION FOR MAIN DIAGONAL BLOCK      ***
C**   PERFORM NON-TRANSP.-PART-MULTIPLICATION FOR OTHER BLOCKS      ***
C**                                                                 ***
        if (count .eq. 1) then
          call LL6A2X(mat,x1,x2,b1,b2,ptsmyb,l,ptrmbk(nrblk),lmat,
     &                lindex,ia1,info,index,nrblk,ptrinf,nproc)
        else
          call LL6AX(mat,buf(pbufs),b1,ptsmyb,l,ptrmbk(nrblk),lmat,
     &               lindex,ia1,info,index,nrblk,ptrinf,nproc)
        endif

C**                                                                 ***
C**   PERFORM TRANSP.-PART-MULTIPLICATION FOR OTHER BLOCKS          ***
C**                                                                 ***
        if (nproc .gt. 1) then
          if (count .lt. njump) then
            nrblk = nrblk-jump(count)
            if (nrblk .le. 0) nrblk = nrblk+nproc
            do 110 i = pbuf,pbuf+l-1
              buf(i) = zero
  110       continue
C**                                                                 ***
            call LL6ATX(mat,x2,buf(pbuf),ptsmyb,l,ptrmbk(nrblk),lmat,
     &                  lindex,ia1,info,index,nrblk,ptrinf,nproc)
          endif
C**                                                                 ***
C**   WAIT RECEIVE                                                  ***
C**                                                                 ***
	  call MPRCVW(from,nmsg+count,2*l*ireal,buf(pbufr),
     #                midr,ierr)
C**                                                                 ***
C**   COMPUTE NEW PART OF VECTOR B IN RECEIVE BUFFER                ***
C**                                                                 ***
          if (count .lt. njump) then
            do 120 i = 0,lmatbk(nrblk)-1
              buf(pbufr+l+i) = buf(pbufr+l+i)+buf(pbuf+i)
  120       continue
          endif
C**                                                                 ***
C**   WAIT SEND                                                     ***
C**                                                                 ***
          call MPSNDW(to,nmsg+count,2*l*ireal,buf(pbufs),mids,ierr)
C**                                                                 ***
C**   SWAP RECEIVE AND SEND BUFFER                                  ***
C**                                                                 ***
          swap = pbufs
	  pbufs = pbufr
	  pbufr = swap
        endif

  100 continue
	  
      nmsg = nmsg + count

      if (nproc .gt. 1) then
        do 200 i= 1,lmatbk(myproc)
	  b2(i) = b2(i)+buf(pbufs+l+i-1)
  200   continue
      endif
C**                                                                 ***
      r e t u r n
C-----END OF LL3A2X----------------------------------------------------
      e    n    d
