C:::::      ,,,,,LL3ATX.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL3ATX(ROUTIN,mat,x,b,buf,ptrmbk,lmatbk,ptrinf,
     #                  l,nproc,tid,myproc,jump,
     #                  ladd,lmat,lindex,ia1,info,index,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 3 A T X   computes one matrix-vector-multiplication    ***
C**                    with transposed matrix:                      ***
C**                    b = b0 + mat^t * x .                         ***
C**                    on a multiprocessor system.                  ***
C**                    if ladd = .false.  :  b0 = 0 .               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER :     H. Haefner                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lindex,ia1,nproc,l,nmsg,myproc
      integer           info(ia1,ia2),index(lindex)
      integer           tid(nproc),jump(nproc),ptrinf(ntyp+1,nproc)
      integer           ptrmbk(nproc+1),lmatbk(nproc)
      double precision  b(l), x(l), buf(3*l), mat(lmat)
      logical           ladd
      external          ROUTIN


C**                                                                 ***
      include 'bytes.h'
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i,ierr,count,pbuf,pbufs,pbufr,sum
      integer           to,from,nrblk,mids,midr,njump
      integer           swap,lnbpid,rnbpid,ptsmyb
      integer           LL9MAP
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
      pbufs = 1
      pbufr = l+1
      pbuf  = 2*l+1
      nrblk = myproc
C**                                                                 ***
      if (.not. ladd) then
	do 20 i = 1,l
	  b(i) = zero
   20   continue
      endif
C**                                                                 ***
C**   COPY OUTPUT VECTOR IN SEND BUFFER, IF nproc <> 1              ***
C**   COPY OUTPUT VECTOR IN RECEIVE BUFFER, IF nproc = 1            ***
C**                                                                 ***
      if (nproc .gt. 1) then
        do 30 i = 1,l
	  buf(pbufs+i-1) = b(i)
   30   continue
      else
        do 40 i = 1,l
	  buf(pbufr+i-1) = b(i)
   40   continue
      endif
C**                                                                 ***
      sum = 0 
      njump = 0
   50 njump = njump+1
      sum = sum+jump(njump)
      if (sum .lt. nproc) goto 50
C**                                                                 ***
C**   COMPUTE njump MATRIX BLOCKS WITH RECEIVING AND SENDING OF     ***
C**   VECTOR PARTS OF B                                             ***
C**                                                                 ***
      do 100 count=1,njump
	if (nproc .gt. 1) then
          lnbpid = LL9MAP(myproc-jump(count),nproc)
	  from = tid(lnbpid)
	  call MPRCVA(from,nmsg+count,l*ireal,buf(pbufr),
     #                midr,ierr)
        endif
C**                                                                 ***
C**   SEND ASYNCHRONOUSLY OUTPUT VECTOR                             ***
C**                                                                 ***
        if (nproc .gt. 1) then
          rnbpid = LL9MAP(myproc+jump(count),nproc)
	  to = tid(rnbpid)
	  call MPSNDA(to,nmsg+count,l*ireal,buf(pbufs),mids,ierr)
	endif
C**                                                                 ***
        do 110 i = pbuf,pbuf+l-1
          buf(i) = zero
  110   continue
C**                                                                 ***
        ptsmyb = ptrmbk(myproc)
	nrblk = nrblk-jump(count)
        if (nrblk .le. 0) nrblk = nrblk+nproc
        call ROUTIN(mat,x,buf(pbuf),ptsmyb,l,ptrmbk(nrblk),lmat,
     &              lindex,ia1,info,index,nrblk,ptrinf,nproc)
C**                                                                 ***
C**   WAIT RECEIVE                                                  ***
C**                                                                 ***
        if (nproc .gt. 1) then
	  call MPRCVW(from,nmsg+count,l*ireal,buf(pbufr),
     #                midr,ierr)
        endif
C**                                                                 ***
C**   COMPUTE NEW PART OF VECTOR B IN RECEIVE BUFFER                ***
C**                                                                 ***
        do 120 i = 0,l-1
          buf(pbufr+i) = buf(pbufr+i)+buf(pbuf+i)
  120   continue
C**                                                                 ***
C**   WAIT SEND                                                     ***
C**                                                                 ***
        if (nproc .gt. 1) then
          call MPSNDW(to,nmsg+count,l*ireal,buf(pbufs),mids,ierr)
        endif
C**                                                                 ***
C**   SWAP RECEIVE AND SEND BUFFER                                  ***
C**                                                                 ***
        swap = pbufs
	pbufs = pbufr
	pbufr = swap

  100 continue
	  
      nmsg = nmsg + count

      do 200 i= 1,l
	b(i) = buf(pbufs+i-1)
  200 continue
C**                                                                 ***
      r e t u r n
C-----END OF LL3ATX----------------------------------------------------
      e    n    d
