C:::::      ,,,,,LL3AX.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL3AX(ROUTIN,mat,x,b,buf,ptrmbk,lmatbk,ptrinf,
     #                 l,nproc,tid,myproc,jump,
     #                 ladd,lmat,lindex,ia1,info,index,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 3 A X     computes one matrix-vector-multiplication    ***
C**                    b = b0 + MAT * x                             ***
C**                    on a multiprocessor system.                  ***
C**                    if ladd = .false.  :  b0 = 0 .               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER :     H. Haefner                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lindex,ia1,nproc,l,nmsg
      integer           info(ia1,ia2),index(lindex)
      integer           tid(nproc),myproc,jump(nproc),ptrmbk(nproc+1),
     *                  lmatbk(nproc),ptrinf(ntyp+1,nproc)
      double precision  b(l), x(l), buf(2*l), mat(lmat)
      logical           ladd
      external          ROUTIN


C**                                                                 ***
      include 'bytes.h'
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i,ierr,count,pbuf,pbufs,pbufr,sum
      integer           to,from,nrblk,mids,midr,njump
      integer           swap,lnbpid,rnbpid,ptsmyb
      integer           LL9MAP
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
      pbufs = 1
      pbufr = l+1
      nrblk = myproc
C**                                                                 ***
      if (.not. ladd) then
	do 20 i = 1,l
	  b(i) = zero
   20   continue
      endif
C**                                                                 ***
C**   COPY INPUT VECTOR IN SEND BUFFER                              ***
C**                                                                 ***
      do 30 i = 1,l
        buf(pbufs+i-1) = x(i)
   30 continue
C**                                                                 ***
      sum = 0 
      njump = 0
   50 njump = njump+1
      sum = sum+jump(njump)
      if (sum .lt. nproc) goto 50
C**                                                                 ***
C**   COMPUTE njump MATRIX BLOCKS WITH RECEIVING AND SENDING OF     ***
C**   VECTOR PARTS OF X                                             ***
C**                                                                 ***
      do 100 count=1,njump
	if (nproc .gt. 1) then
          lnbpid = LL9MAP(myproc-jump(count),nproc)
	  from = tid(lnbpid)
	  call MPRCVA(from,nmsg+count,l*ireal,buf(pbufr),
     #                midr,ierr)
        endif
C**                                                                 ***
C**   SEND ASYNCHRONOUSLY OUTPUT VECTOR                             ***
C**                                                                 ***
        if (nproc .gt. 1) then
          rnbpid = LL9MAP(myproc+jump(count),nproc)
	  to = tid(rnbpid)
	  call MPSNDA(to,nmsg+count,l*ireal,buf(pbufs),mids,ierr)
	endif
C**                                                                 ***
        ptsmyb = ptrmbk(myproc)
        call ROUTIN(mat,buf(pbufs),b,ptsmyb,l,ptrmbk(nrblk),
     *              lmat,lindex,ia1,info,index,
     *              nrblk,ptrinf,nproc)
	nrblk = nrblk-jump(count)
        if (nrblk .le. 0) nrblk = nrblk+nproc
C**                                                                 ***
C**   WAIT SEND                                                     ***
C**                                                                 ***
        if (nproc .gt. 1) then
          call MPSNDW(to,nmsg+count,l*ireal,buf(pbufs),mids,ierr)
        endif
C**                                                                 ***
C**   WAIT RECEIVE                                                  ***
C**                                                                 ***
        if (nproc .gt. 1) then
	  call MPRCVW(from,nmsg+count,l*ireal,buf(pbufr),midr,ierr)
        endif
C**                                                                 ***
C**   SWAP RECEIVE AND SEND BUFFER                                  ***
C**                                                                 ***
        swap = pbufs
	pbufs = pbufr
	pbufr = swap

  100 continue
	  
      nmsg = nmsg + count
C**                                                                 ***
      r e t u r n
C-----END OF LL3AX----------------------------------------------------
      e    n    d
