C:::::      ,,,,,LL3AXB.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL3AXB(rs,r,xs,x,b,prec,work,l,lprec,lmyblk,epslin,
     &                  ptrmbk,lmatbk,ptrinf,jump,mat,lmat,index,
     &                  lindex,info,ia1,lsym,ladd,
     &                  method,lstart,myproc,nproc,tid,nmsg,ilin,ierr,
     &                  count,imvm,branch)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 3 A X B   computes the norm of the residual and        ***
C**      performs the check, if the stopping criterion is fulfilled.***
C**      If (lcond1 .and. lcond2) then the iteration is stopped.    ***
C**      If (lcond1 .and. .not. lcond2) then a new stopping         ***
C**      criterion is computed.                                     ***
C**      lcond1 = (||rs||2 <= epsrel * ||Nb||2)                     ***
C**      noprec=1:                                                  ***
C**      lcond2 = (||N-1*rs||max <= epslin * ||b||max)              ***
C**      noprec=0:                                                  ***
C**      lcond2 = (||rs||max <= epslin * ||Nb||max)                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1996                     ***
C**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -------------------                                        ***
C**                                                                 ***
      include            'const.h'
      integer            ia1,ierr,l,lmat,lindex,lprec,lmyblk,myproc,
     #                   nproc,nmsg,count,imvm,branch 
      integer            tid(nproc),ilin(nilin)
      double precision   prec(lprec),rs(l),r(l),xs(l),x(l),b(l),
     #                   work(5*l),epslin
      character*10       method
      integer            ptrmbk(nproc+1),lmatbk(nproc),jump(nproc),
     #                   ptrinf(ntyp+1,nproc),info(ia1,ia2),
     #                   index(lindex)
      double precision   mat(lmat)
      logical            ladd,lstart,lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   ---------------------------                                   ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C rs     I  R   I IN  I  Smoothed residual           array: rs(l)
C--------I------I-----I------------------------------------------------
C r      I  R   I IN  I  Residual                    array: r(l)
C--------I------I-----I------------------------------------------------
C xs     I  R   I IN  I  Smoothed solution           array: xs(l)
C--------I------I-----I------------------------------------------------
C x      I  R   I IN  I  Solution                    array: x(l)
C--------I------I-----I------------------------------------------------
C work   I  R   I  -  I  Workarray                   array: work(5*l)
C--------I------I-----I------------------------------------------------
C imvm   I  I   I IN  I  Number of performed matrix-vector-
C        I      I     I  multiplications
C--------I------I-----I------------------------------------------------
C count  I  I   I IN  I  Number of performed iteration steps
C--------I------I-----I------------------------------------------------
C branch I  I   I OUT I  Branch variable for arithmetic goto
C--------I------I-----I------------------------------------------------
C lstart I  L   I IN  I  must be true, if this routine is called
C        I      I     I  before the iteration process.
C--------I------I-----I------------------------------------------------
C method I  S   I IN  I  The name of the routine, which calls this
C        I      I     I  routine.
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**    All other parameters: see Manual Pages <linsol>              ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i,ione,lout,ibborg,ibplbg,ibNb
      double precision  r0eucl,rseucl,rseucn,rseuco,rsmax,beucl,bmax
      double precision  epsrel,rnorm,esnorm,enorm,rpoly
      double precision  zero,help,noprec,idoku1
      logical           lsym2

      common /norms/ rseucn,rpoly(3),lsym2
C**                                                                 ***
C**                                                                 ***
C**   LIST OF LOCAL PARAMETERS :                                    ***
C**   ---------------------------                                   ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C rseucl I  R   I sav I  Euclidian norm of the smoothed residual 
C--------I------I-----I------------------------------------------------
C rsmax  I  R   I sav I  Maximum norm of the smoothed residual     
C--------I------I-----I------------------------------------------------
C beucl  I  R   I sav I  Euclidian norm of the right hand side
C--------I------I-----I------------------------------------------------
C bmax   I  R   I sav I  Maximum norm of the right hand side
C--------I------I-----I------------------------------------------------
C epsrel I  R   I sav I  Stopping factor:
C        I      I     I  lstart=.true. --> epsrel = epslin
C        I      I     I  lstart=.false. --> 
C        I      I     I  epsrel = 0.7*(rseucl/beucl)*(epslin*bmax/rsmax)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter  (zero = 0., ione = 1)
C**                                                                 ***
      external   LL6AX
C**                                                                 ***
C**                                                                 ***
      save epsrel,rseucl,rsmax,beucl,bmax,idoku1
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      branch = 0
      noprec = ilin(9)
      lout   = ilin(12)

      ibborg = 1 + 2*l
      ibplbg = 1 + 3*l
      ibNb   = 1 + 4*l

C** 
C**** COMPUTATION OF ||r0|| (r0eucl)
C**   
      if (lstart) then
	idoku1 = abs(ilin(13))
	epsrel = epslin

C**** NORMALIZED SYSTEM IS CONSIDERED
	if (noprec .eq. 0) then
	  call LL4SCP(lmyblk,ione,l,ione,rs,1,rs,1,r0eucl,help,.true.,
     #                myproc,nproc,tid,nmsg)
C**** ||PL*N*b||2
	  r0eucl = sqrt(r0eucl)
	  call LL4SCP(lmyblk,ione,l,ione,prec,ibplbg,prec,ibplbg,beucl,
     #                help,.true.,myproc,nproc,tid,nmsg)
C**** ||PL*N*borg||2
	  beucl = sqrt(beucl)
C**** ||PL*N*borg||max
          call LL4RNM(lmyblk,ione,l,prec(ibplbg),bmax,help,
     #                myproc,nproc,tid,nmsg)
          if (mod(ilin(19),100000) .ge. 10000) then
            call LL8NME(work,xs,x,r,esnorm,enorm,rnorm,l,lmyblk,
     #                  nproc,myproc,tid,nmsg)
          endif
        endif

C**** ORIGINAL SYSTEM IS CONSIDERED
	if (noprec .eq. 1) then
	  do 100 i=1,lmyblk
	    work(i) = prec(ibNb+i-1)/prec(i)
  100     continue
	  call LL4SCP(lmyblk,ione,l,ione,work,1,work,1,r0eucl,
     #                help,.true.,myproc,nproc,tid,nmsg)
C**** ||N*b||2
	  r0eucl = sqrt(r0eucl)
	  call LL4SCP(lmyblk,ione,l,ione,prec,ibborg,prec,ibborg,beucl,
     #                help,.true.,myproc,nproc,tid,nmsg)
C**** ||borg||2
	  beucl = sqrt(beucl)
C**** ||borg||max
          call LL4RNM(lmyblk,ione,l,prec(ibborg),bmax,help,
     #                myproc,nproc,tid,nmsg)
          if (mod(ilin(19),100000) .ge. 10000) then
            call LL8NME(work,xs,x,prec(ibNb),esnorm,enorm,rnorm,l,
     #                  lmyblk,nproc,myproc,tid,nmsg)
          endif
        endif

        if (ilin(13) .le. -2) then
          if (mod(ilin(19),100000) .ge. 10000) then
            write(lout,1211) r0eucl,rnorm,esnorm,enorm,
     #                       epsrel*beucl,method
          else
	    write(lout,1111) r0eucl,method,epsrel*beucl
          endif
        elseif ((ilin(13) .ge. 2) .and. (myproc .eq. 1)) then
          if (mod(ilin(19),100000) .ge. 10000) then
            write(lout,1211) r0eucl,rnorm,esnorm,enorm,
     #                       epsrel*beucl,method
          else
            write(lout,1111) r0eucl,method,epsrel*beucl
          endif
        endif
        if (r0eucl .eq. zero) then
          if (ilin(13) .lt. 0) write(lout,1000)
          if (ilin(13) .gt. 0) then
            if (myproc .eq. 1) write(lout,1000)
          endif
	  branch = 1
	  goto 999
        endif
	rseucl = r0eucl
C***  SET ONLY FOR BICO
	rseucn = rseucl

C** 
C**** COMPUTATION OF ||rk_smoothed|| (rseucl)
C**   
      else
	rseuco = rseucl

C**** NORMALIZED SYSTEM IS CONSIDERED
        call LL4SCP(lmyblk,ione,l,ione,rs,1,rs,1,rseucl,help,.true.,
     #              myproc,nproc,tid,nmsg)
C**** ||PL*N*rs||2
	rseucl = sqrt(rseucl)
        if (mod(ilin(19),100000) .ge. 10000) then
	  if (noprec .eq. 0) then
            call LL8NME(work,xs,x,r,esnorm,enorm,rnorm,l,lmyblk,
     #                  nproc,myproc,tid,nmsg)
	  else
            if ((ilin(1) .eq. 9).or.lsym .or.(ilin(15) .gt. 10)) then
C****   work(1..l)  = |N(-1)*(|N*A*|N*y - |N*b)
              do 114 i=1,lmyblk
	        work(l+i) = prec(i)*x(i)
  114         continue
	    else
C****   work(1..l)  =  N(-1)*(N*A*x - N*b)
              do 115 i=1,lmyblk
	        work(l+i) = x(i)
  115         continue
	    endif
            call LL3AX(LL6AX,mat,work(l+1),work(2*l+1),work(3*l+1),
     #                 ptrmbk,lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #                 ladd,lmat,lindex,ia1,info,index,nmsg)
            imvm=imvm+1
            do 116 i=1,lmyblk
              work(l+i) = (work(2*l+i)-prec(ibNb+i-1))/prec(i)
  116       continue
            call LL8NME(work,xs,x,work(l+1),esnorm,enorm,rnorm,l,
     #                  lmyblk,nproc,myproc,tid,nmsg)
          endif
        endif
        if (myproc .eq. 1) CALL POLYN(rseucl)

        if (count .ge. idoku1) then
          if (ilin(13) .le. -2) then
            if (mod(ilin(19),100000) .ge. 10000) then
              write(lout,1201) count,imvm,rseucl,rnorm,esnorm,enorm
            else
	      write(lout,1200) count,imvm,rseucl
            endif
          elseif ((ilin(13) .ge. 2) .and. (myproc .eq. 1)) then
            if (mod(ilin(19),100000) .ge. 10000) then
              write(lout,1201) count,imvm,rseucl,rnorm,esnorm,enorm
            else
	      write(lout,1200) count,imvm,rseucl
            endif
          endif
        endif
        if (rseucl .gt. rseuco .and. ilin(1) .ne. 6) then
	  ierr = 3201
	  branch = 3
	  goto 999
        endif

        if (rseucl .le. epsrel*beucl) then
          if (count .lt. idoku1) then
            if (ilin(13) .le. -2) then
              if (mod(ilin(19),100000) .ge. 10000) then
                write(lout,1201) count,imvm,rseucl,rnorm,esnorm,enorm
              else
	        write(lout,1200) count,imvm,rseucl
              endif
            elseif ((ilin(13) .ge. 2) .and. (myproc .eq. 1)) then
              if (mod(ilin(19),100000) .ge. 10000) then
                write(lout,1201) count,imvm,rseucl,rnorm,esnorm,enorm
              else
	        write(lout,1200) count,imvm,rseucl
              endif
            endif
          endif
C**** NORMALIZED SYSTEM IS CONSIDERED
	  if (noprec .eq. 0) then
	    do 140 i = 1,lmyblk
	      work(i) = rs(i)
  140       continue
          else
           if ((ilin(1) .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
C****   work(1..l)  = |N(-1)*(|N*A*|N*ys - |N*b)
            do 111 i=1,lmyblk
	      work(i) = prec(i)*xs(i)
  111       continue
	   else
C****   work(1..l)  =  N(-1)*(N*A*xs - N*b)
            do 112 i=1,lmyblk
	      work(i) = xs(i)
  112       continue
	   endif
           call LL3AX(LL6AX,mat,work,work(l+1),work(2*l+1),ptrmbk,
     #                lmatbk,ptrinf,l,nproc,tid,myproc,jump,ladd,
     #                lmat,lindex,ia1,info,index,nmsg)
           imvm=imvm+1
           do 113 i=1,lmyblk
             work(i) = (work(l+i)-prec(ibNb+i-1))/prec(i)
  113      continue
	  endif
          call LL4RNM(lmyblk,ione,l,work,rsmax,help,
     #                myproc,nproc,tid,nmsg)
          if (rsmax .le. epslin*bmax) then
	    if (ilin(13) .lt. 0) write(lout,1400) rsmax,epslin*bmax
	    if (ilin(13) .gt. 0) then
	      if (myproc .eq. 1) write(lout,1400) rsmax,epslin*bmax
            endif
	    branch = 1
          else
            epsrel = 0.7 * rseucl * bmax * epslin /(beucl * rsmax)
	    if (ilin(13) .lt. 0) write(lout,1300) rsmax, epslin*bmax,
     #                                            epsrel*beucl
	    if (ilin(13) .gt. 0) then
	      if (myproc .eq. 1) write(lout,1300) rsmax, epslin*bmax,
     #                                            epsrel*beucl
            endif
          endif
        endif
        if (count .ge. idoku1) then
	  idoku1 = count + abs(ilin(13))
        endif
	if (imvm .ge. ilin(2)) branch = 2

C***  SET ONLY FOR BICO
	rseucn = rseucl
      endif
C**                                                                 ***
C**                                                                 ***
C**** END OF CALCULATION                                            ***
C**   ------------------                                            ***
C**                                                                 ***
  999 r e t u r n
 1000 format('    Starting defect is zero; initial guess is the solutio
     &n'/' ')
 1111 format('    Starting defect   (L2-Norm) :',g12.4,a10/
     &       '    Stopping criterion     (L2) :',g12.4,'   Method ')
 1211 format('        ||s||:',e8.2,'  ||r||:',e8.2,'  ||es||:',e8.2,
     &       '  ||e||:',e8.2/'    Stopping criterion (L2) :',g12.4,
     &        a10,'Method')
 1200 format('    Step:',i6,'   MVMs:',i6,'   Defect:',g12.4)
 1201 format('    Step:',i6,'   MVMs:',i6/
     &       '        ||s||:',e8.2,'  ||r||:',e8.2,'  ||es||:',e8.2,
     &       '  ||e||:',e8.2)
 1300 format('    Maximum of defect:',g10.4,' >',g10.4,
     & ' (epslin*||b||max)'/'    New stopping criterion (L2) :',g12.4)
 1400 format('    Maximum of defect:',g10.4,' <',g10.4,
     & ' (epslin*||b||max)'/'    LINSOL iteration complete.')
C**                                                                 ***
C-----END OF LL3AXB----------------------------------------------------
      e    n    d
