C:::::      ,,,,,LL4INM.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL4INM(nc,n,l,iv,maxnrm,iwork,
     #                  myproc,nproc,tids,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 4 I N M   computes the maximum norm of n vectors       ***
C**                    of length nc, which are stored in the        ***
C**                    vector field iv.                             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      integer   nc,n,l,myproc,nproc,nmsg 
      integer   tids(nproc)
      integer   iv(l,n),maxnrm(n),iwork(n)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C nc     I  I   I in  I  number of components of the vectors in iv
C--------I------I-----I------------------------------------------------
C n      I  I   I in  I  number of vectors in vector field iv
C--------I------I-----I------------------------------------------------
C l      I  I   I in  I  dimension of one vector in iv
C--------I------I-----I------------------------------------------------
C iv     I  I   I in  I  vector set                   array : iv(l,n)
C--------I------I-----I------------------------------------------------
C iwork  I  I   I  -  I  integer work array           array : iwork(n)
C--------I------I-----I------------------------------------------------
C maxnrm I  I   I out I  maximum norms                array : maxnrm(n)
C--------I------I-----I------------------------------------------------
C nproc  I  I   I in  I  number of processors (processes)
C--------I------I-----I------------------------------------------------
C myproc I  I   I in  I  logical process(or) number
C--------I------I-----I------------------------------------------------
C tids   I  I   I in  I  (see Manual pages <linsol>)
C--------I------I-----I------------------------------------------------
C nmsg   I  I   I in  I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      include "bytes.h"
      integer           i,il,lstr
      external          LL9INM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      do 10 i=1,n
        maxnrm(i) = iv(1,i)
          do 10 il=2,nc
            maxnrm(i) = max(maxnrm(i),iv(il,i))
   10 continue
C**                                                                 ***
C**   REDUCTION AND BROADCASTING OF MAXIMAL VALUES                  ***
C**                                                                 ***
      if (nproc .ne. 1) then
        lstr = n*iint
        call LL4RED(LL9INM,iwork,maxnrm,lstr,myproc,nproc,tids,nmsg)
      endif
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL4INM---------------------------------------------------
      e    n    d
