C:::::      ,,,,,LL4JMP.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL4JMP(jump,ptrinf,iw,liw,lsym,myproc,nproc,tid,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 4 J M P   sets the jump vector for a distributed       ***
C**                    matrix.                                      ***
C**                                                                 ***
C**      (liw must be 2*nproc)                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER :     H. Haefner                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'maxnpe.h'
      include           'const.h'
      integer           liw,myproc,nproc,nmsg
      integer           ptrinf(ntyp+1,nproc),tid(nproc),jump(maxnpe)
      integer           iw(liw)
      logical           lsym
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           iwork,ione,njump,s
      integer           i,j
C**                                                                 ***
      iwork = nproc+1
      ione  = 1
C**                                                                 ***
      do 100 i = 1,nproc
	iw(i) = 0
	j = myproc+i-1
	if (j .gt. nproc) j = j-nproc
	if (ptrinf(1,j) .lt. ptrinf(ntyp+1,j)) iw(i) = 1
  100 continue
C**                                                                 ***
      call LL4INM(ione,nproc,ione,iw(1),jump,iw(iwork),myproc,
     &            nproc,tid,nmsg)
C**                                                                 ***
      if (lsym) then
	j = 0
	do 110 i=2,(nproc+1)/2
	  jump(i) = max(jump(i),jump(nproc-j))
	  jump(nproc-j) = jump(i)
	  j = j+1
  110   continue
      endif

      s=1
      njump=1
      include "norec.h"
      do 202 i=2,nproc
        if (jump(i) .eq. 1) then
	  njump=njump+1
	  jump(njump-1)=s
          s=1
        else
          s=s+1
        endif
  202 continue

      jump(njump)=s

      do 203 i=njump+1,maxnpe
        jump(i)=0
  203 continue

C**                                                                 ***

      R E T U R N
C-----END OF LL4JMP----------------------------------------------------
      E    N    D
