C:::::      ,,,,,LL4RED.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL4RED(ROUTIN,swork,string,lstr,myproc,
     #                  nproc,tids,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 4 R E D   performs the reduce operation on the         ***
C**                    routine <ROUTIN> and broadcasts the          ***
C**                    computed values to all processes             ***
C**                    (processors).                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      integer            lstr,myproc,nproc,nmsg 
      integer            tids(nproc)
C**                                                                 ***
      character*1        swork(lstr),string(lstr)                
      external           ROUTIN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ROUTIN I  C   I in  I  name of the routine to be called            
C--------I------I-----I------------------------------------------------
C swork  I  C   I in  I  string vector for routine <ROUTIN>          
C--------I------I-----I------------------------------------------------
C string I  C   I i/o I  string vector for routine <ROUTIN>          
C--------I------I-----I------------------------------------------------
C lstr   I  I   I in  I  length of the above mentioned vectors in Bytes 
C--------I------I-----I------------------------------------------------
C myproc I  I   I in  I  process(or) id
C--------I------I-----I------------------------------------------------
C nproc  I  I   I in  I  number of processes (processors)
C--------I------I-----I------------------------------------------------
C tids   I  I   I in  I  set of tids                array : tids(nproc)
C--------I------I-----I------------------------------------------------
C nmsg   I  I   I i/o I  number of calls of communication routines
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           j,a,b,totid,info,msgtp,frpid,mids,midr,frtid,
     &                  topid
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      msgtp=0
      a=1
      b=0
   20 continue
      if (a .lt. nproc) then
        msgtp=msgtp+1
	j=(myproc-b)/(2*a)
	if (a*2*j+b .eq. myproc) then
	  totid=tids(a*(2*j-1)+b)
	  call MPSNDA(totid,nmsg+msgtp,lstr,string,mids,info)
	  call MPSNDW(totid,nmsg+msgtp,lstr,string,mids,info)
        endif
	j=(myproc-b+a)/(2*a)
	if (a*(2*j-1)+b .eq. myproc) then
	  frpid=a*2*j+b
	  if (frpid .le. nproc) then
	    call MPRCVA(tids(frpid),nmsg+msgtp,lstr,swork,midr,
     #                  info)
	    call MPRCVW(tids(frpid),nmsg+msgtp,lstr,swork,midr,
     #                  info)
	    call ROUTIN(swork,string,lstr)
          endif
	endif
	b=b-a
	a=2*a
        goto 20
      endif
 
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   THE COMPUTED VALUES ARE BROADCASTED WITH CASCADE              ***
C**   -----------------------------------------------               ***
C**                                                                 ***
      a=a/2
      b=b+a
  120 continue
      if (a .gt. 0) then
        msgtp=msgtp+1
	j=(myproc-b)/(2*a)
	if (a*2*j+b .eq. myproc) then
	  frtid=tids(a*(2*j-1)+b)
	  call MPRCVA(frtid,nmsg+msgtp,lstr,string,midr,info)
	  call MPRCVW(frtid,nmsg+msgtp,lstr,string,midr,info)
        endif
	j=(myproc-b+a)/(2*a)
	if (a*(2*j-1)+b .eq. myproc) then
	  topid=a*2*j+b
	  if (topid .le. nproc) then
	    call MPSNDA(tids(topid),nmsg+msgtp,lstr,string,mids,
     #                  info)
	    call MPSNDW(tids(topid),nmsg+msgtp,lstr,string,mids,
     #                  info)
	  endif
	endif
	a=a/2
	b=b+a
        goto 120
      endif
C
      nmsg = nmsg+msgtp
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL4RED---------------------------------------------------
      e    n    d
