C:::::      ,,,,,LL4SCP.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL4SCP(nc,n,l,m,v,ptrv,w,ptrw,scp,rwork,spur,
     #                  myproc,nproc,tids,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 4 S C P   computes the scalar products of the          ***
C**                    transposed (lxn)-matrix v with the           ***
C**                    (lxm)-matrix w; if (spur) then only          ***
C**                    the spur of the (nxm)-matrix scp is          ***
C**                    computed.                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      integer            nc,n,l,m,myproc,nproc,nmsg 
      integer            ptrv(n),ptrw(m),tids(nproc)
      logical            spur
C**                                                                 ***
      double precision   v(*),w(*),scp(n*m),rwork(n*m)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C nc     I  I   I in  I  number of components of v and w
C--------I------I-----I------------------------------------------------
C n      I  I   I in  I  number of vectors in v
C--------I------I-----I------------------------------------------------
C l      I  I   I in  I  leading dimension of v and w
C--------I------I-----I------------------------------------------------
C m      I  I   I in  I  number of vectors in w
C--------I------I-----I------------------------------------------------
C v      I  R   I in  I  vector set                    array : v(l*n)
C--------I------I-----I------------------------------------------------
C ptrv   I  I   I in  I  pointers on a vector field >= vector set v   
C        I      I     I  pointers should be a multiple of l + offset 1
C        I      I     I                                array : ptrv(n)
C--------I------I-----I------------------------------------------------
C w      I  R   I in  I  vector set                    array : v(l*m)
C--------I------I-----I------------------------------------------------
C ptrw   I  I   I in  I  pointers on a vector field >= vector set w   
C        I      I     I  pointers should be a multiple of l + offset 1
C        I      I     I                                array : ptrw(n)
C--------I------I-----I------------------------------------------------
C scp    I  R   I out I  matrix with scalar products   array : scp(n*m)
C        I      I     I  if (spur) then the used array has size scp(n)
C--------I------I-----I------------------------------------------------
C spur   I  L   I in  I  is .true.: all vectors of v are multiplied     
C        I      I     I             with all vectors of w
C        I      I     I    .false.: the i-th vector of v is multiplied     
C        I      I     I             with the i-th vector of w (i=1..n)
C--------I------I-----I------------------------------------------------
C rwork  I  R   I  -  I  real work array           array : rwork(n*m)
C--------I------I-----I------------------------------------------------
C myproc I  I   I in  I  process(or) id
C--------I------I-----I------------------------------------------------
C tids   I  I   I in  I  set of tids               array : tids(nproc)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      include "bytes.h"
      integer           i,j,il,lstr
      external          LL9SCP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      if (spur) then
        do 10 i=1,n
          scp(i) = 0.d0
            do 10 il=0,nc-1
              scp(i)=scp(i)+v(ptrv(i)+il)*w(ptrw(i)+il)
   10   continue
      else
        do 20 j=1,m
          do 20 i=1,n
	    scp((j-1)*n+i) = 0.d0
              do 20 il=0,nc-1
                scp((j-1)*n+i)=scp((j-1)*n+i)
     #                         +v(ptrv(i)+il)*w(ptrw(j)+il)
   20   continue
      endif
C**                                                                 ***
C**   REDUCTION AND BROADCASTING OF SCALAR PRODUCT                  ***
C**                                                                 ***
      if (nproc .ne. 1) then
        if (spur) then
          lstr = n*ireal
        else
          lstr = n*m*ireal
        endif
        call LL4RED(LL9SCP,rwork,scp,lstr,myproc,nproc,tids,nmsg)
      endif
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL4SCP---------------------------------------------------
      e    n    d
