C:::::      ,,,,,LL5AP.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL5AP(mat,prec,dummy,ptsmyb,l,ptsmbk,lmat,
     #              lindex,ia1,info,index,nrblk,ptrinf,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 5 A P     is the kernel routine for the multiplication *** 
C**                    of matrix MAT with the diagonal matrix       ***
C**                    prec (normalization vector) from             ***
C**                    the right hand side.                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER : H. Haefner                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit noen-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lindex,ia1,nproc,nrblk
      integer           info(ia1,ia2),index(lindex)
      integer           ptrinf(ntyp+1,nproc)
      integer           ptsmyb,ptsmbk,l
      double precision  prec(l),dummy(l),mat(lmat)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i,k,jc
      integer           adda,lvt,iac1,indc
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      do 100 k=ptrinf(1,nrblk)+1,ptrinf(2,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
        do 120 i=1,lvt
          mat(i+adda) = mat(i+adda) * prec(i+iac1)
  120   continue
  100 continue
C**                                                                 ***
      do 200 k=ptrinf(2,nrblk)+1,ptrinf(3,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
        do 220 i=1,lvt
          mat(i+adda) = mat(i+adda) * prec(i+iac1)
  220   continue
  200 continue
C**                                                                 ***
      do 300 k=ptrinf(3,nrblk)+1,ptrinf(4,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
	indc  =info(k,6)
        include "norec.h"
        do 320 i=1,lvt
          jc = index(i+indc)
          mat(i+adda) = mat(i+adda) * prec(jc+iac1)
  320   continue
  300 continue
C**                                                                 ***
      do 400 k=ptrinf(4,nrblk)+1,ptrinf(5,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	indc  =info(k,6)
        include "norec.h"
        do 420 i=1,lvt
          jc = index(i+indc) - ptsmbk
          mat(i+adda) = mat(i+adda) * prec(jc)
  420   continue
  400 continue
C**                                                                 ***
      do 500 k=ptrinf(5,nrblk)+1,ptrinf(6,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
        do 520 i=1,lvt
          mat(i+adda) = mat(i+adda) * prec(i+iac1)
  520   continue
  500 continue
C**                                                                 ***
      do 600 k=ptrinf(6,nrblk)+1,ptrinf(7,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	indc  =info(k,6)
        include "norec.h"
        do 620 i=1,lvt
          jc = index(i+indc) - ptsmbk
          mat(i+adda) = mat(i+adda) * prec(jc)
  620   continue
  600 continue
C**                                                                 ***
      do 700 k=ptrinf(7,nrblk)+1,ptrinf(8,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
        do 720 i=1,lvt
          mat(i+adda) = mat(i+adda) * prec(i+iac1)
  720   continue
  700 continue
C**                                                                 ***
      do 800 k=ptrinf(8,nrblk)+1,ptrinf(9,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
        do 820 i=1,lvt
          mat(i+adda) = mat(i+adda) * prec(iac1+1)
  820   continue
  800 continue
C**                                                                 ***
      do 900 k=ptrinf(9,nrblk)+1,ptrinf(11,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	indc  =info(k,6)
        include "norec.h"
        do 920 i=1,lvt
          jc = index(i+indc) - ptsmbk
          mat(i+adda) = mat(i+adda) * prec(jc)
  920   continue
  900 continue
C**                                                                 ***
      do 1100 k=ptrinf(11,nrblk)+1,ptrinf(12,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4) - ptsmbk
        do 1120 i=1,lvt
          mat(i+adda) = mat(i+adda) * prec(iac1+1)
 1120   continue
 1100 continue
C**                                                                 ***
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL5AP----------------------------------------------------
      e    n    d
