C:::::      ,,,,,LL5DIA.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL5DIA(lmat,lindex,ldw,l,lmain,main,ia1,mat,dw,info,
     #                  ilin,index,ptrinf,nproc,myproc,lmyblk,ptsmyb)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 5 D I A   stores the coefficients of the main diagonal ***
C**                    of the matrix MAT into a buffer of length l. ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996       ***
C**      PROGRAMMER :  H. Haefner                                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                    ***
C**   THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lindex,ldw,l,main,ia1,nproc,
     *                  myproc,lmyblk,ptsmyb,lmain
      double precision  dw(ldw),mat(lmat)
      integer           info(ia1,ia2),ilin(nilin),ptrinf(ntyp+1,nproc)
      integer           index(lindex)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**                                                                 ***
C**   see Manual Pages <linsol>                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i,jc,jr,k,adda,counvt,counel,lvt,indc,indr
      integer           couold,iac1,iar1,lout,maxout
      real              percnt
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0., maxout = 50)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      lout = ilin(12)

      if ((ilin(13) .lt. 0) .and. (ilin(13) .ge. -maxout))
     &   write(lout,1000)
      if ((ilin(13) .gt. 0) .and. (ilin(13) .le. maxout)) then
        if (myproc .eq. 1) write(lout,1000)
      endif

      do 10 i=1,l
        dw(main+i-1) = zero
   10 continue
C**                                                                 ***
      counvt = 0
      counel = 0
      do 20 k=ptrinf(2,myproc)+1,ptrinf(3,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iac1 = info(k,4)-ptsmyb
	iar1 = info(k,5)-ptsmyb
	if (iac1 .ne. iar1) goto 20
	counvt = counvt + 1
        do 25 i=1,lvt
          dw(main+iar1+i-1) = dw(main+iar1+i-1) + mat(i+adda)
	  counel = counel + 1
   25   continue
   20 continue
      if (ptrinf(3,myproc) .gt. ptrinf(2,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1002) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1002) counvt,counel
        endif
      endif

C**
      counvt = 0
      do 30 k=ptrinf(3,myproc)+1,ptrinf(4,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iac1 = info(k,4)-ptsmyb
	iar1 = info(k,5)-ptsmyb
	if (iac1 .ne. iar1) goto 30
	counvt = counvt + 1
	indc = info(k,6)
        do 35 i=1,lvt
	  jc = index(i+indc)
          dw(main+iar1+jc-1) = dw(main+iar1+jc-1) + mat(i+adda)
	  counel = counel + 1
   35   continue
   30 continue
      if (ptrinf(4,myproc) .gt. ptrinf(3,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1003) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1003) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 40 k=ptrinf(4,myproc)+1,ptrinf(5,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iar1 = info(k,5)-ptsmyb
	indc = info(k,6)
        couold = counel
        do 45 i=1,lvt
	  jc = index(i+indc)
	  if (iar1+i .eq. jc) then
            dw(main+jc-1) = dw(main+jc-1) + mat(i+adda)
	    counel = counel + 1
          endif
   45   continue
	if (counel .gt. couold) counvt = counvt + 1
   40 continue
      if (ptrinf(5,myproc) .gt. ptrinf(4,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1004) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1004) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 50 k=ptrinf(5,myproc)+1,ptrinf(6,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iac1 = info(k,4)-ptsmyb
	indr = info(k,7)
        couold = counel
        do 55 i=1,lvt
	  jr = index(i+indr)
	  if (iac1+i .eq. jr) then
            dw(main+jr-1) = dw(main+jr-1) + mat(i+adda)
	    counel = counel + 1
          endif
   55   continue
	if (counel .gt. couold) counvt = counvt + 1
   50 continue
      if (ptrinf(6,myproc) .gt. ptrinf(5,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1005) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1005) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 60 k=ptrinf(6,myproc)+1,ptrinf(7,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	indc = info(k,6)
	indr = info(k,7)
        couold = counel
        do 65 i=1,lvt
	  jc = index(i+indc)
	  jr = index(i+indr)
	  if (jc .eq. jr) then
            dw(main+jr-1) = dw(main+jr-1) + mat(i+adda)
	    counel = counel + 1
          endif
   65   continue
	if (counel .gt. couold) counvt = counvt + 1
   60 continue
      if (ptrinf(7,myproc) .gt. ptrinf(6,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1006) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1006) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 70 k=ptrinf(7,myproc)+1,ptrinf(8,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iac1 = info(k,4)-ptsmyb
	iar1 = info(k,5)-ptsmyb
	if ((iac1+1 .gt. iar1+1) .or. (iac1+lvt .lt. iar1+1)) goto 70
        couold = counel
        do 75 i=1,lvt
	  if (iac1+i .eq. iar1+1) then
            dw(main+iar1) = dw(main+iar1) + mat(i+adda)
	    counel = counel + 1
          endif
   75   continue
	if (counel .gt. couold) counvt = counvt + 1
   70 continue
      if (ptrinf(8,myproc) .gt. ptrinf(7,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1007) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1007) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 80 k=ptrinf(8,myproc)+1,ptrinf(9,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iac1 = info(k,4)-ptsmyb
	iar1 = info(k,5)-ptsmyb
	if ((iar1+1 .gt. iac1+1) .or. (iar1+lvt .lt. iac1+1)) goto 80
        couold = counel
        do 85 i=1,lvt
	  if (iar1+i .eq. iac1+1) then
            dw(main+iac1) = dw(main+iac1) + mat(i+adda)
	    counel = counel + 1
          endif
   85   continue
	if (counel .gt. couold) counvt = counvt + 1
   80 continue
      if (ptrinf(9,myproc) .gt. ptrinf(8,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1008) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1008) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 90 k=ptrinf(9,myproc)+1,ptrinf(11,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iar1 = info(k,5)-ptsmyb
	indc = info(k,6)
        couold = counel
        do 95 i=1,lvt
	  jc = index(i+indc)
	  if (iar1+1 .eq. jc) then
            dw(main+iar1) = dw(main+iar1) + mat(i+adda)
	    counel = counel + 1
          endif
   95   continue
	if (counel .gt. couold) counvt = counvt + 1
   90 continue
      if (ptrinf(11,myproc) .gt. ptrinf(9,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1009) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1009) counvt,counel
        endif
      endif
C**
      counvt = 0
      do 110 k=ptrinf(11,myproc)+1,ptrinf(12,myproc)
	adda = info(k,2)
	lvt  = info(k,3)
	iac1 = info(k,4)-ptsmyb
	indr = info(k,7)
        couold = counel
        do 115 i=1,lvt
	  jr = index(i+indr)
	  if (iac1+1 .eq. jr) then
            dw(main+iac1) = dw(main+iac1) + mat(i+adda)
	    counel = counel + 1
          endif
  115   continue
	if (counel .gt. couold) counvt = counvt + 1
  110 continue
      if (ptrinf(12,myproc) .gt. ptrinf(11,myproc)) then
        if ((ilin(13) .lt. 0) .and. (ilin(13) .gt. -3))
     &    write(lout,1011) counvt,counel
        if ((ilin(13) .gt. 0) .and. (ilin(13) .lt. 3)) then
          if (myproc .eq. 1) write(lout,1011) counvt,counel
        endif
      endif

      counel = 0
      lmain = 0
      do 120 i=1,lmyblk
        if (dw(main+i-1) .ne. zero) then
	  counel = counel + 1
	  lmain = 1
        endif
  120 continue
      percnt = float(counel)/float(lmyblk)
      percnt = percnt*100
      if ((ilin(13) .lt. 0) .and. (ilin(13) .ge. -maxout))
     &  write(lout,1020) percnt
      if ((ilin(13) .gt. 0) .and. (ilin(13) .le. maxout)) then
        if (myproc .eq. 1) write(lout,1020) percnt
      endif

c1000 format(' ***************************************************'/
 1000 format(' !!! No explicit main diagonal for normalization !!!'/
     &       ' ---------------------------------------------------')
 1002 format('    Storage pattern 2 <-> Full Diagonal:'/
     &       '    ',i5,' full diagonals are main diagonal(s)'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1003 format('    Storage pattern 3 <-> Packed Diagonal:'/
     &       '    ',i5,' packed diagonals are main diagonal(s)'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1004 format('    Storage pattern 4 <-> Indexed Column:'/
     &       '    ',i5,' ind. cols with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1005 format('    Storage pattern 5 <-> Indexed Row:'/
     &       '    ',i5,' ind. rows with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1006 format('    Storage pattern 6 <-> Starry Sky:'/
     &       '    ',i5,' <st. skies> with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1007 format('    Storage pattern 7 <-> Full Row:'/
     &       '    ',i5,' full rows with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1008 format('    Storage pattern 8 <-> Full Columns:'/
     &       '    ',i5,' full cols with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1009 format('    Storage pattern 9 <-> Packed Row:'/
     &       '    ',i5,' packed rows with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1011 format('    Storage pattern 11 <-> Packed Columns:'/
     &       '    ',i5,' packed cols with main diagonal elements found'/
     &       '    ->',i6,' elements mounted on main diagonal buffer')
 1020 format('    --->'/
     &       '    ',f6.1,' percent of the main diagonal are filled '/
     &       '             with non-zero elements '/)

C**                                                                 ***
C**** END OF CALCULATION                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      r e t u r n
C-----END OF LL5DIA----------------------------------------------------
      e    n    d
