C:::::      ,,,,,LL5RST.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL5RST(mat,dummy,prec,ptsmyb,l,ptsmbk,lmat, 
     #              lindex,ia1,info,index,nrblk,ptrinf,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 5 R S T   is the kernel routine for the computation    ***
C**                    of the row sum of the symmetrical matrix     ***
C**                    part (matrix MAT_transposed).                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER : L.GROSS + H.Haefner                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lindex,ia1
      integer           info(ia1,ia2),index(lindex)
      integer           ptsmyb,l,ptsmbk,nrblk,nproc
      integer           ptrinf(ntyp+1,nproc)
      double precision  prec(l),dummy(l),mat(lmat)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
C
      integer           i,k,iac1,jc
      integer           adda,lvt,indc
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      do 200 k=ptrinf(2,nrblk)+1,ptrinf(3,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	iac1  =info(k,4) - ptsmbk
c       iar1  =info(k,5) - ptsmyb
        do 250 i=1,lvt
          prec(i+iac1) = prec(i+iac1) + abs(mat(i+adda))
  250   continue 
  200 continue 
C**                                                                 ***
      do 300 k=ptrinf(3,nrblk)+1,ptrinf(4,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	iac1  =info(k,4) - ptsmbk
        indc  =info(k,6)
        include "norec.h"
        do 350 i=1,lvt
	  jc = index(i+indc)
          prec(jc+iac1) = prec(jc+iac1) + abs(mat(i+adda))
  350   continue 
  300 continue 
C**                                                                 ***
      do 400 k=ptrinf(4,nrblk)+1,ptrinf(5,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        indc  =info(k,6)
        include "norec.h"
        do 450 i=1,lvt
 	  jc = index(i+indc)-ptsmbk
	  prec(jc) = prec(jc) + abs(mat(i+adda))
  450   continue 
  400 continue 
C**                                                                 ***
      do 500 k=ptrinf(5,nrblk)+1,ptrinf(6,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	iac1  =info(k,4) - ptsmbk
        do 550 i=1,lvt
          prec(i+iac1) = prec(i+iac1) + abs(mat(i+adda))
  550   continue 
  500 continue 
C**                                                                 ***
      do 600 k=ptrinf(6,nrblk)+1,ptrinf(7,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        indc  =info(k,6)
        include "norec.h"
        do 650 i=1,lvt
 	  jc = index(i+indc)-ptsmbk
	  prec(jc) = prec(jc) + abs(mat(i+adda))
  650   continue 
  600 continue 
C**                                                                 ***
      do 700 k=ptrinf(7,nrblk)+1,ptrinf(8,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	iac1  =info(k,4) - ptsmbk
        do 750 i=1,lvt
          prec(i+iac1) = prec(i+iac1) + abs(mat(i+adda))
  750   continue 
  700 continue 
C**                                                                 ***
      do 800 k=ptrinf(8,nrblk)+1,ptrinf(9,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	iac1  =info(k,4) - ptsmbk
        do 850 i=1,lvt
          prec(iac1+1) = prec(iac1+1) + abs(mat(i+adda))
  850   continue 
  800 continue 
C**                                                                 ***
      do 900 k=ptrinf(9,nrblk)+1,ptrinf(11,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        indc  =info(k,6)
        include "norec.h"
        do 950 i=1,lvt
 	  jc = index(i+indc)-ptsmbk
	  prec(jc) = prec(jc) + abs(mat(i+adda))
  950   continue 
  900 continue 
C**                                                                 ***
      do 1100 k=ptrinf(11,nrblk)+1,ptrinf(12,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
	iac1  =info(k,4) - ptsmbk
        do 1150 i=1,lvt
          prec(iac1+1) = prec(iac1+1) + abs(mat(i+adda))
 1150   continue 
 1100 continue 
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL5RST----------------------------------------------------
      e    n    d
