C:::::      ,,,,,LL5SSA.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL5SSA(lmat,l,lindex,ptsmyb,prec,ia1,
     #                  info,mat,index,ptrinf,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 5 S S A   is the kernel routine for the computation    ***
C**                    of the square sum of the non-symmetrical     ***
C**                    matrix (part) MAT.                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER : L.GROSS + H.Haefner                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           l,lmat,lindex,ia1
      integer           info(ia1,ia2),index(lindex)
      integer           ptsmyb,nproc
      integer           ptrinf(ntyp+1,nproc)
      double precision  prec(l),mat(lmat)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
C
      integer           i,j,k,iar1,jr,jc
      integer           adda,lvt,indr,indc
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      do 90 i=1,l
	prec(i) = zero
   90 continue 

      do 95 j=1,nproc

      do 100 k=ptrinf(1,j)+1,ptrinf(2,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  = 0
        do 150 i=1,lvt
          prec(i+iar1) = prec(i+iar1) + mat(i+adda)**2
  150   continue 
  100 continue 
C**                                                                 ***
      do 200 k=ptrinf(2,j)+1,ptrinf(3,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5) - ptsmyb
        do 250 i=1,lvt
          prec(i+iar1) = prec(i+iar1) + mat(i+adda)**2
  250   continue 
  200 continue 
C**                                                                 ***
      do 300 k=ptrinf(3,j)+1,ptrinf(4,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5) - ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 350 i=1,lvt
	  jc = index(i+indc)
          prec(jc+iar1) = prec(jc+iar1) + mat(i+adda)**2
  350   continue 
  300 continue 
C**                                                                 ***
      do 400 k=ptrinf(4,j)+1,ptrinf(5,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5) - ptsmyb
        do 450 i=1,lvt
	  prec(i+iar1) = prec(i+iar1) + mat(i+adda)**2
  450   continue 
  400 continue 
C**                                                                 ***
      do 500 k=ptrinf(5,j)+1,ptrinf(6,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        indr  =info(k,7)
        include "norec.h"
        do 550 i=1,lvt
 	  jr = index(i+indr)-ptsmyb
          prec(jr) = prec(jr) + mat(i+adda)**2
  550   continue 
  500 continue 
C**                                                                 ***
      do 600 k=ptrinf(6,j)+1,ptrinf(7,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        indr  =info(k,7)
        include "norec.h"
        do 650 i=1,lvt
 	  jr = index(i+indr)-ptsmyb
	  prec(jr) = prec(jr) + mat(i+adda)**2
  650   continue 
  600 continue 
C**                                                                 ***
      do 700 k=ptrinf(7,j)+1,ptrinf(8,j)
        adda  =info(k,2)
        lvt   =info(k,3)
	iar1  =info(k,5) - ptsmyb
        do 750 i=1,lvt
          prec(iar1+1) = prec(iar1+1) + mat(i+adda)**2
  750   continue 
  700 continue 
C**                                                                 ***
      do 800 k=ptrinf(8,j)+1,ptrinf(9,j)
        adda  =info(k,2)
        lvt   =info(k,3)
	iar1  =info(k,5) - ptsmyb
        do 850 i=1,lvt
          prec(i+iar1) = prec(i+iar1) + mat(i+adda)**2
  850   continue 
  800 continue 
C**                                                                 ***
      do 900 k=ptrinf(9,j)+1,ptrinf(11,j)
        adda  =info(k,2)
        lvt   =info(k,3)
	iar1  =info(k,5) - ptsmyb
        do 950 i=1,lvt
	  prec(iar1+1) = prec(iar1+1) + mat(i+adda)**2
  950   continue 
  900 continue 
C**                                                                 ***
      do 1100 k=ptrinf(11,j)+1,ptrinf(12,j)
        adda  =info(k,2)
        lvt   =info(k,3)
        indr  =info(k,7)
        include "norec.h"
        do 1150 i=1,lvt
 	  jr = index(i+indr)-ptsmyb
          prec(jr) = prec(jr) + mat(i+adda)**2
 1150   continue 
 1100 continue 

   95 continue
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL5SSA----------------------------------------------------
      e    n    d
