C:::::      ,,,,,LL6A2X.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL6A2X(mat,x1,x2,b1,b2,ptsmyb,l,ptsmbk,lmat,
     #                  lindex,ia1,info,index,nrblk,ptrinf,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 6 A 2 X   is the kernel routine for two matrix-        ***
C**                    vector-multiplications with matrix MAT       ***
C**                    and matrix MAT-transposed:                   ***
C**                    b1 = b1 + MAT * x1 ,                         ***
C**                    b2 = b2 + MAT_t * x2 .                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER : H.Haefner                                     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include   'const.h'
      integer   nproc, nrblk, lmat, lindex, ia1
      integer   info(ia1,ia2), index(lindex), ptrinf(ntyp+1,nproc)
      integer   ptsmyb,ptsmbk,l
      double precision  b1(l),x1(l),b2(l),x2(l),mat(lmat)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i, j, k, jc, jr, first
      integer           typ,adda,lvt,iac,iar,iac1,iar1,indc,indr
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      do 200 j = 1,2
        do 170 k = ptrinf(j,nrblk)+1,ptrinf(j+1,nrblk)
         adda  =info(k,2)
         lvt   =info(k,3)
         iac1  =info(k,4)-ptsmbk
         iar1  =info(k,5)-ptsmyb
         do 150 i = 1,lvt
           b1(i+iar1) = b1(i+iar1) + mat(i+adda) * x1(i+iac1)
           b2(i+iac1) = b2(i+iac1) + mat(i+adda) * x2(i+iar1)
150      continue
170     continue  
200   continue 

      do 300 k = ptrinf(3,nrblk)+1,ptrinf(4,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 350 i = 1,lvt
          jc = index(i+indc)
          b1(jc+iar1) = b1(jc+iar1) + mat(i+adda) * x1(jc+iac1)
          b2(jc+iac1) = b2(jc+iac1) + mat(i+adda) * x2(jc+iar1)
350     continue
300   continue   

      do 400 k = ptrinf(4,nrblk)+1,ptrinf(5,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 450 i = 1,lvt
          jc = index(i+indc)-ptsmbk
          b1(i+iar1) = b1(i+iar1) + mat(i+adda) * x1(jc)
          b2(jc) = b2(jc) + mat(i+adda) * x2(i+iar1)
450     continue
400   continue 

      do 500 k = ptrinf(5,nrblk)+1,ptrinf(6,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        indr  =info(k,7)
        include "norec.h"
        do 550 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b1(jr) = b1(jr) + mat(i+adda)*x1(i+iac1)
          b2(i+iac1) = b2(i+iac1) + mat(i+adda)*x2(jr)
550     continue
500   continue    

      do 600 k = ptrinf(6,nrblk)+1,ptrinf(7,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        indc  =info(k,6)
        indr  =info(k,7)
        include "norec.h"
        do 650 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          jc = index(i+indc)-ptsmbk
          b1(jr) = b1(jr) + mat(i+adda)*x1(jc)
          b2(jc) = b2(jc) + mat(i+adda)*x2(jr)
650     continue
600   continue 

      do 700 k = ptrinf(7,nrblk)+1,ptrinf(8,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 750 i = 1,lvt
	  b1(iar1+1) = b1(iar1+1) + mat(i+adda)*x1(iac1+i) 
	  b2(iac1+i) = b2(iac1+i) + mat(i+adda)*x2(iar1+1) 
750     continue
700   continue 

      do 800 k = ptrinf(8,nrblk)+1,ptrinf(9,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 850 i = 1,lvt
	  b1(iar1+i) = b1(iar1+i) + mat(i+adda)*x1(iac1+1)
	  b2(iac1+1) = b2(iac1+1) + mat(i+adda)*x2(iar1+i)
850     continue
800   continue 

      do 900 k = ptrinf(9,nrblk)+1,ptrinf(11,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 950 i = 1,lvt
          jc = index(i+indc)-ptsmbk
	  b1(iar1+1) = b1(iar1+1) + mat(i+adda)*x1(jc) 
	  b2(jc) = b2(jc) + mat(i+adda)*x2(iar1+1) 
950     continue
900   continue 

      do 1100 k = ptrinf(11,nrblk)+1,ptrinf(12,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        indr  =info(k,7)
        include "norec.h"
        do 1150 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b1(jr) = b1(jr) + mat(i+adda)*x1(iac1+1)
          b2(iac1+1) = b2(iac1+1) + mat(i+adda)*x2(jr)
1150    continue
1100  continue 

C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL6A2X----------------------------------------------------
      e    n    d
