C:::::      ,,,,,LL6ASX.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL6ASX(mat,x,b,ptsmyb,l,ptsmbk,lmat,lindex,
     #                  ia1,info,index,nrblk,ptrinf,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 6 A S X   is the kernel routine for the matrix-        ***
C**                    vector-multiplication  with a symmetric      ***
C**                    matrix MAT_s:                                ***
C**                    b = b + MAT_s * x .                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER :  H.Haefner                                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include   'const.h'
      integer   nproc, nrblk, lmat, lindex, ia1
      integer   info(ia1,ia2), index(lindex), ptrinf(ntyp+1,nproc)
      integer   ptsmyb,ptsmbk,l
      double precision  b(l), x(l), mat(lmat)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i, j, k, jc, jr, first
      integer           typ,adda,lvt,iac,iar,iac1,iar1,indc,indr
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      do 100 k = ptrinf(1,nrblk)+1,ptrinf(2,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 150 i = 1,lvt
          b(i+iar1) = b(i+iar1) + mat(i+adda) * x(i+iac1)
150     continue
100   continue 

      do 200 k = ptrinf(2,nrblk)+1,ptrinf(3,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 250 i = 1,lvt
          b(i+iar1) = b(i+iar1) + mat(i+adda) * x(i+iac1)
250     continue
        do 260 i = 1,lvt
          b(i+iac1) = b(i+iac1) + mat(i+adda) * x(i+iar1)
260     continue
200   continue 

      do 300 k = ptrinf(3,nrblk)+1,ptrinf(4,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 350 i = 1,lvt
          jc = index(i+indc)
          b(jc+iar1) = b(jc+iar1) + mat(i+adda) * x(jc+iac1)
350     continue
        include "norec.h"
        do 360 i = 1,lvt
          jc = index(i+indc)
          b(jc+iac1) = b(jc+iac1) + mat(i+adda) * x(jc+iar1)
360     continue
300   continue   

      do 400 k = ptrinf(4,nrblk)+1,ptrinf(5,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 450 i = 1,lvt
          jc = index(i+indc)-ptsmbk
          b(i+iar1) = b(i+iar1) + mat(i+adda) * x(jc)
450     continue
        include "norec.h"
        do 460 i = 1,lvt
          jc = index(i+indc)-ptsmbk
          b(jc) = b(jc) + mat(i+adda) * x(i+iar1)
460     continue
400   continue 

      do 500 k = ptrinf(5,nrblk)+1,ptrinf(6,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        indr  =info(k,7)
        include "norec.h"
        do 550 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b(jr) = b(jr) + mat(i+adda)*x(i+iac1)
550     continue
        include "norec.h"
        do 560 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b(i+iac1) = b(i+iac1) + mat(i+adda)*x(jr)
560     continue
500   continue    

      do 600 k = ptrinf(6,nrblk)+1,ptrinf(7,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        indc  =info(k,6)
        indr  =info(k,7)
        include "norec.h"
        do 650 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          jc = index(i+indc)-ptsmbk
          b(jr)=b(jr) + mat(i+adda)*x(jc)
650     continue
        include "norec.h"
        do 660 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          jc = index(i+indc)-ptsmbk
          b(jc)=b(jc) + mat(i+adda)*x(jr)
660     continue
600   continue 

      do 700 k = ptrinf(7,nrblk)+1,ptrinf(8,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 750 i = 1,lvt
	  b(iar1+1) = b(iar1+1) + mat(i+adda)*x(iac1+i) 
750     continue
        do 760 i = 1,lvt
	  b(iac1+i) = b(iac1+i) + mat(i+adda)*x(iar1+1) 
760     continue
700   continue 

      do 800 k = ptrinf(8,nrblk)+1,ptrinf(9,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 850 i = 1,lvt
	  b(iar1+i) = b(iar1+i) + mat(i+adda)*x(iac1+1)
850     continue
        do 860 i = 1,lvt
	  b(iac1+1) = b(iac1+1) + mat(i+adda)*x(iar1+i)
860     continue
800   continue 

      do 900 k = ptrinf(9,nrblk)+1,ptrinf(11,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 950 i = 1,lvt
          jc = index(i+indc)-ptsmbk
	  b(iar1+1) = b(iar1+1) + mat(i+adda)*x(jc) 
950     continue
        include "norec.h"
        do 960 i = 1,lvt
          jc = index(i+indc)-ptsmbk
	  b(jc) = b(jc) + mat(i+adda)*x(iar1+1) 
960     continue
900   continue 

      do 1100 k = ptrinf(11,nrblk)+1,ptrinf(12,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        indr  =info(k,7)
        include "norec.h"
        do 1150 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b(jr) = b(jr) + mat(i+adda)*x(iac1+1)
1150    continue
        include "norec.h"
        do 1160 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b(iac1+1) = b(iac1+1) + mat(i+adda)*x(jr)
1160    continue
1100  continue 

C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL6ASX----------------------------------------------------
      e    n    d
