C:::::      ,,,,,LL6AX.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL6AX(mat,x,b,ptsmyb,l,ptsmbk,lmat,lindex,
     #                 ia1,info,index,nrblk,ptrinf,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 6 A X     is the kernel routine for the matrix-        ***
C**                    vector-multiplication:                       ***
C**                    b = b + MAT * x .                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995       ***
C**      PROGRAMMER : M. Peter , H.Haefner                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include   'const.h'
      integer   nproc, nrblk, lmat, lindex, ia1
      integer   info(ia1,ia2), index(lindex), ptrinf(ntyp+1,nproc)
      integer   ptsmyb,ptsmbk,l
      double precision  b(l), x(l), mat(lmat)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer           i, j, k, jc, jr, first
      integer           typ,adda,lvt,iac,iar,iac1,iar1,indc,indr
      double precision  zero
C**                                                                 ***
C**        CONSTANTS:                                               ***
C**        ---------                                                ***
C**                                                                 ***
      parameter (zero = 0.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** START OF CALCULATION :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      do 200 j = 1,2
c       print *,'ptrinf:',ptrinf(j,nrblk)+1,ptrinf(j+1,nrblk)
        do 170 k = ptrinf(j,nrblk)+1,ptrinf(j+1,nrblk)
         adda  =info(k,2)
         lvt   =info(k,3)
         iac1  =info(k,4)-ptsmbk
         iar1  =info(k,5)-ptsmyb
c        print *,' adda=',adda,' lvt=',lvt,' iac1=',iac1,' iar1=',iar1
         do 150 i = 1,lvt
           b(i+iar1) = b(i+iar1) + mat(i+adda) * x(i+iac1)
c          print *,' mat=',mat(i+adda),' x=',x(i+iac1),' b=',b(i+iar1)
150      continue
170     continue  
200   continue 

      do 300 k = ptrinf(3,nrblk)+1,ptrinf(4,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 350 i = 1,lvt
          jc = index(i+indc)
          b(jc+iar1) = b(jc+iar1) + mat(i+adda) * x(jc+iac1)
350     continue
300   continue   

      do 400 k = ptrinf(4,nrblk)+1,ptrinf(5,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 450 i = 1,lvt
          jc = index(i+indc)-ptsmbk
          b(i+iar1) = b(i+iar1) + mat(i+adda) * x(jc)
450     continue
400   continue 

      do 500 k = ptrinf(5,nrblk)+1,ptrinf(6,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        indr  =info(k,7)
        include "norec.h"
        do 550 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b(jr) = b(jr) + mat(i+adda)*x(i+iac1)
550     continue
500   continue    

      do 600 k = ptrinf(6,nrblk)+1,ptrinf(7,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        indc  =info(k,6)
        indr  =info(k,7)
        include "norec.h"
        do 650 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          jc = index(i+indc)-ptsmbk
          b(jr)=b(jr) + mat(i+adda)*x(jc)
650     continue
600   continue 

      do 700 k = ptrinf(7,nrblk)+1,ptrinf(8,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 750 i = 1,lvt
	  b(iar1+1) = b(iar1+1) + mat(i+adda)*x(iac1+i) 
750     continue
700   continue 

      do 800 k = ptrinf(8,nrblk)+1,ptrinf(9,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        iar1  =info(k,5)-ptsmyb
        do 850 i = 1,lvt
	  b(iar1+i) = b(iar1+i) + mat(i+adda)*x(iac1+1)
850     continue
800   continue 

      do 900 k = ptrinf(9,nrblk)+1,ptrinf(11,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iar1  =info(k,5)-ptsmyb
        indc  =info(k,6)
        include "norec.h"
        do 950 i = 1,lvt
          jc = index(i+indc)-ptsmbk
	  b(iar1+1) = b(iar1+1) + mat(i+adda)*x(jc) 
c         print *,' mat=',mat(i+adda),' x=',x(jc),' b=',b(iar1+1)
950     continue
c       print *,' adda=',adda,' lvt=',lvt,' iar1=',iar1,' indc=',indc
900   continue 

      do 1100 k = ptrinf(11,nrblk)+1,ptrinf(12,nrblk)
        adda  =info(k,2)
        lvt   =info(k,3)
        iac1  =info(k,4)-ptsmbk
        indr  =info(k,7)
        include "norec.h"
        do 1150 i = 1,lvt
          jr = index(i+indr)-ptsmyb
          b(jr) = b(jr) + mat(i+adda)*x(iac1+1)
1150    continue
1100  continue 

C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL6AX----------------------------------------------------
      e    n    d
