C:::::      ,,,,,LL8CK1.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8CK1(nproc,nvt,ia1,ilin,ierr,tid)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     L L 8 C K 1 :  CHECKS LINSOL PARAMETERS CONCERNING THE      ***
c**                    MATRIX, THE OUTPUT AND NUMBER OF PROCESSORS  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995        ***
C**     PROGRAMMER: H. Haefner     F. SEEGMUELLER                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
C**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include 'const.h'
      include 'maxnpe.h'
      integer nproc,ia1,ierr
      integer ilin(nilin),tid(nproc)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   (see Manual-Pages <linsol>)                                   ***
C**                                                                 ***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
      integer    ione,lout,myproc,nvt,iermax,ihelp,nmsg
      parameter (ione=1)
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      nmsg   = ilin(3)
      lout   = ilin(12)
      myproc = ilin(17)
      ierr   = 0000
      iermax = 0000
C**                                                                 ***
C***  START OF PARAMETER CHECK                                      ***
C**                                                                 ***
      If (lout .lt. 0) then 
        ierr  = 8001
	if (myproc .eq. 1) then
	  write(*,1010)
	  write(*,1016)
	  write(*,1020)
        endif
        goto 999
      endif
c**
      If (nproc .lt. 1) then 
        ierr  = 8002
	write(lout,1010)
	write(lout,1017)
	write(lout,1020)
        goto 999
      endif
c**
      If (nproc .gt. maxnpe) then 
        ierr  = 8003
	if (myproc .eq. 1) then
	  write(lout,1010)
	  write(lout,1018) maxnpe
	  write(lout,1020)
        endif
        goto 999
      endif
c**
      If (ia1 .lt. nvt) then
        ierr  = 8004
	write(lout,1010)
	write(lout,1014) myproc
	write(lout,1020)
        goto 999
      endif
c**
  999 call LL4INM(ione,ione,ione,ierr,iermax,ihelp,myproc,nproc,
     *            tid,nmsg)
      ierr = iermax
c**
c*** FORMATS
c**
 1010 format(' **************************************************'/
     &       ' ***  LL8CK1: error detected;                   ***')
 1014 format(' ***   First dim. of array INFO on proc. ',i6,' ***'/
     &       ' ***   too small: ia1 is less than nvt.         ***')
 1016 format(' ***   Output unit number LOUT has to           ***'/
     &       ' ***   be non-negative.                         ***')
 1017 format(' ***   Number of processors NPROC has           ***'/
     &       ' ***   to be greater than zero.                 ***')
 1018 format(' ***   Number of processors NPROC has           ***'/
     &       ' ***   to be less or equal than ',i6,'          ***')
 1020 format(' **************************************************'/)
c**
c*** 
c**
      r e t u r n
c-----END OF LL8CK1---------------------------------------------------      
      e n d
