C:::::      ,,,,,LL8CK2.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8CK2(l,ldw,liw,ilin,iconv,ierr,nproc,tid)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     L L 8 C K 2 : CHECKS LINSOL PARAMETERS CONCERNING THE       ***
C**                   CG - METHOD                                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995        ***
C**     PROGRAMMER: H. Haefner     F. SEEGMUELLER                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
C**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include 'const.h'
      integer l,ldw,liw,iconv,ierr,nproc
      integer ilin(nilin),tid(nproc)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   (see Manual-Pages <linsol>)                                   ***
C**                                                                 ***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
      integer    lout,ms,isprec,noprec,msprec,myproc
      integer    ione,iermax,ihelp,nmsg,optim
      parameter (ione=1)
C**                                                                 ***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ms     = ilin(1)
      nmsg   = ilin(3)
      isprec = ilin(6)
      noprec = ilin(9)
      lout   = ilin(12)
      msprec = ilin(15)
      myproc = ilin(17)
      optim  = ilin(20)
      ierr   = 0
      iermax = 0
c**
c***  START OF PARAMETER CHECK
c**
c**
c***  CHECK METHOD
c**
      if (((ms .le. 0) .or. (ms .gt. 7)) .and.
     #   (ms .ne. 10) .and. (ms .ne. 100) .and. (ms .ne. 20) .and.
     #   (ms .ne. 9) .and. (ms .ne. 123)) then
	 ierr  = 8006
	 if (myproc .eq. 1) then
	    write(lout,1030)
	    write(lout,1035)
	    write(lout,1036) ms
	    write(lout,1037)
	    write(lout,1040)
         endif
         ilin(1) = 10
         ms      = ilin(1)
      endif
c**
c***  CHECK WORKSPACE LDW
c**
      if ((ms .eq. 1) .or. (ms .eq. 10) .or. (ms .eq. 100)) then
	if (ldw .lt. 21*l) then
	  ierr  = 8007
	  if (myproc .eq. 1) then
	    write(lout,1010)
	    write(lout,1011)
	    write(lout,1020)
          endif
          goto 999
        endif
      endif
c**
      if ((ms .eq. 2) .or. (ms .eq. 6) .or. (ms .eq. 123)) then
	if (ldw .lt. 17*l) then
	  ierr  = 8008
	  if (myproc .eq. 1) then
	    write(lout,1010)
	    write(lout,1012)
	    write(lout,1020)
          endif
          goto 999
        endif
      endif
c**
      if (((ms .ge. 3) .and. (ms .le. 5))
     #      .or. (ms .eq. 9)) then
	if (ldw .lt. 17*l) then
	  ierr  = 8009
	  if (myproc .eq. 1) then
	    write(lout,1010)
	    write(lout,1013)
	    write(lout,1020)
          endif
          goto 999
        endif
      endif
c**
c***  CHECK WORKSPACE LIW
c**
      if ((optim .ne. 100) .and. (optim .ne. 200)) then
	if (liw .lt. 2*nproc) then
	  ierr  = 8013
	  if (myproc .eq. 1) then
	    write(lout,1010)
	    write(lout,1021)
	    write(lout,1020)
          endif
          goto 999
        endif
      endif
c**
      if ((optim .eq. 100) .or. (optim .eq. 200)) then
	if (liw .lt. max(2*nproc,4*l)) then
	  ierr  = 8014
	  if (myproc .eq. 1) then
	    write(lout,1010)
	    write(lout,1022)
	    write(lout,1020)
          endif
          goto 999
        endif
      endif
c**
c***  CHECK ISPREC
c**
      if ((isprec .gt. 1) .or. (isprec .lt. 0)) then
        ierr  = 8010
	if (myproc .eq. 1) then
	  write(lout,1010)
	  write(lout,1016)
	  write(lout,1020)
        endif
        goto 999
      endif
c**
c***  CHECK NOPREC
c**
      if ((noprec .gt. 1) .or. (noprec .lt. 0)) then
        ierr  = 8011
	if (myproc .eq. 1) then
	  write(lout,1010)
	  write(lout,1017)
	  write(lout,1020)
        endif
        goto 999
      endif
c**
c***  CHECK MSPREC
c**
      if (((msprec .gt. 4) .and. (msprec .lt. 11)) .or.
     #     (msprec .gt. 14) .or. (msprec .lt. 0)) then
        ierr  = 8012
	if (myproc .eq. 1) then
	  write(lout,1010)
	  write(lout,1018)
	  write(lout,1020)
        endif
        goto 999
      endif
c**
c***
c** 
  999 call LL4INM(ione,ione,ione,ierr,iermax,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (iermax .ne. 0) then
	if (ierr .ne. iermax) then
	  write(lout,1019) myproc
	endif
        if (iermax .eq. 8006) then
	  ierr = 0
	else
	  ierr = iermax
	endif
      endif
c**
c**
c***  FORMATS
c**
 1010 format(' *****************************************'/
     &       ' ***  LL8CK2: error detected;          ***')
 1011 format(' ***   Not enough workspace!           ***'/
     &       ' ***   ldw is less than 17*l           ***')
 1012 format(' ***   Not enough workspace!           ***'/
     &       ' ***   ldw is less than 14*l           ***')
 1013 format(' ***   Not enough workspace!           ***'/
     &       ' ***   ldw is less than 13*l           ***')
 1016 format(' ***   ilin(6) can only be set to      ***'/
     &       ' ***           zero or one!            ***')
 1017 format(' ***   ilin(9) can only be set to      ***'/
     &       ' ***           zero or one!            ***')
 1018 format(' ***   ilin(15) can only be set to     ***'/
     &       ' ***      0,1,2,3,4 or 11,12,13,14!    ***')
 1019 format(' ***   Parameters which have to be     ***'/
     &       ' ***   global are local on proc.',i6,' ***')
 1020 format(' *****************************************'/)
 1021 format(' ***   Not enough workspace! liw is    ***'/
     &       ' ***   less than 2*nproc               ***')
 1022 format(' ***   Not enough workspace!           ***'/
     &       ' ***   liw is less than                ***'/
     &       ' ***   max(2*nproc,4*l)                ***')
 1030 format(' *******************************************'/
     &       ' ***  LL8CK2 : Warning!                  ***') 
 1035 format(' ***   Wrong method selection parameter: ***')
 1036 format(' ***           ilin(1) = ',i6,'          ***')
 1037 format(' ***   Changing to Polyalgorithm.        ***')
 1040 format(' *******************************************')
      r e t u r n
c-----END OF LL8CK2---------------------------------------------------      
      e n d
