C:::::      ,,,,,LL8CK3.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8CK3(l,liw,nproc,lsym,ilin,iw,lmatbk,
     *                  tid,epslin,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     L L 8 C K 3 : checks if parameters which must be set global ***
C**                   are set local.                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1995        ***
C**     PROGRAMMER: H. Haefner                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include 'const.h'
      integer l,liw,nproc,epslin,ierr
      integer ilin(nilin),lmatbk(nproc),tid(nproc),iw(liw)
      logical lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   (see Manual-Pages <linsol>)                                   ***
C**                                                                 ***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
      integer    ms,itmax,nmsg,nmsgt,isprec,noprec,msprec,myproc,smooth
      integer    vtunit,matin,matout,i,startx,isym,ione,lout
      parameter  (ione=1)
      integer    iermax,maxval(nilin),ihelp(nilin)
C**                                                                 ***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ms     = ilin(1)
      itmax  = ilin(2)
      nmsg   = ilin(3)
      isprec = ilin(6)
      noprec = ilin(9)
      lout   = ilin(12)
      msprec = ilin(15)
      startx = ilin(16)
      myproc = ilin(17)
      smooth = ilin(18)
      vtunit = ilin(21)
      matin  = ilin(22)
      matout = ilin(23)
      ierr   = 0
      iermax = 0
      nmsgt  = nmsg
c**
c***  START OF PARAMETER CHECK
c**
c***  check global ILIN-parameters
c**
      call LL4INM(ione,nilin,ione,ilin,maxval,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (maxval(1) .ne. ms) then
	ierr = 8081
	write(lout,1010)
        write(lout,1011) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(2) .ne. itmax) then
	ierr = 8082
	write(lout,1010)
        write(lout,1012) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(3) .ne. nmsgt) then
	ierr = 8083
	write(lout,1010)
        write(lout,1013) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(6) .ne. isprec) then
	ierr = 8084
	write(lout,1010)
        write(lout,1014) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(9) .ne. noprec) then
	ierr = 8085
	write(lout,1010)
        write(lout,1015) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(15) .ne. msprec) then
	ierr = 8086
	write(lout,1010)
        write(lout,1016) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(16) .ne. startx) then
	ierr = 8087
	write(lout,1010)
        write(lout,1017) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(18) .ne. smooth) then
	ierr = 8088
	write(lout,1010)
        write(lout,1018) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(21) .ne. vtunit) then
	ierr = 8094
	write(lout,1010)
        write(lout,1024) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(22) .ne. matin) then
	ierr = 8095
	write(lout,1010)
        write(lout,1025) myproc
	write(lout,1020)
	goto 999
      endif
      if (maxval(23) .ne. matout) then
	ierr = 8096
	write(lout,1010)
        write(lout,1026) myproc
	write(lout,1020)
	goto 999
      endif
c**
c***  check global parameter  nproc
c**
      call LL4INM(ione,ione,ione,nproc,maxval,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (maxval(1) .ne. nproc) then
	ierr = 8091
	write(lout,1010)
        write(lout,1021) myproc
	write(lout,1020)
	goto 999
      endif
c**
c***  check global parameter  lsym
c**
      if (lsym) then
        isym = 1
      else
        isym = 0
      endif
      call LL4INM(ione,ione,ione,isym,maxval,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (maxval(1) .ne. isym) then
	ierr = 8092
	write(lout,1010)
        write(lout,1022) myproc
	write(lout,1020)
	goto 999
      endif
c**
c***  check global parameter l
c**
      call LL4INM(ione,ione,ione,l,maxval,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (maxval(1) .ne. l) then
	ierr = 8089
	write(lout,1010)
        write(lout,1019) myproc
	write(lout,1020)
	goto 999
      endif
c**
c***  check global parameter-array  lmatbk
c**
      call LL4INM(ione,nproc,ione,lmatbk,iw(1),iw(nproc+1),myproc,
     *            nproc,tid,nmsg)
      do 20 i=1,nproc
        if (iw(i) .ne. lmatbk(i) .or. lmatbk(i) .gt. l) then
	  ierr = 8093
	  write(lout,1010)
          write(lout,1023) i,myproc
	  write(lout,1020)
	  goto 999
        endif
   20 continue
c**
c***  check global parameter epslin
c**
      call LL4INM(ione,ione,ione,epslin,maxval,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (maxval(1) .ne. epslin) then
	ierr = 8097
	write(lout,1010)
        write(lout,1027) myproc
	write(lout,1020)
	goto 999
      endif

c**
c***  check if ierr <> 0 on any processor
c**

  999 call LL4INM(ione,ione,ione,ierr,iermax,ihelp,myproc,nproc,
     *            tid,nmsg)
      if (iermax .ne. 0) then
	ierr = iermax
	if (myproc .eq. 1) then
 	  write(lout,1010)
          write(lout,1029)
	  write(lout,1020)
	endif
      endif

      if (iermax .eq. 0) then
       if (mod(ilin(19),10) .ge. 1) then
        if (vtunit .ne. 6 .and. (vtunit .lt. 21 .or. vtunit .gt. 99))
     *  then
	  if (myproc .eq. 1) then
 	    write(lout,1030)
            write(lout,1031)
	    write(lout,1020)
	  endif
	 ilin(21) = 6
        endif
       endif
      
       if (mod(ilin(19),1000) .ge. 100) then
        if (matin .lt. 21 .or. matin .gt. 99)
     *  then
	  if (myproc .eq. 1) then
 	    write(lout,1030)
            write(lout,1028)
	    write(lout,1020)
	  endif
	 ilin(22) = 22
        endif
       endif
      
       if (mod(ilin(19),10000) .ge. 1000) then
        if (matout .lt. 21 .or. matout .gt. 99)
     *  then
	  if (myproc .eq. 1) then
 	    write(lout,1030)
            write(lout,1032)
	    write(lout,1020)
	  endif
	 ilin(23) = 23
        endif
       endif
      endif

c**
c**
c***  FORMATS
c**
 1010 format(' *******************************************'/
     &       ' ***  LL8CK3: error detected;            ***')
 1011 format(' ***   Parameter <ms> which have to be   ***'/
     &       ' ***   global is local on proc.',i6,'    ***')
 1012 format(' ***   Parameter <itmax> which have to   ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1013 format(' ***   Parameter <nmsg> which have to be ***'/
     &       ' ***   global is local on proc.',i6,'    ***')
 1014 format(' ***   Parameter <isprec> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1015 format(' ***   Parameter <noprec> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1016 format(' ***   Parameter <msprec> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1017 format(' ***   Parameter <startx> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1018 format(' ***   Parameter <smooth> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1021 format(' ***   Parameter <nproc> which have to   ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1022 format(' ***   Parameter <lsym> which have to    ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1024 format(' ***   Parameter <vtunit> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1025 format(' ***   Parameter <matin> which have to   ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1026 format(' ***   Parameter <matout> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1031 format(' ***   Parameter <vtunit> is set to 6!   ***')
 1028 format(' ***   Parameter <matin>  is set to 22!  ***')
 1032 format(' ***   Parameter <matout> is set to 23!  ***')
 1019 format(' ***   Parameter <l> which have to       ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1023 format(' ***   Component',i6,' of <lmatbk> which ***'/
     &       ' ***   must be global is local on proc.  ***'/
     &       ' ***   ',i6,' or is greater than <l>     ***')
 1027 format(' ***   Parameter <epslin> which have to  ***'/
     &       ' ***   be global is local on proc.',i6,' ***')
 1029 format(' ***   FATAL ERROR: global PARAMETER of  ***'/
     &       ' ***                LINSOL is set LOCAL  ***')
 1020 format(' *******************************************'/)
 1030 format(' *******************************************'/
     &       ' ***  LL8CK3:   w a r n i n g  --        ***')
      r e t u r n
c-----END OF LL8CK3---------------------------------------------------      
      e n d
