C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8IRS(index,lindex,info,ia1,ptrinf,iw,liw,nproc,
     &                  maxnvp,nvtold,nvt,myproc,tids,
     &                  nmsg,optim,lout,ierr)
C**                                                                 ***
C**                                                                 ***
C**    State of paramet.: in    in   i/o  in   i/o   in  in   in    ***
C**                       in     in   in    in    in                ***
C**                       in   in   in   out                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   L L 8 I R S   updates array  <ptrinf> and resorts the         ***
C**                 array  <info>.                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996        ***
C**     PROGRAMMER: H. Haefner                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
C**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include   'const.h'
      include   'maxnpe.h'
      integer   nvt,nvtold,ia1,nproc,lindex,maxnvp,myproc,nmsg,ierr,
     &          liw,lout,optim
      integer   info(ia1,ia2),ptrinf(ntyp+1,nproc),index(lindex),
     &          tids(nproc),iw(liw)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   (see Manual-Pages <linsol>)                                   ***
C**                                                                 ***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
      integer    i,ii,j,k,kk,jj1,jj2,jj3,iblk,istart,it,ityp,ivt,nrblk
      integer    iermax,ihelp,cstrp,ic1,ic2,numvt,posanf
      integer    nrinf(ntyp+1,maxnpe),iwork(ia2)
      logical    lsort

C
C**** START OF CALCULATION :
C     ---------------------
C
      ierr = 0
      do 3 i=1,nproc
        print *,(ptrinf(j,i),j=1,ntyp+1)
   3  continue

      do 4 nrblk=1,nproc
        do 6 ityp=1,ntyp
          nrinf(ityp,nrblk) = ptrinf(ityp+1,nrblk)-ptrinf(ityp,nrblk)
   6    continue
   4  continue

C**
C**   calculate new number of entries in ptrinf
C**
      do 10 j=nvtold+1,nvt
        ityp = info(j,1)
	if (ityp .ge. 20 .and. ityp .le. 90) ityp=ityp/10 
	if (ityp .eq. 100) ityp=11 
	if (ityp .eq. 2 .or. ityp .eq. 3) then
	  nrblk = info(j,7)/10000
          nrinf(ityp,nrblk) = nrinf(ityp,nrblk)+1
        endif
	if (ityp .eq. 6) then
	  nrblk = info(j,5)/10000
          nrinf(ityp,nrblk) = nrinf(ityp,nrblk)+1
        endif
  10  continue
C**                             
C**   calculate new ptrinf-array
C**
      k=0
      do 20 i=1,nproc
        ptrinf(1,i) = k 
        do 30 j=2,ntyp+1
          ptrinf(j,i) = ptrinf(j-1,i)+nrinf(j-1,i)
  30    continue  
        k = ptrinf(ntyp+1,i)
  20  continue  

      do 23 i=1,nproc
        print *,(ptrinf(j,i),j=1,ntyp+1)
  23  continue
C**
C**   sort info-array (in array <iw>)
C**
      istart = 1
      do 32 iblk = 1,nproc
        do 34 it = 1,ntyp
          numvt = nrinf(it,iblk)
	  print *,' ityp,iblk,numvt',it,iblk,numvt
          posanf = ptrinf(it,iblk)+1
          ivt=istart
          do 36 i=1,numvt
  555       ityp = info(ivt,1)
	    if (ityp .eq. 10) ityp=1 
	    if (ityp .ge. 20 .and. ityp .le. 90) ityp=ityp/10 
	    if (ityp .eq. 100) ityp=11 
	    if (ityp .eq. 1 .or. ityp .eq. 4 .or. ityp .eq. 5) then
	      nrblk = iblk
            endif
	    if (ityp .eq. 2 .or. ityp .eq. 3) then
	      nrblk = info(ivt,7)/10000
            endif
	    if (ityp .eq. 6) then
	      nrblk = info(ivt,5)/10000
            endif
            if (nrblk .ne. iblk .or. ityp .ne. it) then
              ivt = ivt+1
              if (ivt .gt. nvt) then
                ierr = 8800+myproc
                write(lout,1000)
                write(lout,1035) myproc,it
                write(lout,1020)
                goto 999
              endif
              goto 555
            endif
            do 37 j=1,ia2
              iw((posanf+i-2)*ia2+j) = info(ivt,j)
  37        continue
            if (ivt .eq. istart) istart = istart+1
            ivt = ivt+1
  36      continue
  34    continue
  32  continue

      do 38 j=1,ia2
        do 39 i=1,nvt
          info(i,j) = iw((i-1)*ia2+j) 
  39    continue
  38  continue

C**
C**   sort info-array by cache stripes
C**
      ityp = 2
 666  do 40 i=1,nproc
        do 42 k=1,maxnvp
	  iw(k) = 0
  42    continue
        do 50 j=ptrinf(ityp,i)+1,ptrinf(ityp+1,i)
	  if (ityp .eq. 2 .or. ityp .eq. 3) then
	    cstrp = mod(info(j,7),10000)
	  endif
	  if (ityp .eq. 6) then
	    cstrp = mod(info(j,5),10000)
	  endif
	  iw(cstrp) = iw(cstrp)+1
  50    continue
        jj1=ptrinf(ityp,i)+1
	jj3=jj1
        do 60 j=1,maxnvp
	  if (jj1 .ne. jj3) then
            ierr = 8800+myproc
            write(lout,1000)
            write(lout,1030) myproc,ityp
            write(lout,1020)
            goto 999
          endif
          do 70 k=1,iw(j)
	    jj2=jj1
 777        if (ityp .eq. 2 .or. ityp .eq. 3) then
	      cstrp = mod(info(jj2,7),10000)
	    endif
	    if (ityp .eq. 6) then
	      cstrp = mod(info(jj2,5),10000)
	    endif
	    if (cstrp .ne. j) then
	      jj2 = jj2+1
	      if (jj2 .gt. ptrinf(ityp+1,i)) then
                ierr = 8800+myproc
                write(lout,1000)
                write(lout,1030) myproc,ityp
                write(lout,1020)
                goto 999
              endif
	      goto 777
            endif
	    if (jj2 .ne. jj1) then
	      do 76 ii=1,ia2
		ihelp = info(jj2,ii)
		info(jj2,ii) = info(jj1,ii)
		info(jj1,ii) = ihelp
  76          continue
            endif
	    jj1 = jj1+1
  70      continue
          jj3=jj3+iw(j)
  60    continue

C**
C**   sort info-array within cache stripes (bubble sort)
C**
        if (ityp .eq. 2 .or. ityp .eq. 3) then
          jj1=ptrinf(ityp,i)+1
          do 80 j=1,maxnvp
            do 85 kk=1,iw(j)-1
	      lsort = .true.
              do 90 k=1,iw(j)-kk
                if (ityp .eq. 2) then
		  ic1 = info(jj1+k-1,4)
		  ic2 = info(jj1+k,4)
	        endif
                if (ityp .eq. 3) then
		  ic1 = info(jj1+k-1,4)+index(info(jj1+k-1,6)+1)
		  ic2 = info(jj1+k,4)+index(info(jj1+k,6)+1)
	        endif
	        if (ic1 .gt. ic2) then
	          do 96 ii=1,ia2
		    ihelp = info(jj1+k,ii)
		    info(jj1+k,ii) = info(jj1+k-1,ii)
		    info(jj1+k-1,ii) = ihelp
  96              continue
		  lsort = .false.
	        endif
  90          continue
	      if (lsort) goto 888
  85        continue
 888        jj1=jj1+iw(j)
  80      continue
	endif
  40  continue

      if (ityp .eq. 2) then
	ityp = 3
	goto 666
      endif
      if (ityp .eq. 3 .and. optim .eq. 200) then
	ityp = 6
	goto 666
      endif


  999 call LL4INM(1,1,1,ierr,iermax,ihelp,myproc,nproc,tids,nmsg)
      if (iermax .gt. 0) then
        ierr = iermax
        if (myproc .eq. 1) then
          write(lout,1000)
          write(lout,1040) iermax-8800
          write(lout,1020)
        endif
      endif

 1000 format(' **********************************************'/
     &       ' ***  Error occured in LSOLPP (LL8IRS):     ***')
 1030 format(' ***     Implementation error on            ***'/
     &       ' ***     processor ',i4,' sorting type',i3,'     ***')
 1035 format(' ***     Array <info> has wrong data on     ***'/
     &       ' ***     processor ',i4,' sorting type',i3,'     ***')
 1040 format(' ***     Implementation error on            ***'/
     &       ' ***     processor ',i4,'                     ***')
 1020 format(' **********************************************')

      R E T U R N
C------END OF LL8IRS--------------------------------------------
      E N D                                   
