C:::::      ,,,,,LL8NME.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8NME(work,xs,x,r,prec,esnorm,enorm,rnorm,l,lmyblk,
     &                  lprec,ilin,nproc,myproc,tid,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 N M E  calculates the norm of the error              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1996                     ***
c**      PROGRAMMER:   H. Haefner                                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -------------------                                        ***
C**                                                                 ***
      include          'const.h'
      integer          l,lmyblk,lprec,nproc,myproc,nmsg
      integer          tid(nproc),ilin(nilin)
      double precision work(l),xs(l),x(l),r(l),prec(lprec),
     *                 esnorm,enorm,rnorm
C**                                                                 ***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   ---------------------------                                   ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C work   I  R   I  -  I  vector containing the difference of actual 
C        I      I     I  and exact solution
C--------I------I-----I------------------------------------------------
C x      I  R   I IN  I  vector containing the actual solution (not 
C        I      I     I  smoothed)
C--------I------I-----I------------------------------------------------
C xs     I  R   I IN  I  vector containing the actual smoothed solution
C--------I------I-----I------------------------------------------------
C prec   I  R   I IN  I  normalization and preconditioning vector
C--------I------I-----I------------------------------------------------
C xexact I  R   I IN  I  vector containing the exact solution 
C--------I------I-----I------------------------------------------------
C esnorm I  R   I OUT I  euclidian norm of the smoothed error
C--------I------I-----I------------------------------------------------
C enorm  I  R   I OUT I  euclidian norm of the error
C--------I------I-----I------------------------------------------------
C rnorm  I  R   I OUT I  euclidian norm of the residual (not smoothed)
C--------I------I-----I------------------------------------------------

      integer           i,ione
      double precision  rpoly,rseucn,xexact,help
      logical           lsym

      common /norms/ rseucn,rpoly(3),lsym
      common /solex/ xexact(1)

      parameter (ione = 1)
C**-----------------------------------------------------------------***

      if ((ilin(1) .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
        do 50 i=1,lmyblk
          work(i) = (prec(i)*xs(i)-xexact(i))/prec(i)
  50    continue
      else
        do 100 i=1,lmyblk
          work(i) = xs(i)-xexact(i)
 100    continue
      endif

      call LL4SCP(lmyblk,ione,l,ione,work,1,work,1,esnorm,help,
     *            .false.,myproc,nproc,tid,nmsg)
      esnorm = sqrt(esnorm)

      if ((ilin(1) .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
        do 150 i=1,lmyblk
          work(i) = (prec(i)*x(i)-xexact(i))/prec(i)
 150    continue
      else
        do 200 i=1,lmyblk
          work(i) = x(i)-xexact(i)
 200    continue
      endif

      call LL4SCP(lmyblk,ione,l,ione,work,1,work,1,enorm,help,
     *            .false.,myproc,nproc,tid,nmsg)
      enorm = sqrt(enorm)

      call LL4SCP(lmyblk,ione,l,ione,r,1,r,1,rnorm,help,
     *            .false.,myproc,nproc,tid,nmsg)
      rnorm = sqrt(rnorm)
c**
c**
c**   END OF CALCULATION
c**   ------------------ 
c**
      r e t u r n
c**                                                                 ***
c**---END OF LL8NME-------------------------------------------------***
c**                                                                 ***
      e    n    d
  
