C:::::      ,,,,,LL8SMO.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8SMO(dw,ibrs,ibrp1,ibxs,ibxp1,ibcom,ldw,l,lmyblk,
     #                  myproc,nproc,tid,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 S M O   computes the smoothed solution and           ***
C**      residual of the normalized system.                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner + L.GROSS  +  C.ROLL             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      integer           l,ldw,lmyblk,myproc,nproc,nmsg
      integer           ibrs,ibrp1,ibxs,ibxp1,ibcom
      integer           tid(nproc)
      double precision  dw(ldw)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
C**                    >                                            ***
      integer           i,n,m
      integer           ptrdw1(2),ptrdw2(1)
      logical           spur
      double precision  zero,gamma(2),rwork(2)
C**                                                                 ***
C**       CONSTANTS:                                                ***
C**       ---------                                                 ***
C**                                                                 ***
      parameter (zero=0, n=2, m=1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
C
      do 20 i=0,lmyblk-1
        dw(ibcom+i) = dw(ibrp1+i) - dw(ibrs+i)
   20 continue

      ptrdw1(1) = ibcom
      ptrdw1(2) = ibrs
      ptrdw2(1) = ibcom
      spur = .false.
      call LL4SCP(lmyblk,n,l,m,dw,ptrdw1,dw,ptrdw2,gamma,rwork,spur,
     #            myproc,nproc,tid,nmsg)
      if (gamma(1) .ne. zero) then
	gamma(1) = -gamma(2)/gamma(1)
        include 'norec.h'
        do 40 i=0,lmyblk-1
	  dw(ibrs+i) = dw(ibrs+i) + gamma(1)*dw(ibcom+i)
          dw(ibxs+i) = dw(ibxs+i) + gamma(1)*(dw(ibxp1+i)-dw(ibxs+i))
   40   continue
      endif
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL8SMO----------------------------------------------------
      e    n    d
