C:::::      ,,,,,LL8SMQ.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8SMQ(dw,ibrs,ibrp1,ibxs,ibxp1,ibcom,ldw,l,lmyblk,
     #                  break,count,myproc,nproc,tid,nmsg)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 S M Q   computes the smoothed solution and           ***
C**      residual of the normalized system for the QMR-Simulator.   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1995                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   the implicit none-instruction has the aim,                    ***
C**   that all variables must be declared explicitly.               ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      integer           count,l,ldw,lmyblk,myproc,nproc,nmsg
      integer           ibrs,ibrp1,ibxs,ibxp1,ibcom
      integer           tid(nproc)
      logical           break
      double precision  dw(ldw)
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
C**                    >                                            ***
      integer           i,n,m
      double precision  zero,gamma,gammah,gammar,rwork
C**                                                                 ***
C**       CONSTANTS:                                                ***
C**       ---------                                                 ***
C**                                                                 ***
      parameter (zero=0, n=1, m=1)

      save gammar
C**                                                                 ***
C**-----------------------------------------------------------------***
C
C
C**** START OF CALCULATION :
C     ---------------------
C
C
      if (count .eq. 1 .or. break) then
        call LL4SCP(lmyblk,n,l,m,dw,ibrs,dw,ibrs,gammar,rwork,
     #              .false.,myproc,nproc,tid,nmsg)
	gammar = 1.d0/gammar
      endif

      call LL4SCP(lmyblk,n,l,m,dw,ibrp1,dw,ibrp1,gammah,rwork,
     #            .false.,myproc,nproc,tid,nmsg)
      gammar = gammar + 1.d0/gammah
      gamma = 1.d0/gammar*1.d0/gammah
      include 'norec.h'
      do 40 i=0,lmyblk-1
        dw(ibxs+i) = (1.d0-gamma)*dw(ibxs+i) + gamma*dw(ibxp1+i)
        dw(ibrs+i) = (1.d0-gamma)*dw(ibrs+i) + gamma*dw(ibrp1+i)
   40 continue
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL8SMQ----------------------------------------------------
      e    n    d
