C:::::      ,,,,,LL8SC9.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8SC9(mat,index,l,lmat,lindex,info,nvt,ivt,ia1,
     #                  lmatbk,ptrmbk,myproc,nproc,tid,nmsg,lout,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 S C 9   separates packed rows in <nproc>             ***
C**                    column blocks.                               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1995                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include    'const.h'
      integer    lmat,lindex,ia1,ivt,nvt,nproc,myproc,
     *           nmsg,ierr,l,lout
      integer    info(ia1,ia2),index(lindex),tid(nproc),lmatbk(nproc),
     *           ptrmbk(nproc+1)
C**                                                                 ***
      double precision   mat(lmat)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   Arrays mat(lmat),info(ia1,ia2),tid(nproc),lmatbk(nproc),      ***
C**          ptrmbk(nproc+1) and                                    ***
C**   Variables lmat,ia1,ia2,nproc,myproc,nmsg,ierr,l:              ***
C**              see Manual-Pages <linsol>                          ***
C**                                                                 ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ivt    I  I   I in  I  number of vector term to separate
C        I      I     I  Note: it can vary on different processors
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer    i,j,k,iwork,iermax,iar,iacbgn,iacend,indc
      integer    adda,glvt,s_addr,iac,lvtl
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ierr = 0
      adda = info(ivt,2)
      iac  = 0
      iar  = info(ivt,5)
      indc = info(ivt,6) 
      info(ivt,7) = 0

      do 10 i=nproc,1,-1
        glvt = info(ivt,3)
        iacbgn = iac+index(indc+1)-1
        iacend = iac+index(indc+glvt)
	if (iacbgn .lt. ptrmbk(i)) then
	  if (iacend .gt. ptrmbk(i)) then
	    nvt = nvt+1
	    if (nvt .gt. ia1) then
	      ierr = 8090+myproc
              write(lout,1000)
              write(lout,1010) myproc
              write(lout,1020)
	      goto 999
	    endif
	    k = 0
	    j = 1
   22       if (index(indc+j)-1 .lt. ptrmbk(i)) then
	      j = j+1
	      k = k+1
              goto 22
            endif
	    lvtl = k
	    s_addr  = lvtl
            info(nvt,1) = 9
            info(nvt,2) = adda+s_addr
            info(nvt,4) = 0
            info(nvt,5) = iar
            info(nvt,6) = indc+s_addr
            info(nvt,7) = 0
	    if (iacend .le. ptrmbk(i)+lmatbk(i)) then
	      info(nvt,3) = glvt-lvtl
            else
	      ierr = 8090+myproc
              write(lout,1000)
              write(lout,1030) myproc
              write(lout,1020)
	      goto 999
            endif
	    info(ivt,3) = glvt-info(nvt,3)
          endif
        endif
   10 continue

  999 call LL4INM(1,1,1,ierr,iermax,iwork,myproc,nproc,tid,nmsg)
      if (iermax .gt. 0) then
	ierr = iermax
	if (myproc .eq. 1) then
          write(lout,1000)
          write(lout,1010) iermax-8090
          write(lout,1020)
        endif
      endif


 1000 format(' **********************************************'/
     &       ' ***  Error occured in LINSOL (LL8SC9):     ***')
 1010 format(' ***   First dimension of array <info> is   ***'/
     &       ' ***   too small on processor ',i6,'        ***')
 1020 format(' **********************************************')
 1030 format(' ***   LL8SC9: Implementation error         ***')
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL8SC9---------------------------------------------------
      e    n    d
