C:::::      ,,,,,LL8SR2.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8SR2(info,nvt,ivt,ia1,lmatbk,ptrmbk,ptrinf,
     #                  maxnvp,cachln,myproc,nproc,tid,nmsg,lout,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 S R 2   separates full diagonals in <maxnvp>         ***
C**                    row blocks.                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1996                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include    'const.h'
      integer    ia1,ivt,nvt,nproc,myproc,nmsg,ierr,lout,maxnvp,cachln
      integer    info(ia1,ia2),tid(nproc),lmatbk(nproc),
     *           ptrmbk(nproc+1),ptrinf(ntyp+1,nproc)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   Arrays info(ia1,ia2),tid(nproc),lmatbk(nproc),ptrmbk(nproc+1) ***
C**   Variables ia1,ia2,nproc,myproc,nmsg,ierr:                     ***
C**              see Manual-Pages <linsol>                          ***
C**                                                                 ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ivt    I  I   I in  I  number of vector term to separate
C        I      I     I  Note: it can vary on different processors
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer    i,iwork,iermax,iar,iarend,nvtmin
      integer    adda,glvt,s_addr,s_ptr,e_ptr,iac
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ierr = 0
      adda = info(ivt,2)
      iac  = info(ivt,4)
      iar  = info(ivt,5)

      info(ivt,6) = 0
      do 5 i=1,nproc
        if ((ivt .gt. ptrinf(2,i)) .and. (ivt .le. ptrinf(3,i))) then
	  info(ivt,7) = 10000*i
        endif
    5 continue

      do 10 i=maxnvp,1,-1
        glvt = info(ivt,3)
        iarend = iar+glvt
	s_ptr = ptrmbk(myproc)+(i-1)*cachln
	if (i .eq. maxnvp) then
	  e_ptr = ptrmbk(myproc)+lmatbk(myproc)
	else
	  e_ptr = ptrmbk(myproc)+i*cachln
	endif
	if (iar .lt. s_ptr) then
	  if (iarend .gt. s_ptr) then
	    nvt     = nvt+1
	    nvtmin  = min(nvt,ia1)
c           if (nvt .gt. ia1) then
c             ierr = 8020+myproc
c             write(lout,1000)
c             write(lout,1010) myproc
c             write(lout,1020)
c             goto 999
c           endif
	    s_addr  = s_ptr-iar
            info(nvtmin,1) = info(ivt,1)
            info(nvtmin,2) = adda+s_addr
            info(nvtmin,4) = iac+s_addr
            info(nvtmin,5) = s_ptr
            info(nvtmin,7) = info(ivt,7)+i
	    if (iarend .le. e_ptr) then
	      info(nvtmin,3) = iarend-s_ptr
            else
	      ierr = 8020+myproc
              write(lout,1000)
              write(lout,1030) myproc
              write(lout,1020)
	      goto 999
            endif
	    info(ivt,3) = glvt-info(nvtmin,3)
          endif
        endif
	if ((iar .ge. s_ptr) .and. (iarend .le. e_ptr)) then
	  info(ivt,7) = info(ivt,7)+i
        endif
   10 continue

  999 call LL4INM(1,1,1,ierr,iermax,iwork,myproc,nproc,tid,nmsg)
      if (iermax .gt. 0) then
        ierr = iermax
        if (myproc .eq. 1) then
          write(lout,1000)
          write(lout,1030) iermax-8020
          write(lout,1020)
        endif
      endif


 1000 format(' **********************************************'/
     &       ' ***  Error occured in LINSOL (LL8SR2):     ***')
c1010 format(' ***   First dimension of array <info> is   ***'/
c    &       ' ***   too small on processor ',i6,'        ***')
 1020 format(' **********************************************')
 1030 format(' ***   LL8SR2: Implementation error         ***'/
     &       ' ***           on processor ',i6,'          ***')
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL8SR2---------------------------------------------------
      e    n    d
