C:::::      ,,,,,LL8SR6.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8SR6(mat,index,rbuf,ibuf,l,lmat,lindex,info,nvt,
     #                  ivt,ia1,lmatbk,ptrmbk,ptrinf,maxnvp,
     #                  cachln,myproc,nproc,tid,nmsg,lout,idoku,ierr)
C**                                                                 ***
C**                                                                 ***
C**      (ibuf must be greater or equal 4*l)                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 S R 6   separates  "starry sky" patterns in <maxnvp> ***
C**                    row blocks.                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1996                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include    'const.h'
      integer    lmat,lindex,ia1,ivt,nvt,nproc,myproc,maxnvp,cachln,
     *           nmsg,ierr,l,lout,idoku
      integer    info(ia1,ia2),index(lindex),tid(nproc),lmatbk(nproc),
     *           ptrmbk(nproc+1),ptrinf(ntyp+1,nproc),ibuf(4*l)
C**                                                                 ***
      double precision   mat(lmat),rbuf(2*l)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   Arrays mat(lmat),info(ia1,ia2),tid(nproc),lmatbk(nproc),      ***
C**          ptrmbk(nproc+1) and                                    ***
C**   Variables lmat,ia1,ia2,nproc,myproc,nmsg,ierr,l:              ***
C**              see Manual-Pages <linsol>                          ***
C**                                                                 ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ivt    I  I   I in  I  number of vector term to separate
C        I      I     I  Note: it can vary on different processors
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer    i,j,j1,j2,k,iwork,iermax,iar,indr,indc,nvtmin
      integer    adda,glvt,s_addr,s_ptr,iac,nvtold
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ierr = 0
      nvtold = nvt
      adda = info(ivt,2)
      info(ivt,4) = 0
      do 4 i=1,nproc
        if ((ivt .gt. ptrinf(6,i)) .and. (ivt .le. ptrinf(7,i))) then
          info(ivt,5) = 10000*i
        endif
    4 continue
      indc = info(ivt,6) 
      indr = info(ivt,7) 

      do 10 i=maxnvp,1,-1
        glvt = info(ivt,3)
        s_ptr = ptrmbk(myproc)+(i-1)*cachln
	j = 0
        do 5 k=1,glvt
          if (index(indr+k) .gt. s_ptr) then
	    j = j+1
          endif
    5   continue

	if ((j .gt. 0) .and. (j .lt. glvt)) then
	  nvt = nvt+1
	  nvtmin = min(nvt,ia1)
c         if (nvt .gt. ia1) then
c           ierr = 8060+myproc
c           write(lout,1000)
c           write(lout,1010) myproc
c           write(lout,1020)
c           goto 999
c         endif
	  j1 = 0
	  j2 = 0
          do 12 k=1,glvt
	    if (index(indr+k) .le. s_ptr) then
              j1 = j1+1
	      ibuf(j1) = index(indc+k)
	      ibuf(l+j1) = index(indr+k)
	      rbuf(j1) = mat(adda+k)
            else
	      j2 = j2+1
	      ibuf(2*l+j2) = index(indc+k)
	      ibuf(3*l+j2) = index(indr+k)
	      rbuf(l+j2) = mat(adda+k)
            endif
   12     continue
          do 14 k=1,glvt
	    if (k .le. j1) then
	      index(indc+k) = ibuf(k) 
	      index(indr+k) = ibuf(l+k) 
	      mat(adda+k) = rbuf(k) 
            else
	      index(indc+k) = ibuf(2*l+k-j1) 
	      index(indr+k) = ibuf(3*l+k-j1) 
	      mat(adda+k) = rbuf(l+k-j1) 
            endif
   14     continue
          info(nvtmin,1) = info(ivt,1)
          info(nvtmin,2) = adda+j1
          info(nvtmin,4) = 0
          info(nvtmin,5) = info(ivt,5)+i
          info(nvtmin,6) = indc+j1
          info(nvtmin,7) = indr+j1
	  if (j .eq. j2) then
	    info(nvtmin,3) = j2
          else
	    ierr = 8060+myproc
            write(lout,1000)
            write(lout,1030) myproc
            write(lout,1020)
	    goto 999
          endif
	  info(ivt,3) = glvt-info(nvtmin,3)
        endif
	if (j .eq. glvt) then
          info(ivt,5) = info(ivt,5)+i
        endif
   10 continue

  999 call LL4INM(1,1,1,ierr,iermax,iwork,myproc,nproc,tid,nmsg)
      if (iermax .gt. 0) then
	ierr = iermax
	if (myproc .eq. 1) then
          write(lout,1000)
          write(lout,1030) iermax-8060
          write(lout,1020)
        endif
      endif

      if (idoku .gt. 0) then
        if (myproc .eq. 1) write(lout,1040) nvt-nvtold
      endif
      if (idoku .lt. 0) then
        write(lout,1040) nvt-nvtold
      endif


 1000 format(' **********************************************'/
     &       ' ***  Error occured in LINSOL (LL8SR6):     ***')
c1010 format(' ***   First dimension of array <info> is   ***'/
c    &       ' ***   too small on processor ',i6,'        ***')
 1020 format(' **********************************************')
 1030 format(' ***   LL8SR6: Implementation error         ***'/
     &       ' ***           on processor ',i6,'          ***')
 1040 format('    --> ',i6,' additional <starry skies> are created')

C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL8SR6---------------------------------------------------
      e    n    d
