C:::::      ,,,,,LL8SC7.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL8SC7(mat,l,lmat,info,nvt,ivt,ia1,
     #                  lmatbk,ptrmbk,myproc,nproc,tid,nmsg,lout,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 8 S C 7   separates full rows in <nproc>               ***
C**                    column blocks.                               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1995                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include    'const.h'
      integer    lmat,ia1,ivt,nvt,nproc,myproc,
     *           nmsg,ierr,l,lout
      integer    info(ia1,ia2),tid(nproc),lmatbk(nproc),
     *           ptrmbk(nproc+1)
C**                                                                 ***
      double precision   mat(lmat)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   Arrays mat(lmat),info(ia1,ia2),tid(nproc),lmatbk(nproc),      ***
C**          ptrmbk(nproc+1) and                                    ***
C**   Variables lmat,ia1,ia2,nproc,myproc,nmsg,ierr,l:              ***
C**              see Manual-Pages <linsol>                          ***
C**                                                                 ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C ivt    I  I   I in  I  number of vector term to separate
C        I      I     I  Note: it can vary on different processors
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer    i,j,k,iwork,iermax,iar,iacend
      integer    adda,glvt,s_addr,iac
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      ierr = 0
      adda = info(ivt,2)
      iac  = info(ivt,4)
      iar  = info(ivt,5)
      info(ivt,6) = 0
      info(ivt,7) = 0

      do 10 i=nproc,1,-1
        glvt = info(ivt,3)
        iacend = iac+glvt
	if (iac .lt. ptrmbk(i)) then
	  if (iacend .gt. ptrmbk(i)) then
	    nvt = nvt+1
	    if (nvt .gt. ia1) then
	      ierr = 8070+myproc
              write(lout,1000)
              write(lout,1010) myproc
              write(lout,1020)
	      goto 999
	    endif
	    s_addr  = ptrmbk(i)-iac
            info(nvt,1) = 7
            info(nvt,2) = adda+s_addr
            info(nvt,4) = ptrmbk(i)
            info(nvt,5) = iar
            info(nvt,6) = 0
            info(nvt,7) = 0
	    if (iacend .le. ptrmbk(i)+lmatbk(i)) then
	      info(nvt,3) = iacend-ptrmbk(i)
            else
	      ierr = 8070+myproc
              write(lout,1000)
              write(lout,1030) myproc
              write(lout,1020)
	      goto 999
            endif
	    info(ivt,3) = glvt-info(nvt,3)
          endif
        endif
   10 continue

  999 call LL4INM(1,1,1,ierr,iermax,iwork,myproc,nproc,tid,nmsg)
      if (iermax .gt. 0) then
	ierr = iermax
	if (myproc .eq. 1) then
          write(lout,1000)
          write(lout,1010) iermax-8070
          write(lout,1020)
        endif
      endif


 1000 format(' **********************************************'/
     &       ' ***  Error occured in LINSOL (LL8SC7):     ***')
 1010 format(' ***   First dimension of array <info> is   ***'/
     &       ' ***   too small on processor ',i6,'        ***')
 1020 format(' **********************************************')
 1030 format(' ***   LL8SC7: Implementation error         ***')
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL8SC7---------------------------------------------------
      e    n    d
