C:::::      ,,,,,LL9INM.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LL9INM(hterm,maxnrm,l)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L L 9 I N M   performs the computation of the local        ***
C**                    maximum norm.                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
c**      PROGRAMMER:    H. Haefner                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include "bytes.h"
      integer l
      integer hterm(l/iint),maxnrm(l/iint)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C hterm  I  I   I in  I  helpwise term
C--------I------I-----I------------------------------------------------
C maxnrm I  I   I out I  computed maximum norm   array: maxnrm(l/iint)
C--------I------I-----I------------------------------------------------
C l      I  I   I in  I  length of the above mentioned arrays
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                                                                 ***
C**        LOCAL PARAMETERS :                                       ***
C**        ----------------                                         ***
C**                                                                 ***
      integer i
C**                                                                 ***
C----------------------------------------------------------------------
C
C
C**** START OF CALCULATION :
C     ---------------------
C
      do 10 i=1,l/iint
        maxnrm(i)=max(maxnrm(i),hterm(i))
 10   continue
 
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL9INM---------------------------------------------------
      e    n    d
