C:::::      ,,,,,LL9MAP...
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      integer function LL9MAP(proc,nproc)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     LL9MAP   sets <proc> to the logical process(or) id for a    ***
C**              ring of <nproc> processors.                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      COPYRIGHT UNIVERSITAET KARLSRUHE, 1994                     ***
C**      PROGRAM  BY L. GROSS                                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      integer           proc,nproc
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C NAME   I TYPE I I/O I     MEANING
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C proc   I   I  I i/o I  logical process(or) id
C--------I------I-----I------------------------------------------------
C nproc  I   I  I in  I  number of processes (processors)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      integer        h,r
C
C
C**** START OF CALCULATION
C     --------------------
C
      if (proc.gt.0) then
        h = (proc-1)/nproc
        r = proc-h*nproc
      else
        h = proc/nproc-1
	r = proc-h*nproc
      endif

      LL9MAP = r
C
C
C**** END OF CALCULATION
C     ------------------
C
      r e t u r n
C-----END OF LL9MAP----------------------------------------------------
      e    n    d
