C:::::      ,,,,,LSOLPP.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      subroutine LSOLPP(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     &                  lsym,ia1,info,mat,prec,x,b,dw,iprec,
     &                  index,iw,ilin,lmatbk,ptrinf,tid,
     &                  epslin,iconv,ierr)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      L S O L P P   LINSOL-MAIN-PROGRAM for physically and       ***
C**                    logically distributed matrices               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1996        ***
C**     PROGRAMMER: H. Haefner                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
C**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
C**                                                                 ***
      implicit none
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      FORMAL PARAMETERS :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
      include           'const.h'
      integer           lmat,lprec,liprec,lindex,l,ldw,liw,ia1,
     #                  iconv,ierr,nproc
      double precision  mat(lmat),prec(lprec),x(l),b(l),dw(ldw),
     #                  epslin
      integer
     #                  index(lindex),info(ia1,ia2),
     #                  iw(liw),ilin(nilin),lmatbk(nproc),
     #                  ptrinf(ntyp+1,nproc),tid(nproc),iprec(liprec)
      logical           lsym
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   LIST OF FORMAL PARAMETERS :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C**   (see Manual-Pages <linsol>)                                   ***
C**                                                                 ***
C**                                                                 ***
C**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
C**                                                                 ***
      include            'cache.h'
      include            'maxnpe.h'
      integer            ptrmbk(maxnpe+1),jump(maxnpe)
      integer            j,i,ione,lout,ms,ilin16,idoku,imvm,nmsg,nvt,
     &                   ibcom,lmyblk,myproc,maxnvp,cachln,ivt,nvtold,
     &                   ityp,ihelp,iermax,optim
      integer            ibAx,ibAtx,ibPLb,ibborg,ibplbg,ibNb,ibxorg
      logical            ladd,lsym2
      double precision   LL8EPS,one,zero
      double precision   bmax,eps,help,rseucn,rpoly

      common /norms/ rseucn,rpoly(3),lsym2
C**                                                                 ***
      parameter (one = 1.0, zero=0.0, ione=1)
C
      external LL6AX,LL6ATX
C
C**** START OF CALCULATION :
C     ---------------------
C
C**
C***  SET POINTERS
C**
      ibAx  =1
      ibAtx =l+1
      ibPLb =2*l+1
      ibcom =3*l+1

      ibxorg=1+1*l
      ibborg=1+2*l
      ibplbg=1+3*l
      ibNb  =1+4*l
C
C
      lout = ilin(12)
C
      ladd = .false.

      rseucn   = zero
      rpoly(1) = zero
      rpoly(2) = zero
      rpoly(3) = zero

      ierr   = 0
c**
      if (lout .lt. 0) then
	 ierr = 0001
	 write(*,1000)
	 write(*,1001)
	 write(*,1002)
	 write(*,1020)
	 write(*,1035)
	 write(*,1021)
	 write(*,1030)
         goto 999
      endif
c**
      include 'nprocs.h'
      if (nproc .eq. 1) then
        ilin(17) = 1
      endif
c**
      if ((ilin(13) .gt. 0) .and. (ilin(17) .eq. 1)) then
        write(lout,1000)
        write(lout,1001)
        include 'nproc.h'
        write(lout,1002)
      endif
      if (ilin(13) .lt. 0) then
        write(lout,1000)
        write(lout,1001)
        include 'nproc.h'
        write(lout,1002)
      endif

      nvt = 0
      do 2 i=1,nproc
	nvt = max(ptrinf(ntyp+1,i),nvt)
   2  continue

c**
c***  CHECK OF PARAMETERS CONCERNING MATRIX AND NUMBER OF PROC.
c**
      call LL8CK1(nproc,nvt,ia1,ilin,ierr,tid)
      if (ierr .ne. 0) then
	 iconv = 4
         if (ilin(17) .eq. 1) then
	    write(lout,1020)
	    write(lout,1021)
	    write(lout,1030)
         endif
	 goto 999 
      endif
C**                                                                 ***
C**   CHECK OF PARAMETERS CONCERNING CG - METHOD                    ***
C**                                                                 ***
      call LL8CK2(l,ldw,liw,ilin,iconv,ierr,nproc,tid)
      if (ierr .ne. 0) then
	 iconv = 4
         if (ilin(17) .eq. 1) then
	    write(lout,1020)
	    write(lout,1021)
	    write(lout,1030)
         endif
	 goto 999
      endif
C**                                                                 ***
C**   CHECK OF GLOBAL LINSOL-PARAMETERS                             ***
C**                                                                 ***
      if (nproc .gt. 1) then
        call LL8CK3(l,liw,nproc,lsym,ilin,iw,lmatbk,tid,epslin,ierr)
        if (ierr .ne. 0) then
          iconv = 4
          if (ilin(17) .eq. 1) then
            write(lout,1020)
            write(lout,1021)
            write(lout,1030)
          endif
          goto 999
        endif
      endif
c**
c***
c**
      eps  = LL8EPS(one * 1.e-10)

      if (ilin(1) .eq. 9) then
	 lsym = .false.
	 if (ilin(15) .ge. 11) then
	    ilin(15) = ilin(15) - 10
         endif
      endif

      if (nproc .eq. 1) then
	ilin(3)   = 0
	lmatbk(1) = l
	jump(1)   = 1
	tid(1)    = 9999
      endif

      nmsg   = ilin(3)
      idoku  = abs(ilin(13))
      ilin16 = ilin(16)
      myproc = ilin(17)
      optim  = ilin(20)
      lmyblk = lmatbk(myproc)

      ptrmbk(1) = 0
      do 3 i=1,nproc
        ptrmbk(i+1) = ptrmbk(i)+lmatbk(i)
    3 continue
      do 4 i=nproc+1,maxnpe
        ptrmbk(i+1) = 0
    4 continue
      ilin(10) = 0
      imvm     = 0
      ms       = 0

C**                                                                 ***
C***  PRINT, IF INITIAL GUESS IS USED                               ***
C**                                                                 ***
      if (ilin(16) .eq. 4711) then
        if (ilin(13) .gt. 0) then 
          if (myproc .eq. 1) write(lout,1101)
        endif
        if (ilin(13) .lt. 0) then 
          write(lout,1101)
        endif
      endif

C**                                                                 ***
C***  CREATE JUMP-VECTOR                                            ***
C**                                                                 ***
      if (nproc .gt. 1) then
        call LL4JMP(jump,ptrinf,iw,liw,lsym,myproc,nproc,tid,nmsg)
      endif

C**                                                                 ***
C***  CACHE REUSE, IF ILIN(20) == 100 (200)                         ***
C**                                                                 ***
      if (mod(optim,1000) .ge. 100) then
        if (ilin(13) .gt. 0) then 
	  if (optim .eq. 100) then
            if (myproc .eq. 1) write(lout,1104)
	  endif
	  if (optim .eq. 200) then
            if (myproc .eq. 1) write(lout,1105)
	  endif
        endif
        if (ilin(13) .lt. 0) then 
          if (ilin(20) .eq. 100) write(lout,1104)
          if (ilin(20) .eq. 200) write(lout,1105)
        endif

        if (4*l .le. cachsz) goto 111
	maxnvp = 4*l/cachsz
	if (mod(4*l,cachsz) .ne. 0) maxnvp = maxnvp+1

        if (ilin(13) .gt. 0) then 
          if (myproc .eq. 1) write(lout,1106) maxnvp
        endif
        if (ilin(13) .lt. 0) then 
          write(lout,1106) maxnvp
        endif

	cachln = l/maxnvp
	if (mod(l,maxnvp) .ne. 0) cachln = cachln+1
	nvtold = nvt
	do 10 ivt=1,nvtold
	  ityp = info(ivt,1)
	  if (ityp .eq. 2 .or. ityp .eq. 20) then
            call LL8SR2(info,nvt,ivt,ia1,lmatbk,ptrmbk,ptrinf,
     &                  maxnvp,cachln,myproc,nproc,tid,nmsg,lout,ierr)
          endif
	  if (ityp .eq. 3 .or. ityp .eq. 30) then
           call LL8SR3(index,lindex,info,nvt,ivt,ia1,lmatbk,
     &     ptrmbk,ptrinf,maxnvp,cachln,myproc,nproc,tid,nmsg,lout,ierr)
          endif
	  if ((ityp .eq. 6 .or. ityp .eq. 60)
     &        .and. mod(optim,1000) .eq. 200) then
            call LL8SR6(mat,index,dw,iw,l,lmat,lindex,info,nvt,
     &                  ivt,ia1,lmatbk,ptrmbk,ptrinf,maxnvp,
     &                  cachln,myproc,nproc,tid,nmsg,lout,ierr)
          endif
   10   continue

        if (ilin(13) .gt. 0) then 
          if (myproc .eq. 1) write(lout,1107) nvt-nvtold
        endif
        if (ilin(13) .lt. 0) then 
          write(lout,1107) nvt-nvtold
        endif
        if (nvt .gt. nvtold) then
          if (nvt .gt. ia1) then
            ierr = 0002+myproc
          endif
          call LL4INM(1,1,1,ierr,iermax,ihelp,myproc,nproc,tid,nmsg)
	  if (iermax .gt. 0) then
	    ierr = iermax
	    if (myproc .eq. 1) then
              write(lout,1020)
              write(lout,1024) ia1,nvt,iermax-0002
              write(lout,1030)
            endif
	    goto 999
          endif
          if (liw .lt. nvt*ia2) then
            ierr = 0003+myproc
          endif
          call LL4INM(1,1,1,ierr,iermax,ihelp,myproc,nproc,tid,nmsg)
	  if (iermax .gt. 0) then
	    ierr = iermax
	    if (myproc .eq. 1) then
              write(lout,1020)
              write(lout,1025) liw,nvt*ia2,iermax-0003
              write(lout,1030)
            endif
	    goto 999
          endif
          call LL8IRS(index,lindex,info,ia1,ptrinf,iw,liw,nproc,maxnvp,
     &                nvtold,nvt,myproc,tid,nmsg,optim,lout,ierr)
        endif
	if (ierr .gt. 0) goto 999
      endif

  111 continue

C**                                                                 ***
C***  PRINTING OF VECTOR TERMS ON UNIT <ILIN(21)>                   ***
C**                                                                 ***
      if (mod(ilin(19),10) .eq. 1) then
        if (ilin(13) .gt. 0) then 
          if (myproc .eq. 1) write(lout,1108) ilin(21)
        endif
        if (ilin(13) .lt. 0) then 
          write(lout,1108) ilin(21)
        endif
        call SHOWVT(lmat,lindex,l,nproc,lsym,ia1,
     &              info,mat,index,lmatbk,ptrmbk,ierr,
     &              myproc,nvt,ilin(21))
      endif

C**                                                                 ***
C***  STORE THE MATRIX <MAT> IN LINSOL-FORMAT ON UNIT <ILIN(23)>    ***
C**                                                                 ***
      if (mod(ilin(19),10000) .ge. 1000) then
        if (ilin(13) .gt. 0) then 
          if (myproc .eq. 1) write(lout,1109) ilin(23)
        endif
        if (ilin(13) .lt. 0) then 
          write(lout,1109) ilin(23)
        endif
        call LINOUT(l,mat,lmat,index,lindex,lsym,info,ia1,nvt,ilin,
     &              ilin(23),ierr)
      endif

C**
C***  STORE THE ORIGINAL INITIAL GUESS
C**
      if (ilin(16) .eq. 4711) then
      include "norec.h"
        do 5 i=1,l
          prec(ibxorg+i-1) = x(i)
    5   continue
      else
      include "norec.h"
        do 6 i=1,l
          prec(ibxorg+i-1) = zero
    6   continue
      endif
C**
C***  STORE THE ORIGINAL RIGHT_HAND_SIDE (RHS)
C**
      include "norec.h"
      do 15 i=1,l
        prec(ibborg+i-1) = b(i)
   15 continue
C**                                                                 ***
C***  NORMALIZATION                                                 ***
C**                                                                 ***
      call LL1NRM(lmat,lprec,lindex,l,ldw,liw,nproc,
     &            lsym,ia1,info,mat,prec,x,b,dw,index,iw,
     &            ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     &            iconv,ierr)
      if (iconv .eq. 4) then
         if (ilin(17) .eq. 1) then
	    write(lout,1020)
	    write(lout,1022)
	    write(lout,1030)
         endif
	 goto 999
      endif
C
  222 continue

      if ((ilin(16).eq.4711) .and. (iconv.eq.5)) then
        if ((ms .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
      include "norec.h"
          do 9 i = 1,lmyblk
             x(i) = prec(i) * x(i)
    9     continue
        endif
      include "norec.h"
        do 7 i = 1,lmyblk
          x(i) = x(i) + prec(ibxorg+i-1)
    7   continue
      include "norec.h"
        do 8 i=1,l
          prec(ibxorg+i-1) = x(i)
    8   continue
        if ((ms .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
      include "norec.h"
          do 11 i = 1,lmyblk
             x(i) = x(i) / prec(i)
   11     continue
        endif
      endif

      if (iconv .eq. 5) then
      include "norec.h"
        do 16 i=1,l
          b(i) = prec(i)*prec(ibborg+i-1)
   16   continue
      endif
	
      if (ilin(16) .eq. 4711) then
        if (ilin(1) .eq. 9) then
          call LL3ATX(LL6ATX,mat,x,dw(ibAtx),dw(ibcom),ptrmbk,lmatbk,
     #                ptrinf,l,nproc,tid,myproc,jump,
     #                ladd,lmat,lindex,ia1,info,index,nmsg)
          imvm  = imvm  + 1
        endif
        if (ilin(1) .ne. 9) then
         do 24 i = 1,l
           dw(ibAtx+i-1) = x(i)
   24    continue
        endif
	if (lsym) then
          call LL3ASX(mat,dw(ibAtx),dw(ibAx),dw(ibcom),ptrmbk,
     #                lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #                ladd,lmat,lindex,ia1,info,index,nmsg)
        else
	  call LL3AX(LL6AX,mat,dw(ibAtx),dw(ibAx),dw(ibcom),ptrmbk,
     #               lmatbk,ptrinf,l,nproc,tid,myproc,jump,
     #               ladd,lmat,lindex,ia1,info,index,nmsg)
	endif
        imvm  = imvm  + 1
      include "norec.h"
        do 25 i = 1,lmyblk
          b(i) = b(i) - dw(ibAx+i-1)
   25   continue
      endif
C**
C***  STORE  N * RHS
C**
      include "norec.h"
      do 26 i=1,l
        prec(ibNb+i-1) = b(i)
   26 continue
C**                                                                 ***
C***  PRECONDITIONING                                               ***
C**                                                                 ***
      if (iconv .ne. 5) then
       if ((ilin(8) .ge. 31) .and. (ilin(8) .le. 90)) then
        call LL1PRE(lmat,lprec,liprec,lindex,l,ldw,liw,nproc,
     &              lsym,ia1,info,mat,prec,x,b,dw,iprec,index,iw,
     &              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,myproc,
     &              iconv,ierr)
        if (iconv .eq. 4) goto 999
       endif
      endif

C**                                                                 ***
C***  IF MAXIMUM OF B = 0, THEN THE SOLUTION IS THE INITIAL GUESS   ***
C**                                                                 ***
      call LL4RNM(lmyblk,ione,l,b,bmax,help,myproc,nproc,tid,nmsg)
      if (bmax .eq. zero) then
         do 53 i = 1,l
           x(i) = prec(ibxorg+i-1)
   53    continue
         iconv=1
	 if (ilin(13) .ge. 0) then 
	    if (myproc .eq. 1) then
	       write(lout,1110)
	       write(lout,1120)
            endif
         else
	    write(lout,1110)
	    write(lout,1120)
         endif
         goto 999
      endif
       
C**
C***  IF PL <> I ==>  PL * b is computed
C**
      if(mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then 
        imvm  = imvm  + 1
	call LL3AX(LL6AX,prec(iprec(7)+1),b,dw(ibPLb),dw(ibcom),
     #             ptrmbk,lmatbk,iprec(iprec(11)+1),l,nproc,tid,
     #             myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #             iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
 
      include "norec.h"
        do 35 i = 1,lmyblk
          b(i) = dw(i+ibPLb-1)
   35   continue
      endif
C**
C***  IF PL <> I and noprec == 0  ==>  PL*N*borg  is computed
C**
      if (ilin(9) .eq. 0 .and. iconv .ne. 5) then
      include "norec.h"
        do 36 i=1,lmyblk
          dw(ibPLb+i-1) = prec(i) * prec(ibborg+i-1)
   36   continue

        if(mod(ilin(8),3) .ne. 2 .and. ilin(8) .ne. 0) then 
          imvm  = imvm  + 1
	  call LL3AX(LL6AX,prec(iprec(7)+1),dw(ibPLb),prec(ibplbg),
     #               dw(ibcom),ptrmbk,lmatbk,iprec(iprec(11)+1),l,
     #               nproc,tid,
     #               myproc,jump,ladd,iprec(1),iprec(2),iprec(3),
     #               iprec(iprec(10)+1),iprec(iprec(9)+1),nmsg)
	else
        include "norec.h"
          do 38 i=1,lmyblk
            prec(ibplbg+i-1) = dw(ibPLb+i-1)
   38     continue
        endif
      endif
 
C**                                                                 ***
C**   METHOD SELECTION                                              ***
C**                                                                 ***

      call LL8MS(ilin(1),ms,lsym,iconv)
 
      if (ms.eq.1) then
        call LL1P20(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
         go to 333
      endif
      if (ms.eq.2 .or. ms.eq.6) then
        call LL1BCO(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              ms,eps,epslin,iconv,ierr)
        go to 333
      endif
      if (ms.eq.3) then
        call LL1CGB(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
        go to 333
      endif
      if (ms.eq.4) then
        call LL1ATP(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
        go to 333
      endif
      if (ms.eq.5) then
        call LL1CGS(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
        go to 333
      endif
      if (ms.eq.7) then
        call LL1GME(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
        go to 333
      endif
      if (ms.eq.9) then
        call LL1CGT(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
        go to 333
      endif
      if (ms.eq.20) then
        call LL1TST(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #              mat,prec,x,b,
     #              iprec,index,ia1,info,dw,iw,
     #              ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #              eps,epslin,iconv,ierr)
        go to 333
      endif

      if (ms.eq.123) then
        call LL1CG(ldw,liw,lmat,lprec,liprec,lindex,l,lsym,nproc,
     #             mat,prec,x,b,
     #             iprec,index,ia1,info,dw,iw,
     #             ilin,lmatbk,ptrmbk,ptrinf,jump,tid,
     #             eps,epslin,iconv,ierr)
        go to 333
      endif
 
  333 continue
 
      if (ilin(18) .eq. 0) then
	if (ilin(13) .lt. 0) write(lout,1103)
	if (ilin(13) .gt. 0) then
	  if (myproc .eq. 1) write(lout,1103)
        endif
      else
	if (ilin(13) .lt. 0) write(lout,1102)
	if (ilin(13) .gt. 0) then
	  if (myproc .eq. 1) write(lout,1102)
        endif
      endif
C
C     IF NO CONVERGENCE SEARCH FOR NEW METHOD
C
      if (iconv .ge. 5) then
	ilin(16) = 4711
	goto 222
      endif
C
      if ((ms .eq. 9) .or. lsym .or. (ilin(15) .gt. 10)) then
        do 65 i = 1,lmyblk
           x(i) = prec(i) * x(i)
   65   continue
      endif

C      
C     COMPUTATION OF THE SOLUTION X     
C      
      if (ilin(16) .eq. 4711) then
         do 75 i = 1,lmyblk
            x(i) = x(i) + prec(ibxorg+i-1)
   75    continue
      endif
      
      include "norec.h"
      do 85 i = 1,l
        b(i) = prec(ibborg+i-1)
   85 continue

  999 ilin(16)=ilin16
      ilin(3) = nmsg
C
C
C**** END OF CALCULATION
C     ------------------
C
 1000 format(' xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')
 1001 format(' X      L S O L P P - Version 0.99 (25.06.96)        X')
 1003 format(' X       installed on a NON-PARALLEL computer        X')
 1004 format(' X       installed on a PARALLEL computer            X')
 1002 format(' xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')
 1020 format(' ****************************************'/
     &       ' ***  Error occured in LSOLPP:        ***')
 1021 format(' ***   check input parameters!        ***')
 1022 format(' ***   Normalization failed!          ***')
 1024 format(' ***   <ia1> is ',i6,', but must be   ***'/
     &       ' ***   greater than ',i6,' on process ***'/
     &       ' ***   ',i6,' for cache reuse         ***')
 1025 format(' ***   <liw> is ',i6,', but must be   ***'/
     &       ' ***   greater than ',i6,' on process ***'/
     &       ' ***   ',i6,' for cache reuse         ***')
 1030 format(' ****************************************')
 1035 format(' ***   Output unit number LOUT has    ***'/
     &       ' ***   to be greater than zero.       ***')
 1101 format('    Initial guess used')
 1102 format('    Smoothed solution used')
 1103 format('    Original solution used')
 1104 format('    Safe cache reuse switched on')
 1105 format('    Unsafe cache reuse switched on')
 1106 format('    Matrix is subdivided logically into ',i6,' blocks')
 1107 format('    --> ',i6,' additional vector terms are created')
 1108 format('    Vector terms are checked and printed on unit ',i3)
 1109 format('    Matrix (part) is printed on unit ',i6)
 1110 format('    All elements of the right hand side are zero!')
 1120 format('    Solution is the initial guess!')
      r e t u r n
C-----END OF LSOLPP----------------------------------------------------
      e    n    d
