C:::::      ,,,,,PAVE01...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE PAVE01 (UNITIN,GNDEG,GNE,GROUP,NGROUP,TOTNE,NK,COMP6,
     &                   GNDC,MYPROC,LOUT,OUTCNT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    PAVE01     statistic of a PATRAN neutral file                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**               >                                                 ***
      INTEGER      UNITIN,GNDEG,NGROUP,TOTNE,GNDC,MYPROC,
     &             LOUT,OUTCNT,ERR,NK,COMP6
      INTEGER      GNE(0:3,8,32),GROUP(0:3,8,32)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of neutral file
C--------I------I-----I------------------------------------------------
C GNDEG  I  I   I out I global number of geometrical nodes
C--------I------I-----I------------------------------------------------
C GNE    I  I   I out I GNE(CLASS,FORM,GEOTYP) number of elements
C        I      I     I element type (CLASS,FORM,GEOTYP)
C        I      I     I                           array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C GROUP  I  I   I out I GROUP(CLASS,FORM,GEOTYP) is the group id of
C        I      I     I element type (CLASS,FORM,GEOTYP)
C        I      I     I                            array: GNE(0:3,8,32)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I out I number of groups (including node forces)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I out I total number of element (including node forces)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C COMP6  I  I   I in  I <>0  the constrain set id defines the component
C        I      I     I      for which the constrain set nodes have to be
C        I      I     I      interpreted as dirichlet conditions
C--------I------I-----I------------------------------------------------
C GNDC   I  I   I out I number of nodes with dirichlet conditions
C        I      I     I and different constrain id.
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I logical process id
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I >0 a protocol is printed
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code =0 no error
C        I      I     I            =99 read error
C        I      I     I            =96 illegal element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include           "bytes.h"
      INTEGER           I,IT,SHAPE,CLASS,FORM,GEOTYP,NCARD,
     &                  ID,IV,KC,N1,N2,N3,N4,N5
      DOUBLE PRECISION  X1,X2,X3
      CHARACTER*80      TITLE,RECORD
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 10 CLASS=0,3
        DO 10 FORM=1,8
          DO 10 GEOTYP=1,32
	    GROUP(CLASS,FORM,GEOTYP)=0
 10         GNE(CLASS,FORM,GEOTYP)=0
      GNDC=0
      GNDEG=0
      IF (OUTCNT.GT.0) WRITE(LOUT,9000)
      ERR=0
      NCARD=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** look to the data set type:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
100   READ(UNITIN,'(I2,8I8)',ERR=9999,END=8888) IT,ID,IV,KC,
     &                                             N1,N2,N3,N4,N5
      NCARD=NCARD+1
      IF (IT.EQ.25) GOTO 1000
      IF (IT.EQ.1) GOTO 2000
      IF (IT.EQ.2) GOTO 3000
      IF (IT.EQ.7) GOTO 4000
      IF (IT.EQ.8) GOTO 5000
      IF (IT.EQ.99) GOTO 8888
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read remainder card in the data packet:                       ***
C**   --------------------------------------                        ***
C**                                                                 ***
7000  CONTINUE
      DO 7010 I=1,KC
        READ(UNITIN,'(80A)',ERR=9999,END=9999) RECORD
7010    NCARD=NCARD+1
      GOTO 100
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read the title:                                               ***
C**   --------------                                                ***
C**                                                                 ***
1000  READ (UNITIN,'(80A)',ERR=9999,END=9999) TITLE
      NCARD=NCARD+1
      IF (OUTCNT.GT.0) WRITE(LOUT,9005) TITLE
      KC=KC-1
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** node data (Packet Type 1) :                                   ***
C**   ------------------------                                      ***
C**                                                                 ***
2000  GNDEG=GNDEG+1
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** element data (Packet Type 2):                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
3000  SHAPE=IV
      READ(UNITIN,'(4I8,3E16.9)',ERR=9999,END=9999) GEOTYP,
     &                                             N1,N2,N3,X1,X2,X3
      NCARD=NCARD+1
      KC=KC-1
      CALL PAVE10(SHAPE,CLASS,FORM,GEOTYP)
      IF (CLASS.LT.0) THEN
	ERR=96
	WRITE(LOUT,9120) NCARD,SHAPE,NCARD
      ELSE
	GNE(CLASS,FORM,GEOTYP)=GNE(CLASS,FORM,GEOTYP)+1
      ENDIF
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** node forces (Packet Type 7):                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
4000  GNE(0,1,1)=GNE(0,1,1)+1
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Dirichlet conditions (Packet Type 8) :                        ***
C**   ------------------------------------                          ***
C**                                                                 ***
5000  CONTINUE
      IF (COMP6.NE.0) THEN
        IF ((IV.GT.0).OR.(IV.LE.NK)) GNDC=GNDC+1
      ELSE
        GNDC=GNDC+1
      ENDIF
      GOTO 7000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the input file is defectiv :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
9999  ERR=99
      WRITE(LOUT,9130) NCARD+1,NCARD+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the number of element groups:                           ***
C**   ----------------------------------                            ***
C**                                                                 ***
8888  CONTINUE
      NGROUP=0
      TOTNE=0
      DO 20 CLASS=0,3
        DO 20 FORM=1,8
          DO 20 GEOTYP=1,32
            TOTNE=TOTNE+GNE(CLASS,FORM,GEOTYP)
            IF (GNE(CLASS,FORM,GEOTYP).GT.0) THEN
	       NGROUP=NGROUP+1
               GROUP(CLASS,FORM,GEOTYP)=NGROUP
            ENDIF
 20   CONTINUE
      IF (OUTCNT.GT.0) THEN
         WRITE(LOUT,9010) GNDEG
         WRITE(LOUT,9020) NGROUP
         WRITE(LOUT,9025) TOTNE
         WRITE(LOUT,9035) GNDC
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT(' file statistics:')
9005  FORMAT(3X,'model name :'/3X,A75)
9010  FORMAT(3X,'number of geometrical nodes ............ NDEG = ',I9)
9020  FORMAT(3X,'number of groups ..................... NGROUP = ',I9)
9025  FORMAT(3X,'total number of elements .................... = ',I9)
9030  FORMAT(3X,'number of node forces ....................... = ',I9)
9035  FORMAT(3X,'number of node displacements ................ = ',I9)
9120  FORMAT ('>>VEMCD:01:0001:',I9/
     &        '>>illegal element SHAPE = ',I6,' in card ',I9)
9130  FORMAT ('>>VEMCD:01:9999:',I9/'>>read error in card ',I9)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of PAVE01-----------------------------------------------------
      E    N    D
