C:::::      ,,,,,PAVE09...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE PAVE09(UNITIN,NIT,IT,N)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    PAVE09   searchs for a specified packet type in a neutral    ***
C**             file. at the beginning the next record has to be    ***
C**             the header of data packet. at the end               ***
C**             the next record will be the first record            ***
C**             with packet type informations.                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNITIN,NIT
      INTEGER           IT(NIT),N(9)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNITIN I  I   I in  I unit of neutral file
C--------I------I-----I------------------------------------------------
C IT     I  I   I in  I list of the requested packet type ids
C        I      I     I array : IT(NIT)
C--------I------I-----I------------------------------------------------
C N      I  I   I out I packet header card
C        I      I     I N(1)=IT found packet type
C        I      I     I       (=-1 => packet types not found)
C        I      I     I N(2)=ID identification number
C        I      I     I N(3)=IV additional id
C        I      I     I N(4)=KC number of cards in the packet
C        I      I     I N(5)=
C        I      I     I N(6)=
C        I      I     I N(7)=  supplemental integer values
C        I      I     I N(8)=
C        I      I     I N(8)=
C        I      I     I array : N(9)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,RKC,RIT
      LOGICAL           TEST,FIRST
      CHARACTER*80      RECORD
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      FIRST=.TRUE.
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read current packet type :                                    ***
C**   ------------------------                                      ***
C**                                                                 ***
100   READ(UNITIN,'(I2,8I8)',END=8888,ERR=8888) (N(I),I=1,9)
      RIT=N(1)
      RKC=N(4)
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** RIT packet type in the selection list ?                       ***
C**   -------------------------------------                         ***
C**                                                                 ***
      TEST=.FALSE.
      DO 10 I=1,NIT
10      IF (IT(I).EQ.RIT) TEST=.TRUE.
C**                                                                 ***
C****** read remainding cards if paket type is not found:           ***
C**                                                                 ***
        IF (.NOT.TEST) THEN
         DO 1000 I=1,RKC
1000       READ (UNITIN,'(80A)') RECORD
         GOTO 100
        ELSE
	 GOTO 9999
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** if the requested packet types were not found the file is      ***
C**   rewinded:                                                     ***
C**   --------------------------------------------------------      ***
C**                                                                 ***
8888  CONTINUE
      IF (FIRST) THEN
        REWIND(UNITIN)
	FIRST=.FALSE.
        GOTO 100
      ELSE
	N(1)=-1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  R E T U R N
C**                                                                 ***
C-----End of PAVE09-----------------------------------------------------
      E    N    D
