c:::::     ,,,,,SHOWVT.....
c
c
c
c**********************************************************************
c        1         2         3         4         5         6         7*
c**********************************************************************
c**                                                                 ***
c**                                                                 ***
      subroutine SHOWVT(lmat,lindex,l,nproc,lsym,ia1,
     &                  info,mat,index,lmatbk,ptrmbk,ierr,
     &                  myproc,nvt,lout)
c**                                                                 ***
c**                                                                 ***
c**********************************************************************
c**                                                                 ***
c**   SHOWVT   Output and check of vector terms of the matrix,      ***
c**            which is defined by the arrays MAT, INFO and INDEX.  ***
c**                                                                 ***
c**********************************************************************
c**                                                                 ***
c**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1994        ***
c**     PROGRAMMER: H. Haefner     F.Seegmueller                    ***
c**                                                                 ***
c**********************************************************************
c**                                                                 ***
c**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
c**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
c**                                                                 ***
      implicit none
c**                                                                 ***
c**-----------------------------------------------------------------***
c**                                                                 ***
c**      FORMAL PARAMETERS :                                        ***
c**      -----------------                                          ***
c**                                                                 ***
      include 'const.h'
      include 'maxnpe.h'
      integer lmat,lindex,l,ia1,nproc,ierr
      integer myproc,nvt,lout
      integer index(lindex),info(ia1,ia2)
      integer lmatbk(nproc),ptrmbk(nproc+1)
      double precision mat(lmat)
      logical lsym
c**                                                                 ***
c**   LIST OF FORMAL PARAMETERS :                                   ***
c**   -------------------------                                     ***
c**                                                                 ***
c**   (see Manual-Pages <linsol>)                                   ***
c**                                                                 ***
c**                                                                 ***
c**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
c**                                                                 ***
      integer i,j,pos,posidx,length,row,column,indr,indc
      integer posidc,posidr,typ,llout
      logical intest     
      character*16 ctyp
c     character*80 name
c**
c**                                                                 ***
c**** START OF CALCULATION :
c**   ----------------------
c**
      ierr = 0
      llout = lout
c**
c***  output file settling
c**
c     if (nproc .eq. 1) then
c
c output in standard output with unit number LOUT
c
      if ((llout .lt. 0) .or. (llout .gt. 99)) llout = 6 
c     else if ((nproc .gt. 1) .and. (nproc .le. maxnpe)) then
c
c output in file 'output.proc.nr<MYPROC>'
c
c        llout = 60 + myproc
c        write(name,500) myproc
c        open(llout,file=name)
c     else 
c        if ((llout .lt. 0) .or. (llout .gt. 99)) llout = 6 
c        write(llout,2000) maxnpe
c        ierr = 1
c        goto 9999
c     endif
c**
c***  check array bounds of array INFO
c**
      if (ia1 .lt. nvt) then
	 write(llout,410) 
	 ierr = 1
	 goto 9999
      endif
c     
      if (ia2 .lt. 7) then
	 write(llout,420) 
	 ierr = 1
	 goto 9999
      endif
c**
c***  Output of vector terms 
c**
      write(llout,100) 
      write(llout,110)
      write(llout,990) myproc
      do 200 i=1,nvt
         intest = .false.
         typ = info(i,1)
c
   	 if ((typ .eq. 10) .or. (typ .eq. 1)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' main diagonal'
	    pos    = info(i,2)
            length = info(i,3)
	    column = info(i,4) + 1
	    row    = info(i,5) + 1
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 10 j=1,length
	       column = info(i,4) + j
	       row    = info(i,5) + j
               write(llout,1020) row,column,mat(pos+j)
   10       continue
c 
   	 elseif ((typ .eq. 20) .or. (typ .eq. 2)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' full diagonal'
	    pos    = info(i,2)
	    length = info(i,3)
	    column = info(i,4) + 1
	    row    = info(i,5) + 1
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 20 j=1,length
               column = info(i,4) + j
 	       row    = info(i,5) + j
               write(llout,1020) row,column,mat(pos+j)
   20       continue
c
   	 elseif ((typ .eq. 30) .or. (typ .eq. 3)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' packed diagonal'
	    pos    = info(i,2)
	    length = info(i,3)
	    indc   = info(i,6)
	    posidx = index(indc+1)
	    column = info(i,4) + posidx
	    row    = info(i,5) + posidx
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 30 j=1,length 
	       posidx = index(indc+j)
 	       column = info(i,4) + posidx
 	       row    = info(i,5) + posidx
               write(llout,1030) posidx,row,column,mat(pos+j)
   30       continue
c
   	 elseif ((typ .eq. 40) .or. (typ .eq. 4)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' indexed column'
            pos    = info(i,2)
            length = info(i,3)
            posidx = info(i,6)
            indc   = index(posidx+1)
            column = info(i,4) + indc
            row    = info(i,5) + 1
            write(llout,1000) real(i),ctyp,typ
            write(llout,1010) row,column,length 
            do 40 j=1,length
               indc   = index(posidx+j)
 	       column = info(i,4) + indc
 	       row    = info(i,5) + j
               write(llout,1033) indc,row,column,mat(pos+j)
   40       continue
c
   	 elseif ((typ .eq. 50) .or. (typ .eq. 5)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' indexed row'
	    pos    = info(i,2)
	    length = info(i,3)
	    posidx = info(i,7)
            indr   = index(posidx+1)
	    column = info(i,4) + 1
	    row    = info(i,5) + indr
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 50 j=1,length
	       indr   = index(posidx+j)
 	       row    = info(i,5) + indr
 	       column = info(i,4) + j
               write(llout,1037) indr,row,column,mat(pos+j)
   50       continue
c
         elseif ((typ .eq. 60) .or. (typ .eq. 6)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' starry sky'
	    pos    = info(i,2)
	    length = info(i,3)
	    posidc = info(i,6)
	    posidr = info(i,7)
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1016) length 
 	    do 60 j=1,length
	       indc   = index(posidc+j)
               indr   = index(posidr+j)
               column = indc
               row    = indr
               write(llout,1040) indr,indc,row,column,mat(pos+j)
   60       continue
c
         elseif ((typ .eq. 70) .or. (typ .eq. 7)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' full row'
	    pos    = info(i,2)
	    length = info(i,3)
	    column = info(i,4) + 1
	    row    = info(i,5) + 1
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 70 j=1,length
 	       column = info(i,4) + j
              write(llout,1020) row,column,mat(pos+j)
   70       continue
c
   	 elseif ((typ .eq. 80) .or. (typ .eq. 8)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' full column'
	    pos    = info(i,2)
	    length = info(i,3)
	    column = info(i,4) + 1
	    row    = info(i,5) + 1
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 80 j=1,length
 	       row = info(i,5) + j
               write(llout,1020) row,column,mat(pos+j)
   80       continue
c
         elseif ((typ .eq. 90) .or. (typ .eq. 9)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' packed row'
	    pos    = info(i,2)
	    length = info(i,3)
            posidx = info(i,6)
            indc   = index(posidx+1)
	    column = info(i,4) + indc
	    row    = info(i,5) + 1
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 90 j=1,length
               indc   = index(posidx+j)
 	       column = info(i,4) + indc
               write(llout,1033) indc,row,column,mat(pos+j)
   90       continue
c
   	 elseif ((typ .eq. 100) .or. (typ .eq. 11)) then
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
	    ctyp   = ' packed column'
	    pos    = info(i,2)
	    length = info(i,3)
	    posidx = info(i,7)
	    indr   = index(posidx+1)
	    column = info(i,4) + 1
	    row    = info(i,5) + indr
	    write(llout,1000) real(i),ctyp,typ
	    write(llout,1010) row,column,length 
 	    do 101 j=1,length
	       indr   = index(posidx+j)
 	       row    = info(i,5) + indr
               write(llout,1037) indr,row,column,mat(pos+j)
  101       continue
c
         else
            call TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,i,intest,llout) 
	    if (intest) goto 199 
c	    
         endif
         write(llout,*) ' '
c
  199    continue
         if (intest) then 
	    write(llout,4000) 
	    ierr = ierr + 1
         endif
c
  200 continue
c**
c***  Check if symmetric matrix is given
c**
      write(llout,1050) lsym
      if (lsym) then
         write(llout,1060) 
      else
         write(llout,1070) 
      endif
c**
c***
c**
      if (ierr .eq. 0) then
         write(llout,4010)
      else 
	 write(llout,4020) ierr
      endif
c**
c***
c**
 9999 continue
c**
c***  END OF CALCULATION
c***  ------------------
c**
c
  100 format('Vector terms of matrix M = m(i,j) defined by',
     &       ' arrays MAT, INFO and INDEX.')
  110 format('--------------------------------------------',
     &       '----------------------------' /)
  410 format(' *** SHOWVT: error detected;',/
     &       '             first dimension of array INFO',/
     &       '             too small: IA1 is less than NVT.'/)
  420 format(' *** SHOWVT: error detected;',/
     &       '             second dimension of array INFO',/
     &       '             too small: IA2 is less than 7.'/)
c 500 format('output.proc.nr',i3.3)
  990 format(' Vector terms of matrix on processor ',i4,':' /)
 1000 format(f5.0,' vector term is ',a16,' (type = ',i2,') : ')
 1010 format(7x,'starting in row ',i4,' , column ',i4,
     &       ' , length: ',i4)
 1016 format(7x,'with length: ',i4)
 1020 format(7x,'m(',i4,',',i4,') = ',d17.10)
 1030 format(7x,'index = ',i4,' , m(',i4,',',i4,') = ',d17.10)
 1033 format(7x,'col-index = ',i4,' , m(',i4,',',i4,') = ',d17.10)
 1037 format(7x,'row-index = ',i4,' , m(',i4,',',i4,') = ',d17.10)
 1040 format(7x,'row-index = ',i4,' , col-index = ',i4,
     &       ' , m(',i4,',',i4,') = ',d17.10)
 1050 format(' LSYM = ',l1)
 1060 format(' ==> LINSOL uses a symmetric matrix A with elements',
     &       ' m(i,j)+m(j,i)', /
     &       '     in row i, column j and row j, column i for i<>j ',
     &       'and with ',/
     &       '     m(i,i) in the main diagonal.'/)
 1070 format(' ==> LINSOL uses the given unsymmetric matrix M',/
     &       '     (defined by the arrays MAT, INFO, INDEX).'/)
 2000 format(' *** SHOWVT: error detected; ',/
     &       '             NPROC = number of used processors ',
     &       '             has to be >= 1 and <=',i4)
 4000 format(
     & '      No output because of incorrect defined vector term.'/)
 4010 format(' All vector terms checked: no error detected.'/)
 4020 format(' *** SHOWVT: errors detected; ',/
     &       '            ',i4,' vector terms incorrect defined.'/
     &       '             Check input parameters and ',
     &       'arrays INFO, INDEX.'/)
c
      r e t u r n
c-----END OF SHOWVT---------------------------------------------------      
      e n d
