c:::::     ,,,,,TESTVT.....
c
c
c
c**********************************************************************
c        1         2         3         4         5         6         7*
c**********************************************************************
c**                                                                 ***
c**                                                                 ***
      subroutine TESTVT(ia1,lindex,nproc,myproc,l,lmat,info,
     &                  index,lmatbk,ptrmbk,ivt,intest,lout)
c**                                                                 ***
c**                                                                 ***
c**********************************************************************
c**                                                                 ***
c**     TESTVT   Test of IVT-th vectorterm of matrix MAT            ***
c**                                                                 ***
c**********************************************************************
c**                                                                 ***
c**     COPYRIGHT UNIVERSITAET KARLSRUHE RECHENZENTRUM  1994        ***
c**     PROGRAMMER: H. Haefner     F.Seegmueller                    ***
c**                                                                 ***
c**********************************************************************
c**                                                                 ***
c**     THE IMPLICIT NONE-INSTRUCTION HAS THE AIM,                  ***
c**     THAT ALL VARIABLES MUST BE DECLARED EXPLICITLY.             ***
c**                                                                 ***
      implicit none
c**                                                                 ***
c**-----------------------------------------------------------------***
c**                                                                 ***
c**      FORMAL PARAMETERS :                                        ***
c**      -----------------                                          ***
c**                                                                 ***
      include 'const.h'
      integer ia1,nproc,myproc,lindex,ivt,l,lmat,lout
      integer info(ia1,ia2),index(lindex)
      integer lmatbk(nproc),ptrmbk(nproc+1)
      logical intest     
c**                                                                 ***
c**   LIST OF FORMAL PARAMETERS :                                   ***
c**   -------------------------                                     ***
c**                                                                 ***
c**   (see Manual-Pages <linsol>)                                   ***
c**                                                                 ***
c**                                                                 ***
c**      LOCAL PARAMETERS :                                         ***
C**      -----------------                                          ***
c**                                                                 ***
      integer r,c,pos,len,posidr,posidc,indc,indr,i
      integer typ,row,col,startr,endr,endc
      logical test
c**
c**                                                                 ***
c**** START OF CALCULATION :
c**   ----------------------
c**
c***  Initialisation
c**
      intest = .false.
      test   = .false.
      typ    = info(ivt,1)
      startr = ptrmbk(myproc) + 1
      endr   = ptrmbk(myproc) + lmatbk(myproc)
c**
c***  Number of columns of matrix MAT
c**
      endc   = 0
      do 10 i=1,nproc
	 endc = endc + lmatbk(i)
  10  continue
c**
c***  Check if IVT-th vector term is within array INFO
c**
      if (ivt .gt. ia1) then
	 write(lout,3500) ivt,typ,ivt,ia1,ivt
	 test = .true.
	 goto 9999
      endif
c** 
c***  Check of IVT-th vector term of type TYP
c**

      if ((typ .eq. 1) .or. (typ .eq. 10)) then
         pos  = info(ivt,2)
	 len  = info(ivt,3)
	 c    = info(ivt,4)
	 r    = info(ivt,5)
c
c Check vector term position in array MAT
c
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len).lt.1).or.((pos+len).gt.lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
c
c Check length of main diagonal if working on one processor
c
         if (nproc .eq. 1) then
	    if (endc .ne. len) then
	       write(lout,2000) ivt,typ,len,l,ivt
	       test = .true. 
	       goto  9999
            endif
         endif
c
c Check positions of vector term elements
c
         col = c + 1
	 row = r + 1
         if ((startr.gt.row).or.(1.gt.col)) test = .true.    
	 col = c + len
         row = r + len 
         if (row .gt. endr) test = .true.
	 if (col .gt. endc) test = .true.
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 2) .or. (typ .eq. 20)) then
	 pos  = info(ivt,2)
	 len  = info(ivt,3)
	 c    = info(ivt,4)
	 r    = info(ivt,5)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len).lt.1).or.((pos+len).gt.lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         col = c + 1
	 row = r + 1
         if ((startr.gt.row).or.(1.gt.col)) test = .true.    
	 col = c + len
         row = r + len 
         if (row .gt. endr) test = .true.
	 if (col .gt. endc) test = .true.
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 3) .or. (typ .eq. 30)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
	 posidc = info(ivt,6)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 if ((posidc .lt. 0).or.(posidc .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidc+len.lt.1).or.(posidc+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 do 30 i=1,len
	    indc = index(posidc+i)
            row  = r + indc
	    col  = c + indc
            if ((startr.gt.row).or.(1.gt.col)) test = .true.    
            if (row .gt. endr) test = .true.
	    if (col .gt. endc) test = .true.
  30     continue
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 4) .or. (typ .eq. 40)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
	 posidc = info(ivt,6)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 if ((posidc .lt. 0).or.(posidc .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidc+len.lt.1).or.(posidc+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 do 40 i=1,len
	    indc = index(posidc+i)
            row  = r + i
	    col  = c + indc
            if ((startr.gt.row).or.(1.gt.col)) test = .true.    
            if (row .gt. endr) test = .true.
	    if (col .gt. endc) test = .true.
  40     continue
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 5) .or. (typ .eq. 50)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
	 posidr = info(ivt,7)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 if ((posidr .lt. 0).or.(posidr .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidr+len.lt.1).or.(posidr+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 do 50 i=1,len
	    indr = index(posidr+i)
            row  = r + indr
	    col  = c + i
            if ((startr.gt.row).or.(1.gt.col)) test = .true.    
            if (row .gt. endr) test = .true.
	    if (col .gt. endc) test = .true.
  50     continue
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 6) .or. (typ .eq. 60)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 posidc = info(ivt,6)
	 posidr = info(ivt,7)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 if ((posidc .lt. 0).or.(posidc .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidc+len.lt.1).or.(posidc+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidr .lt. 0).or.(posidr .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidr+len.lt.1).or.(posidr+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 do 60 i=1,len
	    col = index(posidc+i)
	    row = index(posidr+i)
            if ((startr.gt.row).or.(1.gt.col)) test = .true.    
            if (row .gt. endr) test = .true.
	    if (col .gt. endc) test = .true.
  60     continue
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 7) .or. (typ .eq. 70)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 row = r + 1
	 col = c + 1
         if ((startr .gt. row).or.(1 .gt. col)) test = .true.
         col = c + len
         if ((row .gt. endr).or.(col .gt. endc)) test = .true.    
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 8) .or. (typ .eq. 80)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 row = r + 1
	 col = c + 1
         if ((startr .gt. row).or.(1 .gt. col)) test = .true.
         row = r + len
         if ((row .gt. endr).or.(col .gt. endc)) test = .true.    
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 9) .or. (typ .eq. 90)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
	 posidc = info(ivt,6)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 if ((posidc .lt. 0).or.(posidc .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidc+len.lt.1).or.(posidc+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 do 90 i=1,len
	    indc = index(posidc+i)
            row  = r + 1
	    col  = c + indc
            if ((startr.gt.row).or.(1.gt.col)) test = .true.    
            if (row .gt. endr) test = .true.
	    if (col .gt. endc) test = .true.
  90     continue
	 if (test) write(lout,1000) ivt,typ

      else if ((typ .eq. 11) .or. (typ .eq. 100)) then
	 pos    = info(ivt,2)
	 len    = info(ivt,3)
	 c      = info(ivt,4)
	 r      = info(ivt,5)
	 posidr = info(ivt,7)
         if ((pos .lt. 0).or.(pos .ge. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
         if (((pos+len) .lt. 1).or.((pos+len) .gt. lmat)) then
	    write(lout,4010) ivt,typ,ivt,ivt
	    test = .true. 
	    goto 9999
         endif
	 if ((posidr .lt. 0).or.(posidr .ge. lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 if ((posidr+len.lt.1).or.(posidr+len.gt.lindex)) then
	    write(lout,4020) ivt,typ,ivt,ivt,ivt
	    test = .true.
	    goto 9999
         endif
	 do 100 i=1,len
	    indr = index(posidr+i)
            row  = r + indr
	    col  = c + 1
            if ((startr.gt.row).or.(1.gt.col)) test = .true.    
            if (row .gt. endr) test = .true.
	    if (col .gt. endc) test = .true.
 100     continue
	 if (test) write(lout,1000) ivt,typ


      else
	 write(lout,3000) ivt,typ,typ,ivt
	 test = .true.
      endif

 9999 continue
      intest = test
c**
c***  Formats
c**
 1000 format(i5,'. vector term (type = ',i2,'): ',/
     &       '      *** TESTVT: error detected;'/ 
     &       '                  vector term has elements m(i,j) ',
     &       'with non-',/
     &       '                  existent matrix positions (i,j).',/
     &       '      Check input parameters and arrays INFO, INDEX.')
 2000 format(i5,'. vector term (typ = ',i2,'): main diagonal',/
     &       '      *** TESTVT: error detected;',/
     &       '                  Length of main diagonal (= ',i4,') ',/
     &       '                  is not equal to L (=',i4,').',/
     &       '      Check L or INFO(',i4,',3).')
 3000 format(i5,'. vector term (type = ',i2,'):',/ 
     &       '      *** TESTVT: error detected;',/
     &       '                  Vector term of type ',i4,
     &       ' does not exist.',/
     &       '      Check INFO(',i4,',1).')
 3500 format(i5,'. vector term (type = ',i2,'):',/ 
     &       '      *** TESTVT: error detected;',/
     &       '                  ',f5.0,' vector term does not exist', 
     &       ' in array INFO.',/
     &       '      Check IA1 (= ',i4,') or IVT (= ',i4,').')
 4010 format(i5,'. vector term (type = ',i2,'):',/
     &       '      *** TESTVT: error detected;',/
     &       '                  vector term uses elements ',
     &       'out of array MAT.',/ 
     &       '      Check LMAT, INFO(',i4,',2) and INFO(',i4,',3).')
 4020 format(i5,'. vector term (type = ',i2,'):',/
     &       '      *** TESTVT: error detected;',/
     &       '                  vector term uses indices ',
     &       'out of array INDEX.',/
     &       '      Check LINDEX, INFO(',i4,',3), INFO(',i4,',6) ',
     &       'and INFO(',i4,',7).')
c**
c***
c**
      r e t u r n
c-----END OF TESTVT---------------------------------------------------      
      e n d
