C:::::      ,,,,,VEAV00...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEAV00(NDEGL,DIM,NGROUP,GINFO1,GINFO,NESUM,N,NCELL,
     &                  LBFIN,LBFRN,LBFN,
     &                  LBFRE,LBFIE,LBFE,LBFRR,LBFIR,LBFR,
     &                  IOTID,MYPROC,NPROC,TIDS,NMSG,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEAV00   compute buffer sizes to collect data for UCD file    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights by Lutz Grosz, 1997                           ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDEGL,NGROUP,GINFO1,LBFIN,LBFRN,LBFN,NCELL,
     &                  LBFRE,LBFIE,LBFE,LBFRR,LBFIR,LBFR,DIM,N,
     &                  IOTID,MYPROC,NPROC,NMSG,LOUT,ERR
      INTEGER           GINFO(GINFO1,NGROUP),TIDS(NPROC),NESUM(NGROUP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  arrary: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NESUM  I  I   I in  I global number of elements  arrary: NESUM(NGROUP)
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of result values per node
C--------I------I-----I------------------------------------------------
C NCELL  I  I   I out I number of element will be written
C--------I------I-----I------------------------------------------------
C LBFIN  I  I   I out I length of integer buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFRN  I  I   I out I length of real buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFN   I  I   I out I length of buffer to write nodes in IBIG
C--------I------I-----I------------------------------------------------
C LBFIE  I  I   I out I length of integer buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFRE  I  I   I out I length of real buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFE   I  I   I out I length of buffer to write elements in IBIG
C--------I------I-----I------------------------------------------------
C LBFIR  I  I   I out I length of integer buffer to write nodal results
C--------I------I-----I------------------------------------------------
C LBFRR  I  I   I out I length of real buffer to write nodal results
C--------I------I-----I------------------------------------------------
C LBFR   I  I   I out I length of buffer to write nodal results in IBIG
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I task id of i/o-task
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit for messages
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (is global)
C        I      I     I =96 illegal AVS element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,FORM,NIVP,CLASS,NVERT,
     &                  ZW(32),MYTID,H3(10),H1(10),H2(10),CTYPE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      ERR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   nodes:                                                        ***
C**   -----                                                         ***
C**                                                                 ***
      LBFRN=DIM*NDEGL
      LBFIN=2+NDEGL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 4 I=1,32
 4     ZW(I)=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** elements:                                                     ***
C**   ---------                                                     ***
C**                                                                 ***
      LBFIE=3*NGROUP
      LBFRE=0
      NCELL=0
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        NIVP  =GINFO(17,G)
	IF (NE*NIVP.GT.0) THEN
          CALL VEAV10(CLASS,FORM,GEOTYP,CTYPE,NVERT,ZW)
	  IF (NVERT.EQ.0) THEN
	    ERR=96
	    IF (MYTID.EQ.IOTID) WRITE(LOUT,9110) FORM,CLASS,GEOTYP,
     &                                            G,FORM,CLASS,GEOTYP
          ENDIF
          LBFIE=LBFIE+NE*(NVERT+3)
          NCELL=NCELL+NESUM(G)
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   results:                                                      ***
C**   --------                                                      ***
C**                                                                 ***
      LBFRR=N*NDEGL
      LBFIR=2+NDEGL*N
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** global buffer length is set:                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      H1(1)=ERR
      H1(2)=LBFRN
      H1(3)=LBFIN
      H1(4)=LBFRE
      H1(5)=LBFIE
      H1(6)=LBFRR
      H1(7)=LBFIR
      CALL LL4INM(1,7,1,H1,H2,H3,MYPROC,NPROC,TIDS,NMSG)
      ERR=H2(1)
      LBFRN=H2(2)
      LBFIN=H2(3)
      LBFRE=H2(4)
      LBFIE=H2(5)
      LBFRR=H2(6)
      LBFIR=H2(7)
      LBFE=RPI*(LBFRE+(LBFIE+RPI-1)/RPI)
      LBFR=RPI*(LBFRR+(LBFIR+RPI-1)/RPI)
      LBFN=RPI*(LBFRN+(LBFIN+RPI-1)/RPI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
9110  FORMAT ('>>VEMCD:02:0100',3(':',I3)
     &       /'>>An element type is not allowed in AVS:'
     &       /'>>GROUP= ',I2,', FORM= ',I2,', CLASS= ',I2,
     &                                                 ', GEOTYP= ',I2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEAV00----------------------------------------------------
      E    N    D
