C:::::      ,,,,,VEAV03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEAV03 (UCDOUT,NODNUM,NGROUP,GINFO1,GINFO,
     &                   LNEK,NEK,LIPRM,IPARM,LBF,IBUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEAV03     write element data to UCD file                     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights by Lutz Grosz, Canberra, 1997                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UCDOUT,LBF,GINFO1,NGROUP,LIPRM,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,NCARD
      INTEGER           TIDS(NPROC),IBUF(LBF),NODNUM(*),
     &                  GINFO(GINFO1,NGROUP),IPARM(LIPRM),NEK(LNEK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UCDOUT I  I   I in  I output file unit
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(*)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                  array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer parameters for elements
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                array: IBUF(LBFI)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer                   array: RBUF(LBFR)
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I i/o task id
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           ID,GEOTYP,I,G,NE,ADIVP,CTYPE0,TOKEN(1),IVP1,
     &                  ADDGEO,FORM,GEO1,NIVP,CLASS,NE0,ID0,INFO,
     &                  ZW(32),CTYPE,Z,MYTID,NODES0,P,MIDS,MIDR,NVERT,
     &                  NVERT0,NMAT0,NMAT
      CHARACTER*5       CNAME(7)
      DATA CNAME/'pt','line','tri','quad','tet','prism','hex'/
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   copy elements to buffer :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      CTYPE0=0
      NVERT0=CTYPE0+NGROUP
      NE0=NVERT0+NGROUP
      ID0=NE0+NGROUP
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
        ADIVP =GINFO(15,G)
        IVP1  =GINFO(16,G)
        NIVP  =GINFO(17,G)
	IF (NE*NIVP.GT.0) THEN
	  NMAT0=ID0+NE
	  NODES0=NMAT0+NE
          DO 4 I=1,GEOTYP
 4          ZW(I)=I
          CALL VEAV10(CLASS,FORM,GEOTYP,CTYPE,NVERT,ZW)
	  DO 250 Z=1,NE

            DO 251 I=1,NVERT
               IBUF(NODES0+NVERT*(Z-1)+I)=
     &                NODNUM(NEK(ADDGEO-1+GEO1*(ZW(I)-1)+Z))
251         CONTINUE

	    IBUF(ID0+Z)=IPARM(ADIVP-1+Z)
            IF (NIVP.GT.1) THEN
              IBUF(NMAT0+Z)=IPARM(ADIVP-1+IVP1+Z)
            ELSE
              IBUF(NMAT0+Z)=G
            ENDIF

 250      CONTINUE
          ID0=NODES0+NE*(NVERT+2)
          IBUF(CTYPE0+G)=CTYPE
          IBUF(NVERT0+G)=NVERT
	  IBUF(NE0+G)=NE
        ELSE
          IBUF(CTYPE0+G)=0
          IBUF(NVERT0+G)=0
          IBUF(NE0+G)=0
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements                                                ***
C**   --------------                                                ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,MIDR,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,MIDR,INFO)
          ENDIF
	  CTYPE0=0
	  NVERT0=CTYPE0+NGROUP
	  NE0=NVERT0+NGROUP
	  ID0=NE0+NGROUP
	  DO 300 G=1,NGROUP
	    CTYPE=IBUF(CTYPE0+G)
	    NVERT=IBUF(NVERT0+G)
	    NE=IBUF(NE0+G)

	    IF (NE*NVERT.GT.0) THEN
	      NMAT0=ID0+NE
	      NODES0=NMAT0+NE
	      DO 350 Z=1,NE
	        ID=IBUF(ID0+Z)
	        NMAT=IBUF(NMAT0+Z)
                WRITE(UCDOUT,'(I9,I6,1X,A,1X,20I9)')
     &                         ID,NMAT,CNAME(CTYPE),
     &                        (IBUF(NODES0+NVERT*(Z-1)+I),I=1,NVERT)
		NCARD=NCARD+1
 350          CONTINUE
	      ID0=NODES0+NE*(NVERT+2)
            ENDIF

 300      CONTINUE
400     CONTINUE
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEAV03----------------------------------------------------
      E    N    D
