C:::::      ,,,,,VEAV07...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEAV07(UCDOUT,NODNUM,U,N,U1,NDEG,LABEL,FTYPE,LIMIT,
     &                  SBT,LBFI,IBUF,LBFR,RBUF,NDEGL,NDEG0L,
     &                  IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEAV07    write results at geometrical nodes to UCD file   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights by Lutz Grosz, Canberra, 1997                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UCDOUT,U1,N,NDEG,NDEGL,NDEG0L,FTYPE,
     &                  IOTID,MYPROC,NPROC,NMSG,LBFI,LBFR,
     &                  NCARD,SBT
      INTEGER           NODNUM(NDEG),IBUF(LBFI,SBT),TIDS(NPROC)
      DOUBLE PRECISION  U(U1,N),RBUF(LBFR,SBT),LIMIT
      CHARACTER*80      LABEL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UCDOUT I  I   I in  I unit of output file
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of results per node
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I results an geometrical nodes      array: U(U1,N)
C--------I------I-----I------------------------------------------------
C LABEL  I C*80 I in  I name of the results
C--------I------I-----I------------------------------------------------
C FTYPE  I  I   I in  I result type (=0 unknown, =1 scalar, =2 vector)
C--------I------I-----I------------------------------------------------
C LIMIT  I  R   I in  I only results lower LIMIT are written
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer            array: IBUF(LBFI,SBT)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer               array: RBUF(LBFR,SBT)
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C NDEG0L I  I   I in  I first geometrical node-1 in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           J,TOTID,FRTID,LL9MAP,P,MIDS1,MIDR1,NH,INFO,
     &                  Z,MYTID,TOKEN(1),MIDR2,MIDS2,NDV,I,
     &                  SWPBUF,RCVBUF,SNDBUF
      DOUBLE PRECISION  ZERO
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ZERO=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of the results:                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOTID=TIDS(LL9MAP(MYPROC+1,NPROC))
      FRTID=TIDS(LL9MAP(MYPROC-1,NPROC))
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
	
      IBUF(1,SNDBUF)=NDEGL
      IBUF(2,SNDBUF)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,IBUF(1,RCVBUF),MIDR1,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
          ENDIF
	  DO 101 Z=3,LBFI
101         IBUF(Z,RCVBUF)=0
	  DO 102 Z=1,LBFR
102           RBUF(Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPSNDW(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,IBUF(1,RCVBUF),MIDR1,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LBFI,IBUF(1,RCVBUF),MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LBFI,IBUF(1,RCVBUF),MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
        ENDIF
C**                                                                 ***
        NDEGL=IBUF(1,RCVBUF)
        NDEG0L=IBUF(2,RCVBUF)
	DO 131 J=1,N
	  DO 131 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL).AND.(U(Z,J).LT.LIMIT)) THEN
       	      RBUF(N*(NH-1)+J,RCVBUF)=U(Z,J)
	      IBUF(2+N*(NH-1)+J,RCVBUF)=1
            ENDIF
131     CONTINUE
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) 
     &       CALL MPSNDW(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
	ELSE
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
100   CONTINUE
      NMSG=NMSG+NPROC*2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the entries :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
       DO 240 J=2,N
         DO 240 Z=1,NDEGL
          IBUF(2+N*(Z-1)+1,SNDBUF)=IBUF(2+N*(Z-1)+1,SNDBUF)+
     &                     IBUF(2+N*(Z-1)+J,SNDBUF)
240    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write header card:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        IF (FTYPE.EQ.1) THEN
          WRITE(UCDOUT,*) 1,1
          WRITE(UCDOUT,*) LABEL(:INDEX(LABEL,' ')-1),','
          NDV=1
	  NCARD=NCARD+2
        ELSEIF (FTYPE.EQ.2) THEN
          WRITE(UCDOUT,*) 1,3
          WRITE(UCDOUT,*) LABEL(:INDEX(LABEL,' ')-1),','
          NDV=3
	  NCARD=NCARD+2
        ELSE
          WRITE(UCDOUT,*) N,(I,I=1,N)
          DO 230 I=1,N
  230       WRITE(UCDOUT,*) LABEL(:INDEX(LABEL,' ')-1),' ',I,','
          NDV=N
	  NCARD=NCARD+N+1
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write node results :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                    MIDR1,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+2*NPROC,IREAL*LBFR,
     &                                      RBUF(1,SNDBUF),MIDR2,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                    MIDR1,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+2*NPROC,IREAL*LBFR,
     &                                      RBUF(1,SNDBUF),MIDR2,INFO)
          ENDIF
          NDEGL=IBUF(1,SNDBUF)
          NDEG0L=IBUF(2,SNDBUF)
          DO 300 Z=1,NDEGL
            IF (IBUF(2+N*(Z-1)+1,SNDBUF).EQ.N) THEN
              WRITE(UCDOUT,'(I9,99F26.16)') Z+NDEG0L,
     &              (RBUF(N*(Z-1)+J,SNDBUF),J=1,N),(ZERO,J=N+1,NDV)
	      NCARD=NCARD+1
            ENDIF
 300      CONTINUE
400     CONTINUE
      ELSE
	CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR1,INFO)
	CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR1,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                    MIDS1,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+2*NPROC,IREAL*LBFR,
     &                                     RBUF(1,SNDBUF),MIDS2,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBFI,IBUF(1,SNDBUF),
     &                                                    MIDS1,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+2*NPROC,IREAL*LBFR,
     &                                     RBUF(1,SNDBUF),MIDS2,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEAV07----------------------------------------------------
      E    N    D
